/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.navigation.ui.filter;

import org.eclipse.riena.core.util.StringMatcher;
import org.eclipse.riena.core.util.StringUtils;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.NavigationNodeUtility;
import org.eclipse.riena.ui.ridgets.IRidget;

public class RidgetMatcher {
    private String id;

    public RidgetMatcher(String idPattern) {
        this.setId(idPattern);
    }

    public boolean matches(Object ... args) {
        if (args == null || args.length <= 0) {
            return false;
        }
        if (!(args[0] instanceof IRidget)) {
            return false;
        }
        IRidget ridget = (IRidget)args[0];
        String ridgetId = ridget.getID();
        if (args.length == 1) {
            return StringUtils.equals((CharSequence)ridgetId, (CharSequence)this.getId());
        }
        if (args[1] instanceof INavigationNode) {
            String nodeId = NavigationNodeUtility.getNodeLongId((INavigationNode)((INavigationNode)args[1]));
            String longRidgetId = String.valueOf(nodeId) + "/" + ridgetId;
            StringMatcher matcher = new StringMatcher(this.getId());
            return matcher.match(longRidgetId);
        }
        return false;
    }

    public void setId(String id) {
        this.id = id;
    }

    protected String getId() {
        return this.id;
    }
}

