/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.sample.snippets;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.riena.beans.common.WordNode;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.IActionRidget;
import org.eclipse.riena.ui.ridgets.IGroupedTreeTableRidget;
import org.eclipse.riena.ui.ridgets.swt.SwtRidgetFactory;
import org.eclipse.riena.ui.swt.utils.UIControlsFactory;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public class SnippetTreeTableRidget004 {
    public SnippetTreeTableRidget004(Shell shell) {
        Tree tree = new Tree((Composite)shell, 65538);
        int i = 0;
        while (i < 2) {
            TreeColumn tc = new TreeColumn(tree, -1);
            tc.setWidth(200);
            ++i;
        }
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)tree);
        Button button = new Button((Composite)shell, 8);
        button.setText("Toggle &Grouping");
        GridDataFactory.swtDefaults().align(0x1000008, 1).applyTo((Control)button);
        final IGroupedTreeTableRidget treeTableRidget = (IGroupedTreeTableRidget)SwtRidgetFactory.createRidget((Object)tree);
        Object[] roots = this.createTreeInput();
        String[] columnValues = new String[]{"word", "upperCase"};
        String[] columnHeaders = new String[]{"Word", "Uppercase"};
        treeTableRidget.bindToModel(roots, WordNode.class, "children", "parent", columnValues, columnHeaders);
        treeTableRidget.expandAll();
        IActionRidget actionRidget = (IActionRidget)SwtRidgetFactory.createRidget((Object)button);
        actionRidget.addListener(new IActionListener(){

            public void callback() {
                boolean isGrouping = !treeTableRidget.isGroupingEnabled();
                treeTableRidget.setGroupingEnabled(isGrouping);
                System.out.println("Grouping enabled? " + isGrouping);
            }
        });
    }

    public static void main(String[] args) {
        Display display = Display.getDefault();
        try {
            Shell shell = UIControlsFactory.createShell((Display)display);
            GridLayoutFactory.swtDefaults().applyTo((Composite)shell);
            new SnippetTreeTableRidget004(shell);
            shell.pack();
            shell.open();
            while (!shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
        finally {
            display.dispose();
        }
    }

    private WordNode[] createTreeInput() {
        WordNode root = new WordNode("Words");
        WordNode bTowns = new WordNode(root, "B");
        new WordNode(bTowns, "Boring");
        new WordNode(bTowns, "Buchanan");
        new WordNode(bTowns, "Beaverton").setUpperCase(true);
        new WordNode(bTowns, "Bend");
        new WordNode(bTowns, "Black Butte Ranch");
        new WordNode(bTowns, "Baker City");
        new WordNode(bTowns, "Bay City");
        new WordNode(bTowns, "Bridgeport");
        WordNode cTowns = new WordNode(root, "C");
        new WordNode(cTowns, "Cedar Mill");
        new WordNode(cTowns, "Crater Lake");
        new WordNode(cTowns, "Coos Bay");
        new WordNode(cTowns, "Corvallis");
        new WordNode(cTowns, "Cannon Beach");
        WordNode dTowns = new WordNode(root, "D");
        new WordNode(dTowns, "Dunes City");
        new WordNode(dTowns, "Damascus");
        new WordNode(dTowns, "Diamond Lake");
        new WordNode(dTowns, "Dallas");
        new WordNode(dTowns, "Depoe Bay");
        return new WordNode[]{root};
    }
}

