/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.communication.core.proxyselector;

import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.riena.communication.core.proxyselector.ManualProxySelector;
import org.eclipse.riena.core.test.collect.NonUITestCase;

@NonUITestCase
public class ManualProxySelectorTest
extends TestCase {
    private static Proxy proxy1 = new Proxy(Proxy.Type.HTTP, new InetSocketAddress("test1", 8080));
    private static Proxy proxy2 = new Proxy(Proxy.Type.HTTP, new InetSocketAddress("test2", 8080));
    private static Proxy proxy3 = new Proxy(Proxy.Type.HTTP, new InetSocketAddress("test3", 8080));
    private static Proxy proxy4 = new Proxy(Proxy.Type.HTTP, new InetSocketAddress("test4", 8080));
    private static URI http;
    private static URI socks;

    static {
        try {
            http = new URI("http://web.de");
            socks = new URI("socks://web.de");
        }
        catch (URISyntaxException e) {
            ManualProxySelectorTest.fail((String)e.toString());
        }
    }

    public void testDirect() throws CoreException {
        ManualProxySelector selector = new ManualProxySelector();
        List proxies = selector.select(http);
        ManualProxySelectorTest.assertEquals((int)1, (int)proxies.size());
        ManualProxySelectorTest.assertEquals((Object)Proxy.NO_PROXY, proxies.get(0));
    }

    public void testUniversal() throws CoreException {
        ManualProxySelector selector = new ManualProxySelector();
        selector.setInitializationData(null, null, (Object)"http://test1:8080,http://test2:8080");
        List proxies = selector.select(http);
        ManualProxySelectorTest.assertEquals((int)2, (int)proxies.size());
        ManualProxySelectorTest.assertEquals((Object)proxy1, proxies.get(0));
        ManualProxySelectorTest.assertEquals((Object)proxy2, proxies.get(1));
    }

    public void testSpecific() throws CoreException {
        ManualProxySelector selector = new ManualProxySelector();
        selector.setInitializationData(null, null, (Object)"http=http://test1:8080,http=http://test2:8080");
        List proxies = selector.select(http);
        ManualProxySelectorTest.assertEquals((int)2, (int)proxies.size());
        ManualProxySelectorTest.assertEquals((Object)proxy1, proxies.get(0));
        ManualProxySelectorTest.assertEquals((Object)proxy2, proxies.get(1));
        proxies = selector.select(socks);
        ManualProxySelectorTest.assertEquals((int)1, (int)proxies.size());
    }

    public void testUniversalAndSpecific() throws CoreException {
        ManualProxySelector selector = new ManualProxySelector();
        selector.setInitializationData(null, null, (Object)"http://test1:8080,http://test2:8080,http=http://test3:8080,http=http://test4:8080");
        List proxies = selector.select(http);
        ManualProxySelectorTest.assertEquals((int)2, (int)proxies.size());
        ManualProxySelectorTest.assertEquals((Object)proxy3, proxies.get(0));
        ManualProxySelectorTest.assertEquals((Object)proxy4, proxies.get(1));
        proxies = selector.select(socks);
        ManualProxySelectorTest.assertEquals((int)1, (int)proxies.size());
        ManualProxySelectorTest.assertEquals((Object)Proxy.NO_PROXY, proxies.get(0));
    }

    public void testConfigurationBySystemProperty() throws CoreException {
        System.setProperty("riena.manualproxies", "http://test1:8080,http://test2:8080");
        ManualProxySelector selector = new ManualProxySelector();
        selector.setInitializationData(null, null, (Object)"http://test3:8080;http://test4:8080");
        List proxies = selector.select(http);
        ManualProxySelectorTest.assertEquals((int)2, (int)proxies.size());
        ManualProxySelectorTest.assertEquals((Object)proxy1, proxies.get(0));
        ManualProxySelectorTest.assertEquals((Object)proxy2, proxies.get(1));
        System.clearProperty("riena.manualproxies");
    }
}

