/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.injector.service;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import junit.framework.AssertionFailedError;
import org.eclipse.riena.core.injector.Inject;
import org.eclipse.riena.core.injector.service.DepOne;
import org.eclipse.riena.core.injector.service.ServiceInjector;
import org.eclipse.riena.core.injector.service.Target;
import org.eclipse.riena.core.test.RienaTestCase;
import org.eclipse.riena.core.test.collect.NonUITestCase;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.core.util.WeakRef;
import org.osgi.framework.ServiceRegistration;

@NonUITestCase
public class ServiceInjectorWeakRefTest
extends RienaTestCase {
    public void testWeakRefFail() throws IOException {
        try {
            this.testWeakRef(false);
            ServiceInjectorWeakRefTest.fail();
        }
        catch (AssertionFailedError assertionFailedError) {
            this.ok();
        }
    }

    public void testWeakRefSucceed() throws IOException {
        this.testWeakRef(true);
    }

    private void testWeakRef(boolean withNulling) throws IOException {
        this.printTestName();
        Target target = new Target();
        DepOne depOne = new DepOne();
        ServiceRegistration reg = this.getContext().registerService(DepOne.class.getName(), (Object)depOne, null);
        ServiceInjector shot = null;
        try {
            shot = Inject.service((String)DepOne.class.getName()).into((Object)target).andStart(this.getContext());
            ServiceInjectorWeakRefTest.assertEquals((int)1, (int)target.count("bind", DepOne.class));
            if (withNulling) {
                target = null;
            }
            this.runOutOfMemory();
            WeakRef targetRef = (WeakRef)ReflectionUtils.getHidden((Object)shot, (String)"targetRef");
            ServiceInjectorWeakRefTest.assertNull((Object)targetRef.get());
            Object state = ReflectionUtils.getHidden((Object)shot, (String)"state");
            ServiceInjectorWeakRefTest.assertEquals((String)"STOPPED", (String)state.toString());
        }
        finally {
            shot.stop();
            reg.unregister();
        }
    }

    private void runOutOfMemory() throws IOException {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            while (true) {
                os.write(new byte[0x100000]);
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            System.gc();
            return;
        }
    }
}

