/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.util;

import java.io.IOException;
import java.util.Arrays;
import java.util.Random;
import org.eclipse.riena.core.test.RienaTestCase;
import org.eclipse.riena.core.test.collect.NonUITestCase;
import org.eclipse.riena.core.util.Base64;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

@NonUITestCase
public class Base64Test
extends RienaTestCase {
    private static final int RANDOM_ITERATIONS = 1000;
    private static final String DECODED1 = "sample^^*";
    private static final String ENCODED1 = "c2FtcGxlXl4q";
    private static final String DECODED2 = "lazy frog jumped over sleeping dog";
    private static final String ENCODED2 = "bGF6eSBmcm9nIGp1bXBlZCBvdmVyIHNsZWVwaW5nIGRvZw==";
    private static final byte[] DECODED3;
    private static final String ENCODED3 = "BQAADCABf/8=";
    private static final byte[] EDGE_CASE_DECODED;
    private static final String EDGE_CASE_ENCODED = "";
    private static final String BAD_ENCODIN_INVALID_CHARS = "M\u0005S4y\tM\n\rzQ=\r\n";

    static {
        byte[] byArray = new byte[8];
        byArray[0] = 5;
        byArray[3] = 12;
        byArray[4] = 32;
        byArray[5] = 1;
        byArray[6] = 127;
        byArray[7] = -1;
        DECODED3 = byArray;
        EDGE_CASE_DECODED = new byte[0];
    }

    public void testHandCoded() {
        String encoded = new String(Base64.encode((byte[])DECODED1.getBytes()));
        Base64Test.assertEquals((String)ENCODED1, (String)encoded);
        String decoded = new String(Base64.decode((byte[])ENCODED2.getBytes()));
        Base64Test.assertEquals((String)DECODED2, (String)decoded);
        String testZeroes = new String(Base64.encode((byte[])DECODED3));
        Base64Test.assertEquals((String)ENCODED3, (String)testZeroes);
        byte[] roundtripBytes = Base64.decode((byte[])testZeroes.getBytes());
        Base64Test.assertTrue((boolean)Arrays.equals(DECODED3, roundtripBytes));
        try {
            Base64.decode((byte[])BAD_ENCODIN_INVALID_CHARS.getBytes());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.ok();
        }
    }

    public void testEdge() {
        try {
            Base64.encode(null);
            Base64Test.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.ok();
        }
        try {
            Base64.decode(null);
            Base64Test.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.ok();
        }
        String encoded = new String(Base64.encode((byte[])EDGE_CASE_DECODED));
        Base64Test.assertNotNull((Object)encoded);
        Base64Test.assertEquals((String)EDGE_CASE_ENCODED, (String)encoded);
        byte[] decoded = Base64.decode((byte[])encoded.getBytes());
        Base64Test.assertTrue((boolean)Arrays.equals(EDGE_CASE_DECODED, decoded));
    }

    public void testRandom() {
        Random generator = new Random(System.currentTimeMillis());
        int i = 0;
        while (i < 1000) {
            int length = 100 + generator.nextInt(900);
            byte[] bytes = new byte[length];
            generator.nextBytes(bytes);
            byte[] encoded = Base64.encode((byte[])bytes);
            byte[] decoded = Base64.decode((byte[])encoded);
            Base64Test.assertTrue((boolean)Arrays.equals(bytes, decoded));
            ++i;
        }
    }

    public void testRegression() throws IOException {
        String encodeBASE64 = new BASE64Encoder().encode(DECODED2.getBytes());
        String encodeBase64 = new String(Base64.encode((byte[])DECODED2.getBytes()));
        Base64Test.assertEquals((String)encodeBASE64, (String)encodeBase64);
        String decodeBASE64 = new String(new BASE64Decoder().decodeBuffer(encodeBASE64));
        String decodeBase64 = new String(Base64.decode((byte[])encodeBase64.getBytes()));
        Base64Test.assertEquals((String)decodeBASE64, (String)decodeBase64);
    }
}

