/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.riena.core.test.RienaTestCase;
import org.eclipse.riena.core.test.collect.NonUITestCase;
import org.eclipse.riena.core.util.VariableManagerUtil;

@NonUITestCase
public class JavaSystemPropertiesResolverTest
extends RienaTestCase {
    public void testResolveUserDir() throws CoreException {
        String expected = System.getProperty("user.dir");
        JavaSystemPropertiesResolverTest.assertEquals((String)expected, (String)VariableManagerUtil.substitute((String)"${java.system.property:user.dir}"));
    }

    public void testResolveRienaHostName() throws CoreException, UnknownHostException {
        String expected = InetAddress.getLocalHost().getHostName();
        JavaSystemPropertiesResolverTest.assertEquals((String)expected, (String)VariableManagerUtil.substitute((String)"${java.system.property:riena.host.name}"));
    }

    public void testResolveRienaHostAddress() throws CoreException, UnknownHostException {
        String expected = InetAddress.getLocalHost().getHostAddress();
        JavaSystemPropertiesResolverTest.assertEquals((String)expected, (String)VariableManagerUtil.substitute((String)"${java.system.property:riena.host.address}"));
    }
}

