/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.util;

import junit.framework.TestCase;
import org.eclipse.riena.core.test.collect.NonUITestCase;
import org.eclipse.riena.core.util.ObjectCounter;

@NonUITestCase
public class ObjectCounterTest
extends TestCase {
    private ObjectCounter<String> strings;

    protected void setUp() throws Exception {
        super.setUp();
        this.strings = new ObjectCounter();
    }

    public void testZero() {
        ObjectCounterTest.assertEquals((int)0, (int)this.strings.getCount((Object)"A"));
    }

    public void testOne() {
        ObjectCounterTest.assertEquals((int)0, (int)this.strings.getCount((Object)"A"));
        ObjectCounterTest.assertEquals((int)1, (int)this.strings.incrementAndGetCount((Object)"A"));
        ObjectCounterTest.assertEquals((int)1, (int)this.strings.getCount((Object)"A"));
        ObjectCounterTest.assertEquals((int)0, (int)this.strings.decrementAndGetCount((Object)"A"));
        ObjectCounterTest.assertEquals((int)0, (int)this.strings.getCount((Object)"A"));
    }

    public void testTwo() {
        ObjectCounterTest.assertEquals((int)0, (int)this.strings.getCount((Object)"A"));
        ObjectCounterTest.assertEquals((int)1, (int)this.strings.incrementAndGetCount((Object)"A"));
        ObjectCounterTest.assertEquals((int)1, (int)this.strings.getCount((Object)"A"));
        ObjectCounterTest.assertEquals((int)2, (int)this.strings.incrementAndGetCount((Object)"A"));
        ObjectCounterTest.assertEquals((int)2, (int)this.strings.getCount((Object)"A"));
        ObjectCounterTest.assertEquals((int)1, (int)this.strings.decrementAndGetCount((Object)"A"));
        ObjectCounterTest.assertEquals((int)1, (int)this.strings.getCount((Object)"A"));
        ObjectCounterTest.assertEquals((int)0, (int)this.strings.decrementAndGetCount((Object)"A"));
        ObjectCounterTest.assertEquals((int)0, (int)this.strings.getCount((Object)"A"));
    }

    public void testTwoNoLessThanZero() {
        ObjectCounterTest.assertEquals((int)0, (int)this.strings.getCount((Object)"A"));
        ObjectCounterTest.assertEquals((int)1, (int)this.strings.incrementAndGetCount((Object)"A"));
        ObjectCounterTest.assertEquals((int)1, (int)this.strings.getCount((Object)"A"));
        ObjectCounterTest.assertEquals((int)2, (int)this.strings.incrementAndGetCount((Object)"A"));
        ObjectCounterTest.assertEquals((int)2, (int)this.strings.getCount((Object)"A"));
        ObjectCounterTest.assertEquals((int)1, (int)this.strings.decrementAndGetCount((Object)"A"));
        ObjectCounterTest.assertEquals((int)1, (int)this.strings.getCount((Object)"A"));
        ObjectCounterTest.assertEquals((int)0, (int)this.strings.decrementAndGetCount((Object)"A"));
        ObjectCounterTest.assertEquals((int)0, (int)this.strings.getCount((Object)"A"));
        ObjectCounterTest.assertEquals((int)0, (int)this.strings.decrementAndGetCount((Object)"A"));
        ObjectCounterTest.assertEquals((int)0, (int)this.strings.getCount((Object)"A"));
        ObjectCounterTest.assertEquals((int)0, (int)this.strings.decrementAndGetCount((Object)"A"));
        ObjectCounterTest.assertEquals((int)0, (int)this.strings.getCount((Object)"A"));
    }

    public void testIterator() {
        this.strings.incrementAndGetCount((Object)"A");
        this.strings.incrementAndGetCount((Object)"B");
        this.strings.incrementAndGetCount((Object)"C");
        this.strings.incrementAndGetCount((Object)"B");
        this.strings.incrementAndGetCount((Object)"C");
        this.strings.incrementAndGetCount((Object)"C");
        for (String s : this.strings) {
            if (s.equals("A")) {
                ObjectCounterTest.assertEquals((int)1, (int)this.strings.getCount((Object)s));
                continue;
            }
            if (s.equals("B")) {
                ObjectCounterTest.assertEquals((int)2, (int)this.strings.getCount((Object)s));
                continue;
            }
            if (!s.equals("C")) continue;
            ObjectCounterTest.assertEquals((int)3, (int)this.strings.getCount((Object)s));
        }
    }
}

