/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.wire;

import java.lang.reflect.Method;
import org.eclipse.riena.core.injector.service.FilterInjector;
import org.eclipse.riena.core.injector.service.RankingInjector;
import org.eclipse.riena.core.injector.service.ServiceInjector;
import org.eclipse.riena.core.test.RienaTestCase;
import org.eclipse.riena.core.test.collect.NonUITestCase;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.core.util.WeakRef;
import org.eclipse.riena.core.wire.InjectService;
import org.eclipse.riena.core.wire.Schtonk;
import org.eclipse.riena.internal.core.wire.ServiceInjectorBuilder;

@NonUITestCase
public class ServiceInjectorBuilderTest
extends RienaTestCase {
    public void testBuildForBind1() throws NoSuchMethodException {
        Method bindMethod = ServiceInjectorBuilderTest.class.getMethod("bind1", Schtonk.class);
        ServiceInjectorBuilder builder = new ServiceInjectorBuilder((Object)this, bindMethod);
        ServiceInjector injector = builder.build().andStart(this.getContext());
        ServiceInjectorBuilderTest.assertNotNull((Object)injector);
        ServiceInjectorBuilderTest.assertTrue((boolean)(injector instanceof FilterInjector));
        ServiceInjectorBuilderTest.assertFalse((boolean)this.useRanking(injector));
        ServiceInjectorBuilderTest.assertNull((Object)this.getFilter(injector));
        ServiceInjectorBuilderTest.assertEquals(Schtonk.class, (Object)this.getServiceClass(injector));
        ServiceInjectorBuilderTest.assertSame((Object)((Object)this), (Object)this.getBean(injector));
        ServiceInjectorBuilderTest.assertEquals((Object)bindMethod, (Object)this.getBindMethod(injector));
        ServiceInjectorBuilderTest.assertEquals((String)"unbind1", (String)this.getUnbindMethod(injector).getName());
        ServiceInjectorBuilderTest.assertFalse((boolean)this.getOnceOnly(injector));
    }

    @InjectService(service=Schtonk.class)
    public void bind1(Schtonk schtonk) {
    }

    public void unbind1(Schtonk schtonk) {
    }

    public void testBuildForBind2() throws NoSuchMethodException {
        Method bindMethod = ServiceInjectorBuilderTest.class.getMethod("bind2", Schtonk.class);
        ServiceInjectorBuilder builder = new ServiceInjectorBuilder((Object)this, bindMethod);
        ServiceInjector injector = builder.build().andStart(this.getContext());
        ServiceInjectorBuilderTest.assertNotNull((Object)injector);
        ServiceInjectorBuilderTest.assertTrue((boolean)(injector instanceof RankingInjector));
        ServiceInjectorBuilderTest.assertTrue((boolean)this.useRanking(injector));
        ServiceInjectorBuilderTest.assertNull((Object)this.getFilter(injector));
        ServiceInjectorBuilderTest.assertEquals((Object)Schtonk.class.getName(), (Object)this.getServiceClassName(injector));
        ServiceInjectorBuilderTest.assertSame((Object)((Object)this), (Object)this.getBean(injector));
        ServiceInjectorBuilderTest.assertEquals((String)"bind2", (String)this.getBindMethod(injector).getName());
        ServiceInjectorBuilderTest.assertEquals((String)"entbinde", (String)this.getUnbindMethod(injector).getName());
        ServiceInjectorBuilderTest.assertFalse((boolean)this.getOnceOnly(injector));
    }

    @InjectService(serviceName="org.eclipse.riena.core.wire.Schtonk", useRanking=true, unbind="entbinde")
    public void bind2(Schtonk schtonk) {
    }

    public void entbinde(Schtonk schtonk) {
    }

    public void testBuildForBind3() throws NoSuchMethodException {
        Method bindMethod = ServiceInjectorBuilderTest.class.getMethod("bind3", Schtonk.class);
        ServiceInjectorBuilder builder = new ServiceInjectorBuilder((Object)this, bindMethod);
        ServiceInjector injector = builder.build().andStart(this.getContext());
        ServiceInjectorBuilderTest.assertNotNull((Object)injector);
        ServiceInjectorBuilderTest.assertTrue((boolean)(injector instanceof FilterInjector));
        ServiceInjectorBuilderTest.assertFalse((boolean)this.useRanking(injector));
        ServiceInjectorBuilderTest.assertEquals((String)"(mellita = gut)", (String)this.getFilter(injector));
        ServiceInjectorBuilderTest.assertEquals((Object)Schtonk.class.getName(), (Object)this.getServiceClassName(injector));
        ServiceInjectorBuilderTest.assertSame((Object)((Object)this), (Object)this.getBean(injector));
        ServiceInjectorBuilderTest.assertEquals((String)"bind3", (String)this.getBindMethod(injector).getName());
        ServiceInjectorBuilderTest.assertEquals((String)"entbinde3", (String)this.getUnbindMethod(injector).getName());
        ServiceInjectorBuilderTest.assertFalse((boolean)this.getOnceOnly(injector));
    }

    @InjectService(serviceName="org.eclipse.riena.core.wire.Schtonk", useFilter="(mellita = gut)", unbind="entbinde3")
    public void bind3(Schtonk schtonk) {
    }

    public void entbinde3(Schtonk schtonk) {
    }

    public void testBuildForBind4() throws NoSuchMethodException {
        Method bindMethod = ServiceInjectorBuilderTest.class.getMethod("bind4", Schtonk.class);
        ServiceInjectorBuilder builder = new ServiceInjectorBuilder((Object)this, bindMethod);
        ServiceInjector injector = builder.build().andStart(this.getContext());
        ServiceInjectorBuilderTest.assertNotNull((Object)injector);
        ServiceInjectorBuilderTest.assertTrue((boolean)(injector instanceof FilterInjector));
        ServiceInjectorBuilderTest.assertFalse((boolean)this.useRanking(injector));
        ServiceInjectorBuilderTest.assertNull((Object)this.getFilter(injector));
        ServiceInjectorBuilderTest.assertEquals(Schtonk.class, (Object)this.getServiceClass(injector));
        ServiceInjectorBuilderTest.assertSame((Object)((Object)this), (Object)this.getBean(injector));
        ServiceInjectorBuilderTest.assertEquals((String)"bind4", (String)this.getBindMethod(injector).getName());
        ServiceInjectorBuilderTest.assertEquals((String)"unbind4", (String)this.getUnbindMethod(injector).getName());
        ServiceInjectorBuilderTest.assertFalse((boolean)this.getOnceOnly(injector));
    }

    @InjectService
    public void bind4(Schtonk schtonk) {
    }

    public void unbind4(Schtonk schtonk) {
    }

    public void testBuildForBind5OnceOnlyViaStatic() throws NoSuchMethodException {
        Method bindMethod = ServiceInjectorBuilderTest.class.getMethod("bind5", Schtonk.class);
        ServiceInjectorBuilder builder = new ServiceInjectorBuilder((Object)this, bindMethod);
        ServiceInjector injector = builder.build().andStart(this.getContext());
        ServiceInjectorBuilderTest.assertNotNull((Object)injector);
        ServiceInjectorBuilderTest.assertTrue((boolean)(injector instanceof FilterInjector));
        ServiceInjectorBuilderTest.assertFalse((boolean)this.useRanking(injector));
        ServiceInjectorBuilderTest.assertNull((Object)this.getFilter(injector));
        ServiceInjectorBuilderTest.assertEquals(Schtonk.class, (Object)this.getServiceClass(injector));
        ServiceInjectorBuilderTest.assertSame((Object)((Object)this), (Object)this.getBean(injector));
        ServiceInjectorBuilderTest.assertEquals((String)"bind5", (String)this.getBindMethod(injector).getName());
        ServiceInjectorBuilderTest.assertEquals((String)"unbind5", (String)this.getUnbindMethod(injector).getName());
        ServiceInjectorBuilderTest.assertTrue((boolean)this.getOnceOnly(injector));
    }

    @InjectService
    public static void bind5(Schtonk schtonk) {
    }

    public static void unbind5(Schtonk schtonk) {
    }

    public void testBuildForBind6OnceOnlyViaAnnotation() throws NoSuchMethodException {
        Method bindMethod = ServiceInjectorBuilderTest.class.getMethod("bind6", Schtonk.class);
        ServiceInjectorBuilder builder = new ServiceInjectorBuilder((Object)this, bindMethod);
        ServiceInjector injector = builder.build().andStart(this.getContext());
        ServiceInjectorBuilderTest.assertNotNull((Object)injector);
        ServiceInjectorBuilderTest.assertTrue((boolean)(injector instanceof FilterInjector));
        ServiceInjectorBuilderTest.assertFalse((boolean)this.useRanking(injector));
        ServiceInjectorBuilderTest.assertNull((Object)this.getFilter(injector));
        ServiceInjectorBuilderTest.assertEquals(Schtonk.class, (Object)this.getServiceClass(injector));
        ServiceInjectorBuilderTest.assertSame((Object)((Object)this), (Object)this.getBean(injector));
        ServiceInjectorBuilderTest.assertEquals((String)"bind6", (String)this.getBindMethod(injector).getName());
        ServiceInjectorBuilderTest.assertEquals((String)"unbind6", (String)this.getUnbindMethod(injector).getName());
        ServiceInjectorBuilderTest.assertTrue((boolean)this.getOnceOnly(injector));
    }

    @InjectService(onceOnly=true)
    public void bind6(Schtonk schtonk) {
    }

    public void unbind6(Schtonk schtonk) {
    }

    private boolean useRanking(ServiceInjector injector) {
        Object serviceDescriptor = ReflectionUtils.getHidden((Object)injector, (String)"serviceDesc");
        return (Boolean)ReflectionUtils.getHidden((Object)serviceDescriptor, (String)"ranking");
    }

    private String getFilter(ServiceInjector injector) {
        Object serviceDescriptor = ReflectionUtils.getHidden((Object)injector, (String)"serviceDesc");
        return (String)ReflectionUtils.getHidden((Object)serviceDescriptor, (String)"filter");
    }

    private Object getServiceClassName(ServiceInjector injector) {
        Object serviceDescriptor = ReflectionUtils.getHidden((Object)injector, (String)"serviceDesc");
        return ReflectionUtils.getHidden((Object)serviceDescriptor, (String)"className");
    }

    private Object getServiceClass(ServiceInjector injector) {
        Object serviceDescriptor = ReflectionUtils.getHidden((Object)injector, (String)"serviceDesc");
        return ReflectionUtils.getHidden((Object)serviceDescriptor, (String)"clazz");
    }

    private Object getBean(ServiceInjector injector) {
        WeakRef ref = (WeakRef)ReflectionUtils.getHidden((Object)injector, (String)"targetRef");
        return ref.get();
    }

    private Method getBindMethod(ServiceInjector injector) {
        return (Method)ReflectionUtils.getHidden((Object)injector, (String)"bindMethod");
    }

    private Method getUnbindMethod(ServiceInjector injector) {
        return (Method)ReflectionUtils.getHidden((Object)injector, (String)"unbindMethod");
    }

    private boolean getOnceOnly(ServiceInjector injector) {
        return (Boolean)ReflectionUtils.getHidden((Object)injector, (String)"onceOnly");
    }
}

