/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.communication.hessian;

import com.caucho.hessian.io.AbstractSerializerFactory;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.eclipse.riena.communication.core.attachment.Attachment;
import org.eclipse.riena.core.util.Nop;
import org.eclipse.riena.internal.communication.factory.hessian.serializer.InputStreamSerializerFactory;
import org.eclipse.riena.internal.communication.hessian.AbstractSerializerFactoryTestCase;

public class InputStreamSerializerFactoryTest
extends AbstractSerializerFactoryTestCase {
    private static final byte[] BYTES = "That will be pushed through hessian!".getBytes();

    public void testInputStreamFail() throws IOException {
        Attachment attachment = new Attachment((InputStream)new ByteArrayInputStream(BYTES));
        try {
            this.inAndOut(attachment, AbstractSerializerFactoryTestCase.HessianSerializerVersion.Two, null, new AbstractSerializerFactory[0]);
            InputStreamSerializerFactoryTest.fail((String)"Must fail!");
        }
        catch (IOException iOException) {
            Nop.reason((String)"Expected");
        }
    }

    public void testInputStream() throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(BYTES);
        Attachment attachment = new Attachment((InputStream)bais);
        Attachment attechmentOut = (Attachment)this.inAndOut(attachment, AbstractSerializerFactoryTestCase.HessianSerializerVersion.Two, null, new AbstractSerializerFactory[]{new InputStreamSerializerFactory()});
        byte[] outBytes = new byte[BYTES.length];
        attechmentOut.readAsStream().read(outBytes);
        InputStreamSerializerFactoryTest.assertTrue((boolean)Arrays.equals(BYTES, outBytes));
    }
}

