/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.core.test.collect;

import java.util.List;
import org.eclipse.riena.core.test.collect.NonUITestCase;
import org.eclipse.riena.core.test.collect.TestCollector;
import org.eclipse.riena.core.test.collect.UITestCase;
import org.eclipse.riena.internal.core.test.collect.testpackage.JUnit3DummyBadlyNamed;
import org.eclipse.riena.internal.core.test.collect.testpackage.JUnit3DummyTest;
import org.eclipse.riena.internal.core.test.collect.testpackage.JUnit4DummyBadlyNamed;
import org.eclipse.riena.internal.core.test.collect.testpackage.JUnit4DummyTest;
import org.eclipse.riena.internal.tests.Activator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.Bundle;

@NonUITestCase
public class TestCollectorTest {
    private Bundle bundle;
    private Package withinPackage;

    @Before
    public void setUp() throws Exception {
        this.bundle = Activator.getDefault().getBundle();
        this.withinPackage = JUnit3DummyTest.class.getPackage();
    }

    @Test
    public void testCollectWithJUnit3() throws Exception {
        List found = TestCollector.collectWith((Bundle)this.bundle, (Package)this.withinPackage, (boolean)false, (Class[])new Class[]{UITestCase.class});
        Assert.assertEquals((long)1L, (long)found.size());
        Assert.assertTrue((boolean)found.contains(JUnit3DummyBadlyNamed.class));
    }

    @Test
    public void testCollectWithJUnit3And4() throws Exception {
        List found = TestCollector.collectWithJUnit3And4((Bundle)this.bundle, (Package)this.withinPackage, (boolean)false, (Class[])new Class[]{UITestCase.class});
        Assert.assertEquals((long)2L, (long)found.size());
        Assert.assertTrue((boolean)found.contains(JUnit3DummyBadlyNamed.class));
        Assert.assertTrue((boolean)found.contains(JUnit4DummyBadlyNamed.class));
    }

    @Test
    public void testCollectWithEmpty() throws Exception {
        Assert.assertTrue((boolean)TestCollector.collectWith((Bundle)this.bundle, (Package)this.withinPackage, (boolean)false, (Class[])new Class[]{NonUITestCase.class}).isEmpty());
        Assert.assertTrue((boolean)TestCollector.collectWithJUnit3And4((Bundle)this.bundle, (Package)this.withinPackage, (boolean)false, (Class[])new Class[]{NonUITestCase.class}).isEmpty());
    }

    @Test
    public void testCollectUnmarkedJUnit3() throws Exception {
        List found = TestCollector.collectUnmarked((Bundle)this.bundle, (Package)this.withinPackage);
        Assert.assertEquals((long)1L, (long)found.size());
        Assert.assertTrue((boolean)found.contains(JUnit3DummyTest.class));
    }

    @Test
    public void testCollectUnmarkedJUnit3And4() throws Exception {
        List found = TestCollector.collectUnmarkedJUnit3And4((Bundle)this.bundle, (Package)this.withinPackage);
        Assert.assertEquals((long)2L, (long)found.size());
        Assert.assertTrue((boolean)found.contains(JUnit3DummyTest.class));
        Assert.assertTrue((boolean)found.contains(JUnit4DummyTest.class));
    }

    @Test
    public void testCollectJunit3() throws Exception {
        List found = TestCollector.collect((Bundle)this.bundle, (Package)this.withinPackage, (boolean)false);
        Assert.assertEquals((long)2L, (long)found.size());
        Assert.assertTrue((boolean)found.contains(JUnit3DummyTest.class));
        Assert.assertTrue((boolean)found.contains(JUnit3DummyBadlyNamed.class));
    }

    @Test
    public void testCollectJUnit3And4() throws Exception {
        List found = TestCollector.collectJUnit3And4((Bundle)this.bundle, (Package)this.withinPackage, (boolean)false);
        Assert.assertEquals((long)4L, (long)found.size());
        Assert.assertTrue((boolean)found.contains(JUnit3DummyTest.class));
        Assert.assertTrue((boolean)found.contains(JUnit3DummyBadlyNamed.class));
        Assert.assertTrue((boolean)found.contains(JUnit4DummyTest.class));
        Assert.assertTrue((boolean)found.contains(JUnit4DummyBadlyNamed.class));
    }

    @Test
    public void testCollectBadlyNamedJUnit3() throws Exception {
        List found = TestCollector.collectBadlyNamed((Bundle)this.bundle, (Package)this.withinPackage);
        Assert.assertEquals((long)1L, (long)found.size());
        Assert.assertTrue((boolean)found.contains(JUnit3DummyBadlyNamed.class));
    }

    @Test
    public void testCollectBadlyNamedJUnit3And4() throws Exception {
        List found = TestCollector.collectBadlyNamedJUnit3And4((Bundle)this.bundle, (Package)this.withinPackage);
        Assert.assertEquals((long)2L, (long)found.size());
        Assert.assertTrue((boolean)found.contains(JUnit3DummyBadlyNamed.class));
        Assert.assertTrue((boolean)found.contains(JUnit4DummyBadlyNamed.class));
    }
}

