/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.navigation.ui.filter;

import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.core.test.collect.NonUITestCase;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.navigation.ui.filter.AbstractUIFilterRuleRidgetMarker;
import org.eclipse.riena.internal.ui.ridgets.swt.TextRidget;
import org.eclipse.riena.ui.core.marker.MandatoryMarker;
import org.eclipse.riena.ui.filter.IUIFilterRule;
import org.eclipse.swt.widgets.Display;

@NonUITestCase
public class AbstractUIFilterRuleRidgetMarkerTest
extends TestCase {
    private IUIFilterRule rule;

    protected void setUp() throws Exception {
        Display display = Display.getDefault();
        Realm realm = SWTObservables.getRealm((Display)display);
        AbstractUIFilterRuleRidgetMarkerTest.assertNotNull((Object)realm);
        ReflectionUtils.invokeHidden((Object)realm, (String)"setDefault", (Object[])new Object[]{realm});
        this.rule = new MyUIFilterRule();
    }

    protected void tearDown() throws Exception {
        this.rule = null;
    }

    public void testApply() {
        TextRidget ridget = new TextRidget();
        AbstractUIFilterRuleRidgetMarkerTest.assertTrue((boolean)ridget.getMarkers().isEmpty());
        this.rule.apply((Object)ridget);
        AbstractUIFilterRuleRidgetMarkerTest.assertFalse((boolean)ridget.getMarkers().isEmpty());
        AbstractUIFilterRuleRidgetMarkerTest.assertTrue((boolean)ridget.getMarkers().contains(new MandatoryMarker(false)));
        Map markerMap = (Map)ReflectionUtils.getHidden((Object)this.rule, (String)"markerMap");
        AbstractUIFilterRuleRidgetMarkerTest.assertEquals((Object)new MandatoryMarker(false), markerMap.get(ridget));
    }

    public void testRemove() {
        Map markerMap = (Map)ReflectionUtils.getHidden((Object)this.rule, (String)"markerMap");
        TextRidget ridget = new TextRidget();
        AbstractUIFilterRuleRidgetMarkerTest.assertTrue((boolean)ridget.getMarkers().isEmpty());
        AbstractUIFilterRuleRidgetMarkerTest.assertTrue((boolean)markerMap.isEmpty());
        this.rule.apply((Object)ridget);
        AbstractUIFilterRuleRidgetMarkerTest.assertTrue((boolean)ridget.getMarkers().contains(new MandatoryMarker(false)));
        AbstractUIFilterRuleRidgetMarkerTest.assertFalse((boolean)markerMap.isEmpty());
        this.rule.remove((Object)ridget);
        AbstractUIFilterRuleRidgetMarkerTest.assertTrue((boolean)ridget.getMarkers().isEmpty());
        AbstractUIFilterRuleRidgetMarkerTest.assertTrue((boolean)markerMap.isEmpty());
    }

    private static class MyUIFilterRule
    extends AbstractUIFilterRuleRidgetMarker {
        public MyUIFilterRule() {
            super("*", (IMarker)new MandatoryMarker(false));
        }
    }
}

