/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.navigation.ui.filter;

import junit.framework.TestCase;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.riena.core.test.collect.UITestCase;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.navigation.ui.filter.RidgetMatcher;
import org.eclipse.riena.internal.ui.ridgets.swt.LabelRidget;
import org.eclipse.riena.navigation.NavigationNodeId;
import org.eclipse.riena.navigation.model.SubModuleNode;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

@UITestCase
public class RidgetMatcherTest
extends TestCase {
    private Shell shell;

    protected void setUp() throws Exception {
        Display display = Display.getDefault();
        Realm realm = SWTObservables.getRealm((Display)display);
        RidgetMatcherTest.assertNotNull((Object)realm);
        ReflectionUtils.invokeHidden((Object)realm, (String)"setDefault", (Object[])new Object[]{realm});
        this.shell = new Shell();
    }

    protected void tearDown() throws Exception {
        SwtUtilities.dispose((Widget)this.shell);
    }

    public void testMatches() {
        RidgetMatcher matcher = new RidgetMatcher("4711");
        RidgetMatcherTest.assertFalse((boolean)matcher.matches(new Object[]{null}));
        RidgetMatcherTest.assertFalse((boolean)matcher.matches(new Object[]{new Object()}));
        Label control = new Label((Composite)this.shell, 0);
        LabelRidget ridget = new LabelRidget(control);
        RidgetMatcherTest.assertFalse((boolean)matcher.matches(new Object[]{ridget}));
        control.setData("binding_property", (Object)"4711");
        RidgetMatcherTest.assertTrue((boolean)matcher.matches(new Object[]{ridget}));
        SubModuleNode node = new SubModuleNode(new NavigationNodeId("subMod0815"));
        RidgetMatcherTest.assertFalse((boolean)matcher.matches(new Object[]{node, ridget}));
        matcher = new RidgetMatcher("*4711");
        RidgetMatcherTest.assertTrue((boolean)matcher.matches(new Object[]{ridget, node}));
        SwtUtilities.dispose((Widget)control);
    }
}

