/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import org.eclipse.core.databinding.BindingException;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.ui.ridgets.swt.AbstractComboRidgetTest;
import org.eclipse.riena.internal.ui.ridgets.swt.CComboRidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.swt.AbstractComboRidget;
import org.eclipse.riena.ui.ridgets.swt.uibinding.SwtControlRidgetMapper;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;

public class CComboRidgetTest
extends AbstractComboRidgetTest {
    protected Control createWidget(Composite parent) {
        return new CCombo(parent, 8);
    }

    @Override
    protected Control createWidget(Composite parent, int style) {
        return new CCombo(parent, style);
    }

    @Override
    protected IRidget createRidget() {
        return new CComboRidget();
    }

    public void testRidgetMapping() {
        SwtControlRidgetMapper mapper = SwtControlRidgetMapper.getInstance();
        CComboRidgetTest.assertTrue((boolean)(this.getWidget() instanceof CCombo));
        CComboRidgetTest.assertSame(CComboRidget.class, (Object)mapper.getRidgetClass((Object)this.getWidget()));
    }

    public void testDisabledWidgetHasGrayBackground() {
        AbstractComboRidget ridget = this.getRidget();
        CCombo control = (CCombo)this.getWidget();
        Display display = control.getDisplay();
        Color bgColor = display.getSystemColor(1);
        Color disabledBg = display.getSystemColor(22);
        CComboRidgetTest.assertTrue((boolean)ridget.isEnabled());
        control.setBackground(bgColor);
        ridget.setEnabled(false);
        CComboRidgetTest.assertEquals((Object)disabledBg, (Object)control.getBackground());
        CComboRidgetTest.assertEquals((Object)disabledBg, (Object)this.getText(control).getBackground());
        ridget.setEnabled(true);
        CComboRidgetTest.assertEquals((Object)bgColor, (Object)control.getBackground());
        CComboRidgetTest.assertEquals((Object)bgColor, (Object)this.getText(control).getBackground());
    }

    public void testRequireReadOnlyUIControl() {
        try {
            this.getRidget().setUIControl((Object)this.createWidget((Composite)this.getShell(), 0));
            CComboRidgetTest.fail();
        }
        catch (BindingException bindingException) {
            this.ok();
        }
    }

    private Text getText(CCombo control) {
        return (Text)ReflectionUtils.getHidden((Object)control, (String)"text");
    }
}

