/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import org.eclipse.riena.core.test.RienaTestCase;
import org.eclipse.riena.core.test.collect.UITestCase;
import org.eclipse.riena.ui.swt.ChoiceComposite;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

@UITestCase
public class ChoiceCompositeTest
extends RienaTestCase {
    private Shell shell;

    protected void setUp() throws Exception {
        super.setUp();
        Display display = Display.getDefault();
        this.shell = new Shell(display);
        this.shell.setLayout((Layout)new FillLayout());
        this.shell.setSize(130, 100);
        this.shell.setLocation(0, 0);
        this.shell.open();
    }

    protected void tearDown() throws Exception {
        this.shell.dispose();
        this.shell = null;
        super.tearDown();
    }

    public void testCreateChildWithTextWrapMulti() {
        ChoiceComposite cc = new ChoiceComposite((Composite)this.shell, 0, true);
        cc.setWrapOptionsText(true);
        ChoiceCompositeTest.assertFalse(((cc.createChild("label").getStyle() & 0x20) == 0 ? 1 : 0) != 0);
        ChoiceCompositeTest.assertTrue(((cc.createChild("label").getStyle() & 0x10) == 0 ? 1 : 0) != 0);
    }

    public void testCreateChildWithTextWrapSingle() {
        ChoiceComposite cc = new ChoiceComposite((Composite)this.shell, 0, false);
        cc.setWrapOptionsText(true);
        ChoiceCompositeTest.assertTrue(((cc.createChild("label").getStyle() & 0x20) == 0 ? 1 : 0) != 0);
        ChoiceCompositeTest.assertFalse(((cc.createChild("label").getStyle() & 0x10) == 0 ? 1 : 0) != 0);
    }

    public void testCenterButtonsInHorizontalLayout() throws Exception {
        ChoiceComposite cc = new ChoiceComposite((Composite)this.shell, 0, false);
        cc.setOrientation(256);
        cc.setWrapOptionsText(true);
        Button b1 = cc.createChild("multi\nline");
        Button b2 = cc.createChild("single-line");
        cc.layout(true, true);
        ChoiceCompositeTest.assertTrue((b1.getBounds().y < b2.getBounds().y ? 1 : 0) != 0);
    }

    public void testMultiLineRadioButtons() {
        ChoiceComposite cc = new ChoiceComposite((Composite)this.shell, 0, false);
        cc.setOrientation(256);
        cc.setWrapOptionsText(true);
        Button b1 = cc.createChild("multi\nline");
        Button b2 = cc.createChild("single-line");
        cc.layout(true, true);
        ChoiceCompositeTest.assertTrue((b1.getBounds().height > b2.getBounds().height ? 1 : 0) != 0);
    }

    public void testConstructor() {
        try {
            new ChoiceComposite(null, 0, false);
            ChoiceCompositeTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        ChoiceComposite control1 = new ChoiceComposite((Composite)this.shell, 0, false);
        ChoiceCompositeTest.assertFalse((boolean)control1.isMultipleSelection());
        ChoiceComposite control2 = new ChoiceComposite((Composite)this.shell, 0, true);
        ChoiceCompositeTest.assertTrue((boolean)control2.isMultipleSelection());
    }

    public void testSetOrientation() {
        ChoiceComposite control = new ChoiceComposite((Composite)this.shell, 0, false);
        ChoiceCompositeTest.assertEquals((int)512, (int)control.getOrientation());
        control.setOrientation(256);
        ChoiceCompositeTest.assertEquals((int)256, (int)control.getOrientation());
        ChoiceCompositeTest.assertTrue((boolean)(control.getContentComposite().getLayout() instanceof RowLayout));
        ChoiceCompositeTest.assertEquals((int)256, (int)((RowLayout)control.getContentComposite().getLayout()).type);
        control.setOrientation(512);
        ChoiceCompositeTest.assertEquals((int)512, (int)control.getOrientation());
        ChoiceCompositeTest.assertTrue((boolean)(control.getContentComposite().getLayout() instanceof FillLayout));
        ChoiceCompositeTest.assertEquals((int)512, (int)((FillLayout)control.getContentComposite().getLayout()).type);
        try {
            control.setOrientation(0);
            ChoiceCompositeTest.fail();
        }
        catch (RuntimeException runtimeException) {
            ChoiceCompositeTest.assertEquals((int)512, (int)control.getOrientation());
        }
    }

    public void testSetForeground() {
        ChoiceComposite control = new ChoiceComposite((Composite)this.shell, 0, false);
        Button child1 = new Button((Composite)control, 16);
        Color colorGreen = control.getDisplay().getSystemColor(5);
        ChoiceCompositeTest.assertTrue((!colorGreen.equals((Object)control.getForeground()) ? 1 : 0) != 0);
        control.setForeground(colorGreen);
        ChoiceCompositeTest.assertEquals((Object)colorGreen, (Object)control.getForeground());
        ChoiceCompositeTest.assertEquals((Object)colorGreen, (Object)child1.getForeground());
    }

    public void testSetBackground() {
        ChoiceComposite control = new ChoiceComposite((Composite)this.shell, 0, false);
        Button child1 = new Button((Composite)control, 16);
        Color colorRed = control.getDisplay().getSystemColor(3);
        ChoiceCompositeTest.assertTrue((!colorRed.equals((Object)control.getBackground()) ? 1 : 0) != 0);
        control.setBackground(colorRed);
        ChoiceCompositeTest.assertEquals((Object)colorRed, (Object)control.getBackground());
        ChoiceCompositeTest.assertEquals((Object)colorRed, (Object)child1.getBackground());
    }

    public void testSetEnabled() {
        ChoiceComposite control = new ChoiceComposite((Composite)this.shell, 0, false);
        Button child1 = control.createChild("one");
        ChoiceCompositeTest.assertTrue((boolean)control.getEnabled());
        ChoiceCompositeTest.assertTrue((boolean)child1.getEnabled());
        control.setEnabled(false);
        ChoiceCompositeTest.assertFalse((boolean)control.getEnabled());
        ChoiceCompositeTest.assertFalse((boolean)child1.getEnabled());
        control.setEnabled(true);
        ChoiceCompositeTest.assertTrue((boolean)control.getEnabled());
        ChoiceCompositeTest.assertTrue((boolean)child1.getEnabled());
    }

    public void testSetEditable() {
        ChoiceComposite control = new ChoiceComposite((Composite)this.shell, 0, true);
        Button child1 = control.createChild("one");
        child1.setSelection(true);
        Button child2 = control.createChild("two");
        child2.setSelection(true);
        Button child3 = control.createChild("three");
        child3.setSelection(false);
        ChoiceCompositeTest.assertTrue((boolean)control.isEnabled());
        ChoiceCompositeTest.assertTrue((boolean)control.getEditable());
        ChoiceCompositeTest.assertTrue((boolean)child1.isEnabled());
        ChoiceCompositeTest.assertTrue((boolean)child2.isEnabled());
        ChoiceCompositeTest.assertTrue((boolean)child3.isEnabled());
        control.setEditable(false);
        ChoiceCompositeTest.assertFalse((boolean)control.getEditable());
        ChoiceCompositeTest.assertTrue((boolean)child1.isEnabled());
        ChoiceCompositeTest.assertTrue((boolean)child2.isEnabled());
        ChoiceCompositeTest.assertFalse((boolean)child3.isEnabled());
        control.setEditable(true);
        ChoiceCompositeTest.assertTrue((boolean)control.getEditable());
        ChoiceCompositeTest.assertTrue((boolean)child1.isEnabled());
        ChoiceCompositeTest.assertTrue((boolean)child2.isEnabled());
        ChoiceCompositeTest.assertTrue((boolean)child3.isEnabled());
    }

    public void testSetEditableFalseBlocksChangesFromUI() {
        ChoiceComposite control = new ChoiceComposite((Composite)this.shell, 0, true);
        Button child1 = control.createChild("child1");
        child1.setSelection(true);
        control.setEditable(false);
        ChoiceCompositeTest.assertTrue((boolean)child1.getSelection());
        ChoiceCompositeTest.assertFalse((boolean)control.getEditable());
        child1.setSelection(false);
        Event event = new Event();
        event.type = 13;
        event.widget = child1;
        event.display = child1.getDisplay();
        child1.notifyListeners(event.type, event);
        ChoiceCompositeTest.assertTrue((boolean)child1.getSelection());
    }

    public void testToggleEditableWhenDisabled() {
        ChoiceComposite control = new ChoiceComposite((Composite)this.shell, 0, true);
        Button child1 = control.createChild("one");
        child1.setSelection(true);
        Button child2 = control.createChild("two");
        child2.setSelection(true);
        Button child3 = control.createChild("three");
        child3.setSelection(false);
        control.setEditable(false);
        control.setEnabled(false);
        ChoiceCompositeTest.assertFalse((boolean)child1.isEnabled());
        ChoiceCompositeTest.assertFalse((boolean)child2.isEnabled());
        ChoiceCompositeTest.assertFalse((boolean)child3.isEnabled());
        control.setEnabled(true);
        ChoiceCompositeTest.assertTrue((boolean)child1.isEnabled());
        ChoiceCompositeTest.assertTrue((boolean)child2.isEnabled());
        ChoiceCompositeTest.assertFalse((boolean)child3.isEnabled());
        control.setEditable(true);
        ChoiceCompositeTest.assertTrue((boolean)child1.isEnabled());
        ChoiceCompositeTest.assertTrue((boolean)child2.isEnabled());
        ChoiceCompositeTest.assertTrue((boolean)child3.isEnabled());
    }

    public void testSetMarginsVerticalOrientation() {
        ChoiceComposite control = new ChoiceComposite((Composite)this.shell, 0, false);
        ChoiceCompositeTest.assertEquals((int)512, (int)control.getOrientation());
        ChoiceCompositeTest.assertEquals((int)0, (int)control.getMargins().x);
        ChoiceCompositeTest.assertEquals((int)0, (int)control.getMargins().y);
        ChoiceCompositeTest.assertEquals((int)0, (int)((FillLayout)control.getContentComposite().getLayout()).marginHeight);
        ChoiceCompositeTest.assertEquals((int)0, (int)((FillLayout)control.getContentComposite().getLayout()).marginWidth);
        control.setMargins(10, 20);
        ChoiceCompositeTest.assertEquals((int)10, (int)control.getMargins().x);
        ChoiceCompositeTest.assertEquals((int)20, (int)control.getMargins().y);
        ChoiceCompositeTest.assertEquals((int)10, (int)((FillLayout)control.getContentComposite().getLayout()).marginHeight);
        ChoiceCompositeTest.assertEquals((int)20, (int)((FillLayout)control.getContentComposite().getLayout()).marginWidth);
    }

    public void testSetMarginsHorizontalOrientation() {
        ChoiceComposite control = new ChoiceComposite((Composite)this.shell, 0, false);
        control.setOrientation(256);
        ChoiceCompositeTest.assertEquals((int)256, (int)control.getOrientation());
        ChoiceCompositeTest.assertEquals((int)0, (int)control.getMargins().x);
        ChoiceCompositeTest.assertEquals((int)0, (int)control.getMargins().y);
        ChoiceCompositeTest.assertEquals((int)0, (int)((RowLayout)control.getContentComposite().getLayout()).marginHeight);
        ChoiceCompositeTest.assertEquals((int)0, (int)((RowLayout)control.getContentComposite().getLayout()).marginWidth);
        control.setMargins(10, 20);
        ChoiceCompositeTest.assertEquals((int)10, (int)control.getMargins().x);
        ChoiceCompositeTest.assertEquals((int)20, (int)control.getMargins().y);
        ChoiceCompositeTest.assertEquals((int)10, (int)((RowLayout)control.getContentComposite().getLayout()).marginHeight);
        ChoiceCompositeTest.assertEquals((int)20, (int)((RowLayout)control.getContentComposite().getLayout()).marginWidth);
    }

    public void testSetMarginsNegativeValue() {
        ChoiceComposite control = new ChoiceComposite((Composite)this.shell, 0, false);
        try {
            control.setMargins(-5, 10);
            ChoiceCompositeTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        try {
            control.setMargins(10, -5);
            ChoiceCompositeTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
    }

    public void testSetSpacingVerticalOrientation() {
        ChoiceComposite control = new ChoiceComposite((Composite)this.shell, 0, false);
        ChoiceCompositeTest.assertEquals((int)512, (int)control.getOrientation());
        ChoiceCompositeTest.assertEquals((int)3, (int)control.getSpacing().x);
        ChoiceCompositeTest.assertEquals((int)0, (int)control.getSpacing().y);
        ChoiceCompositeTest.assertEquals((int)0, (int)((FillLayout)control.getContentComposite().getLayout()).spacing);
        control.setSpacing(0, 10);
        ChoiceCompositeTest.assertEquals((int)0, (int)control.getSpacing().x);
        ChoiceCompositeTest.assertEquals((int)10, (int)control.getSpacing().y);
        ChoiceCompositeTest.assertEquals((int)10, (int)((FillLayout)control.getContentComposite().getLayout()).spacing);
    }

    public void testSetSpacingHorizontalOrientation() {
        ChoiceComposite control = new ChoiceComposite((Composite)this.shell, 0, false);
        control.setOrientation(256);
        ChoiceCompositeTest.assertEquals((int)256, (int)control.getOrientation());
        ChoiceCompositeTest.assertEquals((int)3, (int)control.getSpacing().x);
        ChoiceCompositeTest.assertEquals((int)0, (int)control.getSpacing().y);
        ChoiceCompositeTest.assertEquals((int)3, (int)((RowLayout)control.getContentComposite().getLayout()).spacing);
        control.setSpacing(10, 0);
        ChoiceCompositeTest.assertEquals((int)10, (int)control.getSpacing().x);
        ChoiceCompositeTest.assertEquals((int)0, (int)control.getSpacing().y);
        ChoiceCompositeTest.assertEquals((int)10, (int)((RowLayout)control.getContentComposite().getLayout()).spacing);
    }

    public void testSetSpacingNegativeValue() {
        ChoiceComposite control = new ChoiceComposite((Composite)this.shell, 0, false);
        try {
            control.setSpacing(-5, 10);
            ChoiceCompositeTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        try {
            control.setSpacing(10, -5);
            ChoiceCompositeTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
    }

    public void testDisabledWidgetHasGrayBackground() {
        ChoiceComposite control = new ChoiceComposite((Composite)this.shell, 0, false);
        Button child1 = control.createChild("child1");
        ChoiceCompositeTest.assertTrue((boolean)control.isEnabled());
        Color defaultBg = control.getBackground();
        Color defaultChildBg = child1.getBackground();
        Color disabledBg = control.getDisplay().getSystemColor(22);
        control.setEnabled(false);
        ChoiceCompositeTest.assertEquals((Object)disabledBg, (Object)control.getBackground());
        ChoiceCompositeTest.assertEquals((Object)disabledBg, (Object)child1.getBackground());
        control.setEnabled(true);
        ChoiceCompositeTest.assertEquals((Object)defaultBg, (Object)control.getBackground());
        ChoiceCompositeTest.assertEquals((Object)defaultChildBg, (Object)child1.getBackground());
    }

    public void testSetBackgroundColorWhileDisabled() {
        ChoiceComposite control = new ChoiceComposite((Composite)this.shell, 0, false);
        Button child1 = control.createChild("child1");
        Display display = control.getDisplay();
        Color disabledBg = display.getSystemColor(22);
        Color red = display.getSystemColor(3);
        control.setEnabled(false);
        control.setBackground(red);
        ChoiceCompositeTest.assertEquals((Object)disabledBg, (Object)control.getBackground());
        ChoiceCompositeTest.assertEquals((Object)disabledBg, (Object)child1.getBackground());
        control.setEnabled(true);
        ChoiceCompositeTest.assertEquals((Object)red, (Object)control.getBackground());
        ChoiceCompositeTest.assertEquals((Object)red, (Object)child1.getBackground());
    }

    public void testSetBackgroundColorWhileDisabledRespectingParentsBackground() {
        ChoiceComposite control = new ChoiceComposite((Composite)this.shell, 0, false);
        Button child1 = control.createChild("child1");
        Display display = control.getDisplay();
        Color red = display.getSystemColor(3);
        this.shell.setBackground(red);
        control.setEnabled(false);
        ChoiceCompositeTest.assertEquals((Object)red, (Object)control.getBackground());
        ChoiceCompositeTest.assertEquals((Object)red, (Object)child1.getBackground());
        ChoiceCompositeTest.assertEquals((Object)red, (Object)this.shell.getBackground());
        control.setEnabled(true);
        ChoiceCompositeTest.assertEquals((Object)red, (Object)control.getBackground());
        ChoiceCompositeTest.assertEquals((Object)red, (Object)child1.getBackground());
        ChoiceCompositeTest.assertEquals((Object)red, (Object)this.shell.getBackground());
        control.setEnabled(false);
        ChoiceCompositeTest.assertEquals((Object)red, (Object)control.getBackground());
        ChoiceCompositeTest.assertEquals((Object)red, (Object)child1.getBackground());
        ChoiceCompositeTest.assertEquals((Object)red, (Object)this.shell.getBackground());
    }
}

