/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.util.List;
import junit.framework.TestCase;
import org.eclipse.riena.core.test.collect.NonUITestCase;
import org.eclipse.riena.internal.ui.ridgets.swt.ContextMenuDelegate;
import org.eclipse.riena.ui.ridgets.IMenuItemRidget;

@NonUITestCase
public class ContextMenuDelegateTest
extends TestCase {
    private ContextMenuDelegate contextMenuDelegate;

    protected void setUp() throws Exception {
        this.contextMenuDelegate = new ContextMenuDelegate();
    }

    protected void tearDown() throws Exception {
        this.contextMenuDelegate = null;
        super.tearDown();
    }

    public void testGetMenuItemCount() {
        this.contextMenuDelegate.addMenuItem("MenuItemWithoutIcon", null);
        ContextMenuDelegateTest.assertEquals((int)1, (int)this.contextMenuDelegate.getMenuItemCount());
        this.contextMenuDelegate.addMenuItem("MenuItemWithIcon", "leftArrow");
        ContextMenuDelegateTest.assertEquals((int)2, (int)this.contextMenuDelegate.getMenuItemCount());
    }

    public void testGetMenuItem() {
        IMenuItemRidget menuItemWithoutIcon = this.contextMenuDelegate.addMenuItem("MenuItemWithoutIcon", null);
        ContextMenuDelegateTest.assertEquals((Object)menuItemWithoutIcon, (Object)this.contextMenuDelegate.getMenuItem(0));
        IMenuItemRidget menuItemWithIcon = this.contextMenuDelegate.addMenuItem("MenuItemWithIcon", "leftArrow");
        ContextMenuDelegateTest.assertEquals((Object)menuItemWithIcon, (Object)this.contextMenuDelegate.getMenuItem(1));
    }

    public void testGetMenuItems() {
        IMenuItemRidget menuItemWithoutIcon = this.contextMenuDelegate.addMenuItem("MenuItemWithoutIcon", null);
        ContextMenuDelegateTest.assertEquals((Object)menuItemWithoutIcon, (Object)this.contextMenuDelegate.getMenuItem(0));
        IMenuItemRidget menuItemWithIcon = this.contextMenuDelegate.addMenuItem("MenuItemWithIcon", "leftArrow");
        ContextMenuDelegateTest.assertEquals((Object)menuItemWithIcon, (Object)this.contextMenuDelegate.getMenuItem(1));
        List items = this.contextMenuDelegate.getMenuItems();
        ContextMenuDelegateTest.assertEquals((int)items.size(), (int)2);
        int i = 0;
        while (i < items.size()) {
            if (i == 0) {
                ((IMenuItemRidget)items.get(i)).equals(menuItemWithoutIcon);
            } else if (i == 1) {
                ((IMenuItemRidget)items.get(i)).equals(menuItemWithIcon);
            }
            ++i;
        }
    }

    public void testAddMenuItem() {
        IMenuItemRidget menuItemWithoutIcon = this.contextMenuDelegate.addMenuItem("MenuItemWithoutIcon", null);
        ContextMenuDelegateTest.assertEquals((int)1, (int)this.contextMenuDelegate.getMenuItemCount());
        ContextMenuDelegateTest.assertEquals((Object)menuItemWithoutIcon, (Object)this.contextMenuDelegate.getMenuItem(0));
        IMenuItemRidget menuItemWithIcon = this.contextMenuDelegate.addMenuItem("MenuItemWithIcon", "leftArrow");
        ContextMenuDelegateTest.assertEquals((int)2, (int)this.contextMenuDelegate.getMenuItemCount());
        ContextMenuDelegateTest.assertEquals((Object)menuItemWithIcon, (Object)this.contextMenuDelegate.getMenuItem(1));
    }

    public void testRemoveMenuItem() {
        IMenuItemRidget menuItemWithoutIcon = this.contextMenuDelegate.addMenuItem("MenuItemWithoutIcon", null);
        IMenuItemRidget menuItemWithIcon = this.contextMenuDelegate.addMenuItem("MenuItemWithIcon", "leftArrow");
        ContextMenuDelegateTest.assertEquals((int)2, (int)this.contextMenuDelegate.getMenuItemCount());
        this.contextMenuDelegate.removeMenuItem("MenuItemWithIcon");
        ContextMenuDelegateTest.assertEquals((int)1, (int)this.contextMenuDelegate.getMenuItemCount());
        menuItemWithIcon = this.contextMenuDelegate.addMenuItem("MenuItemWithIcon", "leftArrow");
        ContextMenuDelegateTest.assertEquals((int)2, (int)this.contextMenuDelegate.getMenuItemCount());
        this.contextMenuDelegate.removeMenuItem(menuItemWithoutIcon);
        ContextMenuDelegateTest.assertEquals((int)1, (int)this.contextMenuDelegate.getMenuItemCount());
        this.contextMenuDelegate.removeMenuItem(menuItemWithIcon);
        ContextMenuDelegateTest.assertEquals((int)0, (int)this.contextMenuDelegate.getMenuItemCount());
    }
}

