/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import org.eclipse.core.databinding.BindingException;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.ui.ridgets.swt.AbstractSWTRidgetTest;
import org.eclipse.riena.internal.ui.ridgets.swt.EmbeddedTitleBarRidget;
import org.eclipse.riena.ui.core.marker.ErrorMarker;
import org.eclipse.riena.ui.core.marker.MandatoryMarker;
import org.eclipse.riena.ui.core.marker.NegativeMarker;
import org.eclipse.riena.ui.core.marker.OutputMarker;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.swt.EmbeddedTitleBar;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Widget;

public class EmbeddedTitleBarRidgetTest
extends AbstractSWTRidgetTest {
    private static final String PLUGIN_ID = "org.eclipse.riena.tests:";
    private static final String ICON_ECLIPSE = "org.eclipse.riena.tests:/icons/eclipse.gif";
    private static final String LABEL = "testlabel";
    private static final String LABEL2 = "testlabel2";

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.getRidget().setTitle(LABEL);
    }

    @Override
    protected IRidget createRidget() {
        return new EmbeddedTitleBarRidget();
    }

    protected EmbeddedTitleBarRidget getRidget() {
        return (EmbeddedTitleBarRidget)super.getRidget();
    }

    protected Control createWidget(Composite parent) {
        return new EmbeddedTitleBar(parent, 0);
    }

    public void testSetTitle() {
        EmbeddedTitleBarRidget ridget = this.getRidget();
        EmbeddedTitleBar control = ridget.getUIControl();
        ridget.setTitle(LABEL2);
        EmbeddedTitleBarRidgetTest.assertEquals((String)LABEL2, (String)ridget.getTitle());
        EmbeddedTitleBarRidgetTest.assertEquals((String)LABEL2, (String)control.getTitle());
        ridget.setTitle("");
        EmbeddedTitleBarRidgetTest.assertEquals((String)"", (String)control.getTitle());
        ridget.setTitle(null);
        EmbeddedTitleBarRidgetTest.assertNull((Object)ridget.getTitle());
        EmbeddedTitleBarRidgetTest.assertNull((Object)control.getTitle());
    }

    public void testSetIcon() {
        EmbeddedTitleBarRidget ridget = this.getRidget();
        EmbeddedTitleBar control = ridget.getUIControl();
        ridget.setIcon(ICON_ECLIPSE);
        EmbeddedTitleBarRidgetTest.assertEquals((String)ICON_ECLIPSE, (String)ridget.getIcon());
        EmbeddedTitleBarRidgetTest.assertNotNull((Object)control.getImage());
        ridget.setIcon(null);
        EmbeddedTitleBarRidgetTest.assertNull((Object)ridget.getIcon());
        EmbeddedTitleBarRidgetTest.assertNull((Object)control.getImage());
    }

    public void testCheckUIControl() {
        EmbeddedTitleBarRidget ridget = this.getRidget();
        EmbeddedTitleBar control = ridget.getUIControl();
        ReflectionUtils.invokeHidden((Object)ridget, (String)"checkUIControl", (Object[])new Object[]{control});
        Label label = new Label(control.getParent(), 0);
        try {
            ReflectionUtils.invokeHidden((Object)ridget, (String)"checkUIControl", (Object[])new Object[]{label});
            EmbeddedTitleBarRidgetTest.fail((String)"Missing expected BindingException!");
        }
        catch (Exception e) {
            EmbeddedTitleBarRidgetTest.assertTrue((boolean)(e.getCause() instanceof BindingException));
        }
        SwtUtilities.dispose((Widget)label);
    }

    public void testUnsupportedMarkersIgnored() {
        this.assertMarkerIgnored((IMarker)new ErrorMarker());
        this.assertMarkerIgnored((IMarker)new MandatoryMarker());
        this.assertMarkerIgnored((IMarker)new OutputMarker());
        this.assertMarkerIgnored((IMarker)new NegativeMarker());
    }
}

