/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.riena.internal.ui.ridgets.swt.AbstractRidgetTestCase;
import org.eclipse.riena.internal.ui.ridgets.swt.MessageBoxRidget;
import org.eclipse.riena.internal.ui.swt.test.UITestHelper;
import org.eclipse.riena.ui.ridgets.IMessageBoxRidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.listener.FocusEvent;
import org.eclipse.riena.ui.ridgets.listener.IFocusListener;
import org.eclipse.riena.ui.swt.MessageBox;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class MessageBoxRidgetTest
extends AbstractRidgetTestCase {
    protected MessageBox createWidget(Composite parent) {
        return new MockMessageBox(parent);
    }

    @Override
    protected IRidget createRidget() {
        return new MessageBoxRidget();
    }

    protected IMessageBoxRidget getRidget() {
        return (IMessageBoxRidget)super.getRidget();
    }

    protected MockMessageBox getWidget() {
        return (MockMessageBox)((Object)super.getWidget());
    }

    public void testSetText() throws Exception {
        this.getRidget().show();
        MessageBoxRidgetTest.assertNull((Object)this.getWidget().text);
        MessageBoxRidgetTest.assertNull((Object)this.getRidget().getText());
        this.getRidget().setText("TestMessageText");
        this.getRidget().show();
        MessageBoxRidgetTest.assertEquals((String)"TestMessageText", (String)this.getWidget().text);
        MessageBoxRidgetTest.assertEquals((String)"TestMessageText", (String)this.getRidget().getText());
    }

    public void testSetTitle() throws Exception {
        this.getRidget().show();
        MessageBoxRidgetTest.assertNull((Object)this.getWidget().title);
        MessageBoxRidgetTest.assertNull((Object)this.getRidget().getTitle());
        this.getRidget().setTitle("TestMessageTitle");
        this.getRidget().show();
        MessageBoxRidgetTest.assertEquals((String)"TestMessageTitle", (String)this.getWidget().title);
        MessageBoxRidgetTest.assertEquals((String)"TestMessageTitle", (String)this.getRidget().getTitle());
    }

    public void testSetType() throws Exception {
        this.getRidget().show();
        MessageBoxRidgetTest.assertEquals((int)0, (int)this.getWidget().type);
        MessageBoxRidgetTest.assertEquals((Object)IMessageBoxRidget.Type.PLAIN, (Object)this.getRidget().getType());
        this.getRidget().setType(IMessageBoxRidget.Type.ERROR);
        this.getRidget().show();
        MessageBoxRidgetTest.assertEquals((int)1, (int)this.getWidget().type);
        MessageBoxRidgetTest.assertEquals((Object)IMessageBoxRidget.Type.ERROR, (Object)this.getRidget().getType());
        this.getRidget().setType(IMessageBoxRidget.Type.WARNING);
        this.getRidget().show();
        MessageBoxRidgetTest.assertEquals((int)4, (int)this.getWidget().type);
        MessageBoxRidgetTest.assertEquals((Object)IMessageBoxRidget.Type.WARNING, (Object)this.getRidget().getType());
        this.getRidget().setType(IMessageBoxRidget.Type.INFORMATION);
        this.getRidget().show();
        MessageBoxRidgetTest.assertEquals((int)2, (int)this.getWidget().type);
        MessageBoxRidgetTest.assertEquals((Object)IMessageBoxRidget.Type.INFORMATION, (Object)this.getRidget().getType());
        this.getRidget().setType(IMessageBoxRidget.Type.HELP);
        this.getRidget().show();
        MessageBoxRidgetTest.assertEquals((int)2, (int)this.getWidget().type);
        MessageBoxRidgetTest.assertEquals((Object)IMessageBoxRidget.Type.HELP, (Object)this.getRidget().getType());
        this.getRidget().setType(IMessageBoxRidget.Type.QUESTION);
        this.getRidget().show();
        MessageBoxRidgetTest.assertEquals((int)3, (int)this.getWidget().type);
        MessageBoxRidgetTest.assertEquals((Object)IMessageBoxRidget.Type.QUESTION, (Object)this.getRidget().getType());
        this.getRidget().setType(null);
        this.getRidget().show();
        MessageBoxRidgetTest.assertEquals((int)0, (int)this.getWidget().type);
        MessageBoxRidgetTest.assertEquals((Object)IMessageBoxRidget.Type.PLAIN, (Object)this.getRidget().getType());
    }

    public void testSetOptions() throws Exception {
        this.getRidget().show();
        MessageBoxRidgetTest.assertEquals((int)1, (int)this.getWidget().buttonLabels.length);
        MessageBoxRidgetTest.assertEquals((String)IDialogConstants.OK_LABEL, (String)this.getWidget().buttonLabels[0]);
        this.assertEquals(IMessageBoxRidget.OPTIONS_OK, this.getRidget().getOptions());
        this.getRidget().setOptions(IMessageBoxRidget.OPTIONS_YES_NO);
        this.getRidget().show();
        MessageBoxRidgetTest.assertEquals((int)2, (int)this.getWidget().buttonLabels.length);
        MessageBoxRidgetTest.assertEquals((String)IDialogConstants.YES_LABEL, (String)this.getWidget().buttonLabels[0]);
        MessageBoxRidgetTest.assertEquals((String)IDialogConstants.NO_LABEL, (String)this.getWidget().buttonLabels[1]);
        this.assertEquals(IMessageBoxRidget.OPTIONS_YES_NO, this.getRidget().getOptions());
        this.getRidget().setOptions(IMessageBoxRidget.OPTIONS_OK_CANCEL);
        this.getRidget().show();
        MessageBoxRidgetTest.assertEquals((int)2, (int)this.getWidget().buttonLabels.length);
        MessageBoxRidgetTest.assertEquals((String)IDialogConstants.OK_LABEL, (String)this.getWidget().buttonLabels[0]);
        MessageBoxRidgetTest.assertEquals((String)IDialogConstants.CANCEL_LABEL, (String)this.getWidget().buttonLabels[1]);
        this.assertEquals(IMessageBoxRidget.OPTIONS_OK_CANCEL, this.getRidget().getOptions());
        this.getRidget().setOptions(IMessageBoxRidget.OPTIONS_YES_NO_CANCEL);
        this.getRidget().show();
        MessageBoxRidgetTest.assertEquals((int)3, (int)this.getWidget().buttonLabels.length);
        MessageBoxRidgetTest.assertEquals((String)IDialogConstants.YES_LABEL, (String)this.getWidget().buttonLabels[0]);
        MessageBoxRidgetTest.assertEquals((String)IDialogConstants.NO_LABEL, (String)this.getWidget().buttonLabels[1]);
        MessageBoxRidgetTest.assertEquals((String)IDialogConstants.CANCEL_LABEL, (String)this.getWidget().buttonLabels[2]);
        this.assertEquals(IMessageBoxRidget.OPTIONS_YES_NO_CANCEL, this.getRidget().getOptions());
        IMessageBoxRidget.MessageBoxOption[] semiCustomOptions = new IMessageBoxRidget.MessageBoxOption[]{IMessageBoxRidget.OK, new IMessageBoxRidget.MessageBoxOption("TestCustomOptionText")};
        this.getRidget().setOptions(semiCustomOptions);
        this.getRidget().show();
        MessageBoxRidgetTest.assertEquals((int)2, (int)this.getWidget().buttonLabels.length);
        MessageBoxRidgetTest.assertEquals((String)"OK", (String)this.getWidget().buttonLabels[0]);
        MessageBoxRidgetTest.assertEquals((String)"TestCustomOptionText", (String)this.getWidget().buttonLabels[1]);
        this.assertEquals(semiCustomOptions, this.getRidget().getOptions());
        IMessageBoxRidget.MessageBoxOption[] customOptions = new IMessageBoxRidget.MessageBoxOption[]{new IMessageBoxRidget.MessageBoxOption("TestCustomOptionText1"), new IMessageBoxRidget.MessageBoxOption("TestCustomOptionText2"), new IMessageBoxRidget.MessageBoxOption("TestCustomOptionText3")};
        this.getRidget().setOptions(customOptions);
        this.getRidget().show();
        MessageBoxRidgetTest.assertEquals((int)3, (int)this.getWidget().buttonLabels.length);
        MessageBoxRidgetTest.assertEquals((String)"TestCustomOptionText1", (String)this.getWidget().buttonLabels[0]);
        MessageBoxRidgetTest.assertEquals((String)"TestCustomOptionText2", (String)this.getWidget().buttonLabels[1]);
        MessageBoxRidgetTest.assertEquals((String)"TestCustomOptionText3", (String)this.getWidget().buttonLabels[2]);
        this.assertEquals(customOptions, this.getRidget().getOptions());
        this.getRidget().setOptions(IMessageBoxRidget.OPTIONS_OK);
        this.getRidget().show();
        MessageBoxRidgetTest.assertEquals((int)1, (int)this.getWidget().buttonLabels.length);
        MessageBoxRidgetTest.assertEquals((String)IDialogConstants.OK_LABEL, (String)this.getWidget().buttonLabels[0]);
        this.assertEquals(IMessageBoxRidget.OPTIONS_OK, this.getRidget().getOptions());
    }

    public void testUsedInSharedView() throws Exception {
        this.getRidget().setText("TestMessageText1");
        this.getRidget().setTitle("TestMessageTitle1");
        this.getRidget().setType(IMessageBoxRidget.Type.QUESTION);
        this.getRidget().setOptions(IMessageBoxRidget.OPTIONS_OK_CANCEL);
        this.getRidget().show();
        MessageBoxRidget ridget2 = new MessageBoxRidget();
        ridget2.setText("TestMessageText2");
        ridget2.setTitle("TestMessageTitle2");
        ridget2.setType(IMessageBoxRidget.Type.WARNING);
        ridget2.setOptions(new IMessageBoxRidget.MessageBoxOption[]{new IMessageBoxRidget.MessageBoxOption("TestCustomOption")});
        this.getRidget().setUIControl(null);
        ridget2.setUIControl((Object)this.getWidget());
        ridget2.show();
        MessageBoxRidgetTest.assertEquals((String)"TestMessageText2", (String)this.getWidget().text);
        MessageBoxRidgetTest.assertEquals((String)"TestMessageTitle2", (String)this.getWidget().title);
        MessageBoxRidgetTest.assertEquals((int)4, (int)this.getWidget().type);
        MessageBoxRidgetTest.assertEquals((int)1, (int)this.getWidget().buttonLabels.length);
        MessageBoxRidgetTest.assertEquals((String)"TestCustomOption", (String)this.getWidget().buttonLabels[0]);
        this.getRidget().setUIControl((Object)this.getWidget());
        this.getRidget().show();
        ridget2.setUIControl(null);
        MessageBoxRidgetTest.assertEquals((String)"TestMessageText1", (String)this.getWidget().text);
        MessageBoxRidgetTest.assertEquals((String)"TestMessageTitle1", (String)this.getWidget().title);
        MessageBoxRidgetTest.assertEquals((int)3, (int)this.getWidget().type);
        MessageBoxRidgetTest.assertEquals((int)2, (int)this.getWidget().buttonLabels.length);
        MessageBoxRidgetTest.assertEquals((String)IDialogConstants.OK_LABEL, (String)this.getWidget().buttonLabels[0]);
        MessageBoxRidgetTest.assertEquals((String)IDialogConstants.CANCEL_LABEL, (String)this.getWidget().buttonLabels[1]);
    }

    public void testShow() throws Exception {
        this.getRidget().setTitle("TestMessageTitle");
        this.getRidget().setText("TestMessageText");
        this.getRidget().setType(IMessageBoxRidget.Type.QUESTION);
        this.getRidget().setOptions(IMessageBoxRidget.OPTIONS_YES_NO);
        this.setMessageBoxReturnValue(0);
        MessageBoxRidgetTest.assertEquals((Object)IMessageBoxRidget.YES, (Object)this.getRidget().show());
        this.setMessageBoxReturnValue(-1);
        MessageBoxRidgetTest.assertEquals((Object)IMessageBoxRidget.CLOSED, (Object)this.getRidget().show());
        IMessageBoxRidget.MessageBoxOption option3 = new IMessageBoxRidget.MessageBoxOption("TestCustomOption3");
        this.getRidget().setOptions(new IMessageBoxRidget.MessageBoxOption[]{new IMessageBoxRidget.MessageBoxOption("TestCustomOption1"), new IMessageBoxRidget.MessageBoxOption("TestCustomOption2"), option3, new IMessageBoxRidget.MessageBoxOption("TestCustomOption4")});
        this.setMessageBoxReturnValue(2);
        MessageBoxRidgetTest.assertEquals((Object)option3, (Object)this.getRidget().show());
        this.setMessageBoxReturnValue(-1);
        MessageBoxRidgetTest.assertEquals((Object)IMessageBoxRidget.CLOSED, (Object)this.getRidget().show());
        this.getRidget().setUIControl(null);
        MessageBoxRidgetTest.assertNull((Object)this.getRidget().show());
    }

    public void testGetID() throws Exception {
        this.getWidget().setPropertyName("testId");
        MessageBoxRidgetTest.assertEquals((String)"testId", (String)this.getRidget().getID());
    }

    public void testGetSetUIControl() throws Exception {
        MessageBoxRidgetTest.assertEquals((Object)((Object)this.getWidget()), (Object)this.getRidget().getUIControl());
        this.getRidget().setUIControl(null);
        MessageBoxRidgetTest.assertEquals(null, (Object)this.getRidget().getUIControl());
        this.getRidget().setUIControl((Object)this.getWidget());
        MessageBoxRidgetTest.assertEquals((Object)((Object)this.getWidget()), (Object)this.getRidget().getUIControl());
    }

    public void testGetFocusable() {
        IMessageBoxRidget aRidget = this.getRidget();
        MessageBoxRidgetTest.assertTrue((boolean)aRidget.isFocusable());
        aRidget.setFocusable(false);
        MessageBoxRidgetTest.assertFalse((boolean)aRidget.isFocusable());
        aRidget.setFocusable(true);
        MessageBoxRidgetTest.assertTrue((boolean)aRidget.isFocusable());
    }

    public void testSetFocusable() {
        IMessageBoxRidget aRidget = this.getRidget();
        MockMessageBox aControl = this.getWidget();
        aControl.requestFocus();
        if (aControl.hasFocus()) {
            aRidget.setFocusable(false);
            this.getOtherControl().setFocus();
            MessageBoxRidgetTest.assertTrue((boolean)this.getOtherControl().isFocusControl());
            UITestHelper.sendString((Display)this.getOtherControl().getDisplay(), (String)"\t");
            MessageBoxRidgetTest.assertFalse((boolean)aControl.hasFocus());
            aRidget.setFocusable(true);
            this.getOtherControl().setFocus();
            UITestHelper.sendString((Display)this.getOtherControl().getDisplay(), (String)"\t");
            MessageBoxRidgetTest.assertTrue((boolean)aControl.hasFocus());
        }
    }

    public void testRequestFocus() throws Exception {
        MockMessageBox aControl = this.getWidget();
        aControl.requestFocus();
        if (aControl.hasFocus()) {
            MessageBoxRidgetTest.assertTrue((boolean)this.getOtherControl().setFocus());
            MessageBoxRidgetTest.assertFalse((boolean)aControl.hasFocus());
            MessageBoxRidgetTest.assertFalse((boolean)this.getRidget().hasFocus());
            final ArrayList focusGainedEvents = new ArrayList();
            final ArrayList focusLostEvents = new ArrayList();
            IFocusListener focusListener = new IFocusListener(){

                public void focusGained(FocusEvent event) {
                    focusGainedEvents.add(event);
                }

                public void focusLost(FocusEvent event) {
                    focusLostEvents.add(event);
                }
            };
            this.getRidget().addFocusListener(focusListener);
            this.getRidget().requestFocus();
            MessageBoxRidgetTest.assertTrue((boolean)aControl.hasFocus());
            MessageBoxRidgetTest.assertTrue((boolean)this.getRidget().hasFocus());
            MessageBoxRidgetTest.assertEquals((int)1, (int)focusGainedEvents.size());
            MessageBoxRidgetTest.assertEquals((Object)this.getRidget(), (Object)((FocusEvent)focusGainedEvents.get(0)).getNewFocusOwner());
            MessageBoxRidgetTest.assertEquals((int)0, (int)focusLostEvents.size());
            MessageBoxRidgetTest.assertTrue((boolean)this.getOtherControl().setFocus());
            MessageBoxRidgetTest.assertFalse((boolean)aControl.hasFocus());
            MessageBoxRidgetTest.assertFalse((boolean)this.getRidget().hasFocus());
            MessageBoxRidgetTest.assertEquals((int)1, (int)focusGainedEvents.size());
            MessageBoxRidgetTest.assertEquals((int)1, (int)focusLostEvents.size());
            MessageBoxRidgetTest.assertEquals((Object)this.getRidget(), (Object)((FocusEvent)focusLostEvents.get(0)).getOldFocusOwner());
            this.getRidget().removeFocusListener(focusListener);
            this.getRidget().requestFocus();
            MessageBoxRidgetTest.assertTrue((boolean)this.getOtherControl().setFocus());
            MessageBoxRidgetTest.assertEquals((int)1, (int)focusGainedEvents.size());
            MessageBoxRidgetTest.assertEquals((int)1, (int)focusLostEvents.size());
        }
    }

    @Override
    public void testFiresTooltipProperty() {
    }

    @Override
    public void testIsVisible() {
        MessageBoxRidgetTest.assertFalse((boolean)this.getRidget().isVisible());
        this.getRidget().setVisible(true);
        super.testIsVisible();
    }

    private void setMessageBoxReturnValue(final int returnValue) {
        this.getRidget().setUIControl((Object)new MessageBox((Composite)this.getShell()){

            public void show(String title, String text, int type, String[] buttonLabels) {
            }

            public int getResult() {
                return returnValue;
            }
        });
    }

    private void assertEquals(IMessageBoxRidget.MessageBoxOption[] expected, IMessageBoxRidget.MessageBoxOption[] actual) {
        if (Arrays.equals(expected, actual)) {
            return;
        }
        MessageBoxRidgetTest.failNotEquals(null, (Object)expected, (Object)actual);
    }

    private static final class MockMessageBox
    extends MessageBox {
        private String title;
        private String text;
        private int type;
        private String[] buttonLabels;

        private MockMessageBox(Composite parent) {
            super(parent);
        }

        public void show(String title, String text, int type, String[] buttonLabels) {
            this.title = title;
            this.text = text;
            this.type = type;
            this.buttonLabels = buttonLabels;
        }
    }
}

