/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.riena.internal.ui.ridgets.swt.AbstractSWTRidgetTest;
import org.eclipse.riena.internal.ui.ridgets.swt.TextRidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.ITextRidget;
import org.eclipse.riena.ui.ridgets.swt.uibinding.SwtControlRidgetMapper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Text;

public class TextRidgetTest
extends AbstractSWTRidgetTest {
    @Override
    protected IRidget createRidget() {
        return new TextRidget();
    }

    protected Control createWidget(Composite parent) {
        return new Text((Composite)this.getShell(), 0);
    }

    protected ITextRidget getRidget() {
        return (ITextRidget)super.getRidget();
    }

    protected Text getWidget() {
        return (Text)super.getWidget();
    }

    public void testRidgetMapping() {
        SwtControlRidgetMapper mapper = SwtControlRidgetMapper.getInstance();
        TextRidgetTest.assertSame(TextRidget.class, (Object)mapper.getRidgetClass((Object)this.getWidget()));
    }

    public void testCreate() throws Exception {
        TextRidgetTest.assertFalse((boolean)this.getRidget().isDirectWriting());
        TextRidgetTest.assertEquals((String)"", (String)this.getRidget().getText());
    }

    public void testSetUIControl() throws Exception {
        TextRidgetTest.assertSame((Object)this.getWidget(), (Object)this.getRidget().getUIControl());
    }

    public void testSetText() throws Exception {
        TextPojo model = new TextPojo();
        IObservableValue modelOV = PojoObservables.observeValue((Object)model, (String)"text1");
        ITextRidget ridget = this.getRidget();
        ridget.bindToModel(modelOV);
        ridget.setText("first");
        TextRidgetTest.assertEquals((String)"first", (String)ridget.getText());
        TextRidgetTest.assertEquals((String)"first", (String)model.getText1());
        TextRidgetTest.assertEquals((String)"first", (String)this.getWidget().getText());
    }

    public void testSetTextNull() {
        ITextRidget ridget = this.getRidget();
        ridget.setText("huhu");
        TextRidgetTest.assertTrue((ridget.getText().length() > 0 ? 1 : 0) != 0);
        ridget.setText(null);
        TextRidgetTest.assertEquals((String)"", (String)ridget.getText());
    }

    public void testGetText() throws Exception {
        ITextRidget ridget = this.getRidget();
        TextRidgetTest.assertEquals((String)"", (String)ridget.getText());
        TextPojo model = new TextPojo();
        IObservableValue modelOV = PojoObservables.observeValue((Object)model, (String)"text2");
        ridget.bindToModel(modelOV);
        TextRidgetTest.assertEquals((String)"", (String)ridget.getText());
        ridget.updateFromModel();
        TextRidgetTest.assertEquals((String)model.getText2(), (String)ridget.getText());
    }

    public void testBindToModelIObservableValue() throws Exception {
        ITextRidget ridget = this.getRidget();
        TextPojo model = new TextPojo();
        IObservableValue modelOV = PojoObservables.observeValue((Object)model, (String)"text1");
        ridget.bindToModel(modelOV);
        TextRidgetTest.assertEquals((String)"", (String)ridget.getText());
        ridget.updateFromModel();
        TextRidgetTest.assertEquals((String)model.getText1(), (String)ridget.getText());
    }

    public void testUpdateFromModel() throws Exception {
        ITextRidget ridget = this.getRidget();
        TextPojo model = new TextPojo();
        ridget.bindToModel((Object)model, "text2");
        model.setText2("second");
        ridget.updateFromModel();
        TextRidgetTest.assertEquals((String)"second", (String)this.getWidget().getText());
    }

    public void testFocusGainedDoesSelectOnSingleText() {
        ITextRidget ridget = this.getRidget();
        Text control = this.getWidget();
        ridget.setText("foo");
        control.setSelection(0, 0);
        TextRidgetTest.assertEquals((String)"", (String)control.getSelectionText());
        Event e = new Event();
        e.type = 15;
        e.widget = control;
        e.widget.notifyListeners(e.type, e);
        TextRidgetTest.assertEquals((int)0, (int)(control.getStyle() & 2));
        TextRidgetTest.assertEquals((String)"foo", (String)control.getSelectionText());
    }

    public void testFocusGainedDoesNotSelectOnMultiLineText() {
        ITextRidget ridget = this.getRidget();
        Text control = new Text((Composite)this.getShell(), 2);
        ridget.setUIControl((Object)control);
        ridget.setText("line 1\nline 2");
        control.setSelection(0, 0);
        TextRidgetTest.assertEquals((String)"", (String)control.getSelectionText());
        Event e = new Event();
        e.type = 15;
        e.widget = control;
        e.widget.notifyListeners(e.type, e);
        TextRidgetTest.assertFalse(((control.getStyle() & 2) == 0 ? 1 : 0) != 0);
        TextRidgetTest.assertEquals((String)"", (String)control.getSelectionText());
    }

    public void testSetOutputPreservesBackground() {
        ITextRidget ridget = this.getRidget();
        Text control = this.getWidget();
        Color oldBg = control.getBackground();
        ridget.setEnabled(false);
        ridget.setOutputOnly(true);
        ridget.setEnabled(true);
        ridget.setOutputOnly(false);
        TextRidgetTest.assertEquals((Object)oldBg, (Object)control.getBackground());
    }

    public void testBindToModelPropertyName() throws Exception {
        ITextRidget ridget = this.getRidget();
        TextPojo model = new TextPojo();
        ridget.bindToModel((Object)model, "text2");
        TextRidgetTest.assertEquals((String)"", (String)ridget.getText());
        ridget.updateFromModel();
        TextRidgetTest.assertEquals((String)model.getText2(), (String)ridget.getText());
    }

    private static class TextPojo {
        private String text1 = "one";
        private String text2 = "two";

        public String getText1() {
            return this.text1;
        }

        public void setText1(String text1) {
            this.text1 = text1;
        }

        public String getText2() {
            return this.text2;
        }

        public void setText2(String text2) {
            this.text2 = text2;
        }
    }
}

