/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import junit.framework.TestCase;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.map.ObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.riena.beans.common.WordNode;
import org.eclipse.riena.core.test.collect.UITestCase;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.ui.ridgets.swt.Activator;
import org.eclipse.riena.internal.ui.ridgets.swt.TreeRidgetLabelProvider;
import org.eclipse.riena.ui.ridgets.IColumnFormatter;
import org.eclipse.riena.ui.ridgets.swt.ColumnFormatter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

@UITestCase
public class TreeRidgetLabelProviderTest
extends TestCase {
    private static final String ICON_ECLIPSE = "eclipse.gif";
    private static final String[] COLUMN_PROPERTIES = new String[]{"word", "upperCase"};
    private Shell shell;
    private TreeViewer viewer;
    private TreeRidgetLabelProvider labelProvider;
    private WordNode node;
    private WordNode leaf;
    private WordNode alpha;
    private Color colorA;
    private Color colorB;
    private Font fontA;
    private Font fontB;
    private IColumnFormatter[] formatters;
    private IColumnFormatter[] noFormatters;

    protected void setUp() throws Exception {
        Display display = Display.getDefault();
        Realm realm = SWTObservables.getRealm((Display)display);
        ReflectionUtils.invokeHidden((Object)realm, (String)"setDefault", (Object[])new Object[]{realm});
        this.colorA = display.getSystemColor(3);
        this.colorB = display.getSystemColor(5);
        this.fontA = new Font((Device)display, "Arial", 12, 0);
        this.fontB = new Font((Device)display, "Courier", 12, 0);
        this.shell = new Shell(display);
        this.viewer = new TreeViewer(this.createTree(this.shell));
        IObservableSet elements = this.createElements();
        IColumnFormatter[] iColumnFormatterArray = new IColumnFormatter[2];
        iColumnFormatterArray[0] = new TestColumnFormatter();
        this.formatters = iColumnFormatterArray;
        this.noFormatters = new IColumnFormatter[COLUMN_PROPERTIES.length];
        this.labelProvider = TreeRidgetLabelProvider.createLabelProvider((TreeViewer)this.viewer, WordNode.class, (IObservableSet)elements, (String[])COLUMN_PROPERTIES, null, null, null, (IColumnFormatter[])this.noFormatters);
        this.viewer.setContentProvider((IContentProvider)new FTTreeContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer.setInput((Object)elements.toArray());
    }

    protected void tearDown() throws Exception {
        this.shell.dispose();
        this.fontA.dispose();
        this.fontB.dispose();
    }

    public void testGetText() {
        TreeRidgetLabelProviderTest.assertEquals((String)"Node", (String)this.labelProvider.getText((Object)this.node));
        TreeRidgetLabelProviderTest.assertEquals((String)"LEAF", (String)this.labelProvider.getText((Object)this.leaf));
    }

    public void testGetColumnText() {
        TreeRidgetLabelProviderTest.assertEquals((String)"Node", (String)this.labelProvider.getColumnText((Object)this.node, 0));
        TreeRidgetLabelProviderTest.assertEquals((String)"LEAF", (String)this.labelProvider.getColumnText((Object)this.leaf, 0));
        TreeRidgetLabelProviderTest.assertEquals((String)"false", (String)this.labelProvider.getColumnText((Object)this.node, 1));
        TreeRidgetLabelProviderTest.assertEquals((String)"true", (String)this.labelProvider.getColumnText((Object)this.leaf, 1));
        TreeRidgetLabelProviderTest.assertNull((Object)this.labelProvider.getColumnText((Object)this.node, 99));
        ReflectionUtils.invokeHidden((Object)this.labelProvider, (String)"setFormatters", (Object[])new Object[]{new IColumnFormatter[2]});
        ReflectionUtils.setHidden((Object)this.labelProvider, (String)"attributeMaps", (Object)new IObservableMap[]{new ObservableMap(new HashMap()), new ObservableMap(new HashMap())});
        String[] valuesAccessors = new String[]{"aCount"};
        ReflectionUtils.setHidden((Object)this.labelProvider, (String)"valueAccessors", (Object)valuesAccessors);
        this.node = new WordNode("AAAaaaa");
        TreeRidgetLabelProviderTest.assertEquals((String)"7", (String)this.labelProvider.getColumnText((Object)this.node, 0));
    }

    public void testGetImage() {
        this.viewer.collapseAll();
        Image siCollapsed = Activator.getSharedImage((String)"IMG_NODE_COLLAPSED");
        TreeRidgetLabelProviderTest.assertNotNull((Object)siCollapsed);
        Image nodeCollapsed = this.labelProvider.getImage((Object)this.node);
        TreeRidgetLabelProviderTest.assertSame((Object)siCollapsed, (Object)nodeCollapsed);
        this.viewer.expandAll();
        Image siExpanded = Activator.getSharedImage((String)"IMG_NODE_EXPANDED");
        TreeRidgetLabelProviderTest.assertNotNull((Object)siExpanded);
        Image nodeExpanded = this.labelProvider.getImage((Object)this.node);
        TreeRidgetLabelProviderTest.assertSame((Object)siExpanded, (Object)nodeExpanded);
        this.viewer.collapseToLevel((Object)this.node, 1);
        TreeRidgetLabelProviderTest.assertSame((Object)siCollapsed, (Object)this.labelProvider.getImage((Object)this.node));
        this.viewer.expandToLevel((Object)this.node, 1);
        TreeRidgetLabelProviderTest.assertSame((Object)siExpanded, (Object)this.labelProvider.getImage((Object)this.node));
        Image siLeaf = Activator.getSharedImage((String)"IMG_LEAF");
        TreeRidgetLabelProviderTest.assertNotNull((Object)siLeaf);
        Image imgLeaf = this.labelProvider.getImage((Object)this.leaf);
        TreeRidgetLabelProviderTest.assertSame((Object)siLeaf, (Object)imgLeaf);
        TreeRidgetLabelProviderTest.assertNotSame((Object)nodeExpanded, (Object)nodeCollapsed);
        TreeRidgetLabelProviderTest.assertNotSame((Object)nodeExpanded, (Object)imgLeaf);
        TreeRidgetLabelProviderTest.assertNotSame((Object)nodeCollapsed, (Object)imgLeaf);
    }

    public void testGetImageFromProviderMethod() {
        WordNodeWithIcon nodeWithIcon = new WordNodeWithIcon("nwi");
        nodeWithIcon.setIcon("closed_16.gif");
        nodeWithIcon.setOpenIcon("open_16.gif");
        WordNodeWithIcon leafWithIcon = new WordNodeWithIcon(nodeWithIcon, "lwi");
        leafWithIcon.setIcon(ICON_ECLIPSE);
        WritableSet elements = new WritableSet(Realm.getDefault(), Arrays.asList(new WordNode[]{nodeWithIcon, leafWithIcon}), WordNodeWithIcon.class);
        this.labelProvider = TreeRidgetLabelProvider.createLabelProvider((TreeViewer)this.viewer, WordNodeWithIcon.class, (IObservableSet)elements, (String[])COLUMN_PROPERTIES, null, (String)"icon", (String)"openIcon", (IColumnFormatter[])this.noFormatters);
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer.setInput((Object)elements.toArray());
        this.viewer.collapseAll();
        Image siCollapsed = Activator.getSharedImage((String)"closed_16.gif");
        TreeRidgetLabelProviderTest.assertNotNull((Object)siCollapsed);
        Image nodeCollapsed = this.labelProvider.getImage((Object)nodeWithIcon);
        TreeRidgetLabelProviderTest.assertSame((Object)siCollapsed, (Object)nodeCollapsed);
        this.viewer.expandAll();
        Image siExpanded = Activator.getSharedImage((String)"open_16.gif");
        TreeRidgetLabelProviderTest.assertNotNull((Object)siExpanded);
        Image nodeExpanded = this.labelProvider.getImage((Object)nodeWithIcon);
        TreeRidgetLabelProviderTest.assertSame((Object)siExpanded, (Object)nodeExpanded);
        Image siLeaf = Activator.getSharedImage((String)ICON_ECLIPSE);
        TreeRidgetLabelProviderTest.assertNotNull((Object)siLeaf);
        Image imgLeaf = this.labelProvider.getImage((Object)leafWithIcon);
        TreeRidgetLabelProviderTest.assertSame((Object)siLeaf, (Object)imgLeaf);
        TreeRidgetLabelProviderTest.assertNotSame((Object)nodeExpanded, (Object)nodeCollapsed);
        TreeRidgetLabelProviderTest.assertNotSame((Object)nodeExpanded, (Object)imgLeaf);
        TreeRidgetLabelProviderTest.assertNotSame((Object)nodeCollapsed, (Object)imgLeaf);
    }

    public void testGetColumnImage() {
        this.viewer.collapseAll();
        Image siCollapsed = Activator.getSharedImage((String)"IMG_NODE_COLLAPSED");
        TreeRidgetLabelProviderTest.assertNotNull((Object)siCollapsed);
        TreeRidgetLabelProviderTest.assertSame((Object)siCollapsed, (Object)this.labelProvider.getColumnImage((Object)this.node, 0));
        Image siLeaf = Activator.getSharedImage((String)"IMG_LEAF");
        TreeRidgetLabelProviderTest.assertNotNull((Object)siLeaf);
        TreeRidgetLabelProviderTest.assertSame((Object)siLeaf, (Object)this.labelProvider.getColumnImage((Object)this.leaf, 0));
        TreeRidgetLabelProviderTest.assertNotSame((Object)siLeaf, (Object)siCollapsed);
        Image siUnchecked = Activator.getSharedImage((String)"IMG_UNCHECKED");
        TreeRidgetLabelProviderTest.assertNotNull((Object)siUnchecked);
        TreeRidgetLabelProviderTest.assertEquals((Object)siUnchecked, (Object)this.labelProvider.getColumnImage((Object)this.node, 1));
        Image siChecked = Activator.getSharedImage((String)"IMG_CHECKED");
        TreeRidgetLabelProviderTest.assertNotNull((Object)siChecked);
        TreeRidgetLabelProviderTest.assertEquals((Object)siChecked, (Object)this.labelProvider.getColumnImage((Object)this.leaf, 1));
        TreeRidgetLabelProviderTest.assertNotSame((Object)siChecked, (Object)siUnchecked);
        TreeRidgetLabelProviderTest.assertNull((Object)this.labelProvider.getColumnImage((Object)this.node, 99));
    }

    public void testGetForeground() {
        IObservableSet elements = this.createElements();
        WordNode wordNode = this.leaf;
        this.labelProvider = TreeRidgetLabelProvider.createLabelProvider((TreeViewer)this.viewer, WordNode.class, (IObservableSet)elements, (String[])COLUMN_PROPERTIES, (String)"upperCase", null, null, (IColumnFormatter[])this.noFormatters);
        wordNode.setUpperCase(true);
        Color colorEnabled = this.labelProvider.getForeground((Object)wordNode);
        TreeRidgetLabelProviderTest.assertNull((Object)colorEnabled);
        wordNode.setUpperCase(false);
        Color colorDisabled = this.labelProvider.getForeground((Object)wordNode);
        TreeRidgetLabelProviderTest.assertNotNull((Object)colorDisabled);
    }

    public void testGetImageKey() {
        String key = (String)ReflectionUtils.invokeHidden((Object)this.labelProvider, (String)"getImageKey", (Object[])new Object[]{this.leaf});
        TreeRidgetLabelProviderTest.assertEquals((String)"IMG_LEAF", (String)key);
        this.viewer.collapseAll();
        key = (String)ReflectionUtils.invokeHidden((Object)this.labelProvider, (String)"getImageKey", (Object[])new Object[]{this.node});
        TreeRidgetLabelProviderTest.assertEquals((String)"IMG_NODE_COLLAPSED", (String)key);
        this.viewer.expandAll();
        key = (String)ReflectionUtils.invokeHidden((Object)this.labelProvider, (String)"getImageKey", (Object[])new Object[]{this.node});
        TreeRidgetLabelProviderTest.assertEquals((String)"IMG_NODE_EXPANDED", (String)key);
        WordNodeWithIcon nodeWithIcon1 = new WordNodeWithIcon("node");
        WordNodeWithIcon nodeWithIcon2 = new WordNodeWithIcon("node");
        WordNodeWithIcon nodeWithIcon3 = new WordNodeWithIcon("node");
        WritableSet elements = new WritableSet(Realm.getDefault(), Arrays.asList(new WordNode[]{nodeWithIcon1, nodeWithIcon2, nodeWithIcon3}), WordNode.class);
        this.labelProvider = TreeRidgetLabelProvider.createLabelProvider((TreeViewer)this.viewer, WordNodeWithIcon.class, (IObservableSet)elements, (String[])COLUMN_PROPERTIES, null, (String)"icon", null, (IColumnFormatter[])this.noFormatters);
        key = (String)ReflectionUtils.invokeHidden((Object)this.labelProvider, (String)"getImageKey", (Object[])new Object[]{nodeWithIcon1});
        TreeRidgetLabelProviderTest.assertEquals((String)"IMG_LEAF", (String)key);
        nodeWithIcon2.setIcon("unkown");
        key = (String)ReflectionUtils.invokeHidden((Object)this.labelProvider, (String)"getImageKey", (Object[])new Object[]{nodeWithIcon2});
        TreeRidgetLabelProviderTest.assertEquals((String)"IMG_LEAF", (String)key);
        if (Activator.getDefault() != null) {
            nodeWithIcon3.setIcon(ICON_ECLIPSE);
            key = (String)ReflectionUtils.invokeHidden((Object)this.labelProvider, (String)"getImageKey", (Object[])new Object[]{nodeWithIcon3});
            TreeRidgetLabelProviderTest.assertEquals((String)ICON_ECLIPSE, (String)key);
        }
    }

    public void testGetColumnTextWithFormatter() {
        ReflectionUtils.invokeHidden((Object)this.labelProvider, (String)"setFormatters", (Object[])new Object[]{this.formatters});
        TreeRidgetLabelProviderTest.assertEquals((String)"no", (String)this.labelProvider.getColumnText((Object)this.node, 0));
        TreeRidgetLabelProviderTest.assertEquals((String)"yes", (String)this.labelProvider.getColumnText((Object)this.leaf, 0));
        TreeRidgetLabelProviderTest.assertEquals((String)"Alpha", (String)this.labelProvider.getColumnText((Object)this.alpha, 0));
        TreeRidgetLabelProviderTest.assertEquals((String)"false", (String)this.labelProvider.getColumnText((Object)this.node, 1));
        TreeRidgetLabelProviderTest.assertEquals((String)"true", (String)this.labelProvider.getColumnText((Object)this.leaf, 1));
        TreeRidgetLabelProviderTest.assertEquals((String)"false", (String)this.labelProvider.getColumnText((Object)this.alpha, 1));
        TreeRidgetLabelProviderTest.assertNull((Object)this.labelProvider.getColumnText((Object)this.node, 99));
    }

    public void testGetColumnImageWithFormatter() {
        IColumnFormatter[] formatters2 = new IColumnFormatter[]{new TestColumnFormatter(), new TestColumnFormatter()};
        ReflectionUtils.invokeHidden((Object)this.labelProvider, (String)"setFormatters", (Object[])new Object[]{formatters2});
        Image siNode = Activator.getSharedImage((String)"IMG_NODE_COLLAPSED");
        Image siLeaf = Activator.getSharedImage((String)"IMG_LEAF");
        Image siError = Activator.getSharedImage((String)"IMG_ERROR_DECO");
        TreeRidgetLabelProviderTest.assertSame((Object)siNode, (Object)this.labelProvider.getColumnImage((Object)this.node, 0));
        TreeRidgetLabelProviderTest.assertSame((Object)siError, (Object)this.labelProvider.getColumnImage((Object)this.leaf, 0));
        TreeRidgetLabelProviderTest.assertSame((Object)siLeaf, (Object)this.labelProvider.getColumnImage((Object)this.alpha, 0));
        Image siUnchecked = Activator.getSharedImage((String)"IMG_UNCHECKED");
        TreeRidgetLabelProviderTest.assertSame((Object)siUnchecked, (Object)this.labelProvider.getColumnImage((Object)this.alpha, 1));
        TreeRidgetLabelProviderTest.assertNull((Object)this.labelProvider.getColumnImage((Object)this.node, 99));
    }

    public void testUpdateColumnImageWithFormatter() {
        final Image image = ImageDescriptor.getMissingImageDescriptor().createImage();
        try {
            ColumnFormatter formatter = new ColumnFormatter(){

                public Image getImage(Object element) {
                    return image;
                }
            };
            IColumnFormatter[] iColumnFormatterArray = new IColumnFormatter[2];
            iColumnFormatterArray[0] = formatter;
            IColumnFormatter[] formatters = iColumnFormatterArray;
            TreeRidgetLabelProvider labelProvider = TreeRidgetLabelProvider.createLabelProvider((TreeViewer)this.viewer, WordNode.class, (IObservableSet)this.createElements(), (String[])COLUMN_PROPERTIES, null, null, null, (IColumnFormatter[])formatters);
            TreeItem treeItem = new TreeItem(this.viewer.getTree(), 0);
            new TreeItem(treeItem, 0);
            TreeRidgetLabelProviderTest.assertTrue((treeItem.getItemCount() > 0 ? 1 : 0) != 0);
            TreeRidgetLabelProviderTest.assertNull((Object)treeItem.getImage());
            ReflectionUtils.invokeHidden((Object)labelProvider, (String)"updateNodeImage", (Object[])new Object[]{treeItem, true});
            TreeRidgetLabelProviderTest.assertSame((Object)image, (Object)treeItem.getImage());
            ReflectionUtils.invokeHidden((Object)labelProvider, (String)"updateNodeImage", (Object[])new Object[]{treeItem, false});
            TreeRidgetLabelProviderTest.assertSame((Object)image, (Object)treeItem.getImage());
        }
        finally {
            image.dispose();
        }
    }

    public void testGetForegroundWithFormatter() {
        ReflectionUtils.invokeHidden((Object)this.labelProvider, (String)"setFormatters", (Object[])new Object[]{this.formatters});
        TreeRidgetLabelProviderTest.assertSame((Object)this.colorA, (Object)this.labelProvider.getForeground((Object)this.node, 0));
        TreeRidgetLabelProviderTest.assertSame((Object)this.colorB, (Object)this.labelProvider.getForeground((Object)this.leaf, 0));
        TreeRidgetLabelProviderTest.assertNull((Object)this.labelProvider.getForeground((Object)this.alpha, 0));
        TreeRidgetLabelProviderTest.assertNull((Object)this.labelProvider.getForeground((Object)this.node, 1));
        TreeRidgetLabelProviderTest.assertNull((Object)this.labelProvider.getForeground((Object)this.leaf, 1));
        TreeRidgetLabelProviderTest.assertNull((Object)this.labelProvider.getForeground((Object)this.alpha, 1));
        TreeRidgetLabelProviderTest.assertNull((Object)this.labelProvider.getForeground((Object)this.node, 99));
    }

    public void testGetBackgroundWithFormatter() {
        ReflectionUtils.invokeHidden((Object)this.labelProvider, (String)"setFormatters", (Object[])new Object[]{this.formatters});
        TreeRidgetLabelProviderTest.assertSame((Object)this.colorA, (Object)this.labelProvider.getBackground((Object)this.node, 0));
        TreeRidgetLabelProviderTest.assertSame((Object)this.colorB, (Object)this.labelProvider.getBackground((Object)this.leaf, 0));
        TreeRidgetLabelProviderTest.assertNull((Object)this.labelProvider.getBackground((Object)this.alpha, 0));
        TreeRidgetLabelProviderTest.assertNull((Object)this.labelProvider.getBackground((Object)this.node, 1));
        TreeRidgetLabelProviderTest.assertNull((Object)this.labelProvider.getBackground((Object)this.leaf, 1));
        TreeRidgetLabelProviderTest.assertNull((Object)this.labelProvider.getBackground((Object)this.alpha, 1));
        TreeRidgetLabelProviderTest.assertNull((Object)this.labelProvider.getBackground((Object)this.node, 99));
    }

    public void testGetFontWithFormatter() {
        ReflectionUtils.invokeHidden((Object)this.labelProvider, (String)"setFormatters", (Object[])new Object[]{this.formatters});
        TreeRidgetLabelProviderTest.assertSame((Object)this.fontA, (Object)this.labelProvider.getFont((Object)this.node, 0));
        TreeRidgetLabelProviderTest.assertSame((Object)this.fontB, (Object)this.labelProvider.getFont((Object)this.leaf, 0));
        TreeRidgetLabelProviderTest.assertNull((Object)this.labelProvider.getFont((Object)this.alpha, 0));
        TreeRidgetLabelProviderTest.assertNull((Object)this.labelProvider.getFont((Object)this.node, 1));
        TreeRidgetLabelProviderTest.assertNull((Object)this.labelProvider.getFont((Object)this.leaf, 1));
        TreeRidgetLabelProviderTest.assertNull((Object)this.labelProvider.getFont((Object)this.alpha, 1));
        TreeRidgetLabelProviderTest.assertNull((Object)this.labelProvider.getFont((Object)this.node, 99));
    }

    private IObservableSet createElements() {
        ArrayList<WordNode> collection = new ArrayList<WordNode>();
        this.node = new WordNode("Node");
        this.alpha = new WordNode(this.node, "Alpha");
        this.leaf = new WordNode("Leaf");
        this.leaf.setUpperCase(true);
        collection.add(this.node);
        collection.add(this.leaf);
        collection.add(this.alpha);
        WritableSet elements = new WritableSet(Realm.getDefault(), collection, WordNode.class);
        return elements;
    }

    private Tree createTree(Shell shell) {
        shell.setLayout((Layout)new FillLayout());
        Tree result = new Tree((Composite)shell, 2052);
        TreeColumn tc1 = new TreeColumn(result, 0);
        tc1.setWidth(200);
        TreeColumn tc2 = new TreeColumn(result, 0);
        tc2.setWidth(200);
        return result;
    }

    private static final class FTTreeContentProvider
    implements ITreeContentProvider {
        private FTTreeContentProvider() {
        }

        public Object[] getChildren(Object element) {
            return ((WordNode)element).getChildren().toArray();
        }

        public Object getParent(Object element) {
            return ((WordNode)element).getParent();
        }

        public boolean hasChildren(Object element) {
            return ((WordNode)element).getChildren().size() > 0;
        }

        public Object[] getElements(Object inputElement) {
            return (Object[])inputElement;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private final class TestColumnFormatter
    extends ColumnFormatter {
        private TestColumnFormatter() {
        }

        public String getText(Object element) {
            if (element == TreeRidgetLabelProviderTest.this.leaf || element == TreeRidgetLabelProviderTest.this.node) {
                WordNode wordNode = (WordNode)element;
                return wordNode.isUpperCase() ? "yes" : "no";
            }
            return null;
        }

        public Image getImage(Object element) {
            String word = ((WordNode)element).getWord();
            if ("Leaf".equalsIgnoreCase(word)) {
                return Activator.getSharedImage((String)"IMG_ERROR_DECO");
            }
            return null;
        }

        public Color getForeground(Object element) {
            String word = ((WordNode)element).getWord();
            if ("Node".equalsIgnoreCase(word)) {
                return TreeRidgetLabelProviderTest.this.colorA;
            }
            if ("Leaf".equalsIgnoreCase(word)) {
                return TreeRidgetLabelProviderTest.this.colorB;
            }
            return null;
        }

        public Color getBackground(Object element) {
            String word = ((WordNode)element).getWord();
            if ("Node".equalsIgnoreCase(word)) {
                return TreeRidgetLabelProviderTest.this.colorA;
            }
            if ("Leaf".equalsIgnoreCase(word)) {
                return TreeRidgetLabelProviderTest.this.colorB;
            }
            return null;
        }

        public Font getFont(Object element) {
            String word = ((WordNode)element).getWord();
            if ("Node".equalsIgnoreCase(word)) {
                return TreeRidgetLabelProviderTest.this.fontA;
            }
            if ("Leaf".equalsIgnoreCase(word)) {
                return TreeRidgetLabelProviderTest.this.fontB;
            }
            return null;
        }
    }

    private class WordNodeWithIcon
    extends WordNode {
        private String icon;
        private String openIcon;

        public WordNodeWithIcon(String word) {
            super(word);
        }

        public WordNodeWithIcon(WordNodeWithIcon parent, String word) {
            super((WordNode)parent, word);
        }

        public String getIcon() {
            return this.icon;
        }

        public String getOpenIcon() {
            return this.openIcon;
        }

        public void setIcon(String icon) {
            this.icon = icon;
        }

        public void setOpenIcon(String openIcon) {
            this.openIcon = openIcon;
        }
    }
}

