/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.lnf;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import junit.framework.TestCase;
import org.eclipse.riena.core.test.collect.NonUITestCase;
import org.eclipse.riena.ui.swt.lnf.AbstractLnfResource;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;

@NonUITestCase
public class AbstractLnfResourceTest
extends TestCase {
    private MockLnfResource lnfResource;

    protected void setUp() throws Exception {
        super.setUp();
        this.lnfResource = new MockLnfResource();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.lnfResource = null;
    }

    public void testDispose() throws Exception {
        Color color = (Color)this.lnfResource.getResource();
        AbstractLnfResourceTest.assertNotNull((Object)color);
        AbstractLnfResourceTest.assertFalse((boolean)color.isDisposed());
        AbstractLnfResourceTest.assertFalse((boolean)color.isDisposed());
    }

    public void testGetResource() throws Exception {
        Color color1 = (Color)this.lnfResource.getResource();
        AbstractLnfResourceTest.assertNotNull((Object)color1);
        AbstractLnfResourceTest.assertFalse((boolean)color1.isDisposed());
        color1.dispose();
        Color color2 = (Color)this.lnfResource.getResource();
        AbstractLnfResourceTest.assertNotNull((Object)color2);
        AbstractLnfResourceTest.assertFalse((boolean)color2.isDisposed());
        AbstractLnfResourceTest.assertNotSame((Object)color1, (Object)color2);
    }

    public void testThatTheResourceWillNotBeDisposedIfStillInUse() throws IOException {
        Color color1 = (Color)this.lnfResource.getResource();
        AbstractLnfResourceTest.assertFalse((boolean)color1.isDisposed());
        AbstractLnfResourceTest.assertEquals((int)1, (int)color1.getRed());
        this.runOutOfMemory();
        this.lnfResource.setRed(255);
        Color color2 = (Color)this.lnfResource.getResource();
        AbstractLnfResourceTest.assertEquals((int)1, (int)color2.getRed());
        AbstractLnfResourceTest.assertSame((Object)color1, (Object)color2);
    }

    private void runOutOfMemory() throws IOException {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            while (true) {
                os.write(new byte[0x100000]);
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            System.gc();
            return;
        }
    }

    private static class MockLnfResource
    extends AbstractLnfResource<Color> {
        private int red = 1;

        private MockLnfResource() {
        }

        public void setRed(int red) {
            this.red = red;
        }

        public Color createResource() {
            return new Color((Device)Display.getDefault(), this.red, 1, 1);
        }
    }
}

