/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.views;

import org.eclipse.riena.core.test.RienaTestCase;
import org.eclipse.riena.core.test.collect.UITestCase;
import org.eclipse.riena.core.wire.Wire;
import org.eclipse.riena.navigation.IModuleGroupNode;
import org.eclipse.riena.navigation.IModuleNode;
import org.eclipse.riena.navigation.INavigationNodeController;
import org.eclipse.riena.navigation.model.ModuleGroupNode;
import org.eclipse.riena.navigation.model.ModuleNode;
import org.eclipse.riena.navigation.ui.controllers.ModuleController;
import org.eclipse.riena.navigation.ui.controllers.ModuleGroupController;
import org.eclipse.riena.navigation.ui.swt.views.ModuleGroupView;
import org.eclipse.riena.navigation.ui.swt.views.ModuleView;
import org.eclipse.riena.navigation.ui.swt.views.NavigationViewFactory;
import org.eclipse.riena.navigation.ui.swt.views.SWTModuleController;
import org.eclipse.riena.navigation.ui.swt.views.TestModuleController;
import org.eclipse.riena.navigation.ui.swt.views.TestModuleGroupController;
import org.eclipse.riena.navigation.ui.swt.views.TestModuleGroupView;
import org.eclipse.riena.navigation.ui.swt.views.TestModuleView;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

@UITestCase
public class NavigationViewFactoryTest
extends RienaTestCase {
    public void testNormalWithoutInjectionBehaviour() {
        NavigationViewFactory viewFactory = new NavigationViewFactory();
        ModuleView moduleView = viewFactory.createModuleView((Composite)new Shell());
        NavigationViewFactoryTest.assertNotNull((Object)moduleView);
        NavigationViewFactoryTest.assertTrue((moduleView.getClass() == ModuleView.class ? 1 : 0) != 0);
        ModuleGroupView moduleGroupView = viewFactory.createModuleGroupView((Composite)new Shell());
        NavigationViewFactoryTest.assertNotNull((Object)moduleGroupView);
        NavigationViewFactoryTest.assertTrue((moduleGroupView.getClass() == ModuleGroupView.class ? 1 : 0) != 0);
    }

    public void testNormalWithInjectionBehaviour() {
        NavigationViewFactory viewFactory = new NavigationViewFactory();
        Wire.instance((Object)viewFactory).andStart(this.getContext());
        ModuleView moduleView = viewFactory.createModuleView((Composite)new Shell());
        NavigationViewFactoryTest.assertNotNull((Object)moduleView);
        NavigationViewFactoryTest.assertTrue((moduleView.getClass() == ModuleView.class ? 1 : 0) != 0);
        ModuleGroupView moduleGroupView = viewFactory.createModuleGroupView((Composite)new Shell());
        NavigationViewFactoryTest.assertNotNull((Object)moduleGroupView);
        NavigationViewFactoryTest.assertTrue((moduleGroupView.getClass() == ModuleGroupView.class ? 1 : 0) != 0);
    }

    public void testConfiguredNavigationViewFactory() {
        NavigationViewFactory viewFactory = new NavigationViewFactory();
        this.addPluginXml(((Object)((Object)this)).getClass(), "pluginXmlNavigationViewFactory.xml");
        try {
            Wire.instance((Object)viewFactory).andStart(this.getContext());
            ModuleView moduleView = viewFactory.createModuleView((Composite)new Shell());
            NavigationViewFactoryTest.assertNotNull((Object)moduleView);
            NavigationViewFactoryTest.assertTrue((moduleView.getClass() == TestModuleView.class ? 1 : 0) != 0);
            ModuleController moduleController = viewFactory.createModuleController((IModuleNode)new ModuleNode());
            NavigationViewFactoryTest.assertNotNull((Object)moduleController);
            NavigationViewFactoryTest.assertTrue((moduleController.getClass() == SWTModuleController.class ? 1 : 0) != 0);
            ModuleGroupView moduleGroupView = viewFactory.createModuleGroupView((Composite)new Shell());
            NavigationViewFactoryTest.assertNotNull((Object)moduleGroupView);
            NavigationViewFactoryTest.assertTrue((moduleGroupView.getClass() == TestModuleGroupView.class ? 1 : 0) != 0);
            ModuleGroupController moduleGroupController = viewFactory.createModuleGroupController((IModuleGroupNode)new ModuleGroupNode());
            NavigationViewFactoryTest.assertNotNull((Object)moduleGroupController);
            NavigationViewFactoryTest.assertTrue((moduleGroupController.getClass() == ModuleGroupController.class ? 1 : 0) != 0);
        }
        finally {
            this.removeExtension("org.eclipse.riena.test.navigationModuleView");
            this.removeExtension("org.eclipse.riena.test.navigationModuleGroupView");
        }
    }

    public void testConfiguredNavigationViewFactorySecond() {
        NavigationViewFactory viewFactory = new NavigationViewFactory();
        this.addPluginXml(((Object)((Object)this)).getClass(), "pluginXmlNavigationViewFactoryWithController.xml");
        try {
            Wire.instance((Object)viewFactory).andStart(this.getContext());
            ModuleView moduleView = viewFactory.createModuleView((Composite)new Shell());
            NavigationViewFactoryTest.assertNotNull((Object)moduleView);
            NavigationViewFactoryTest.assertTrue((moduleView.getClass() == TestModuleView.class ? 1 : 0) != 0);
            ModuleController moduleController = viewFactory.createModuleController((IModuleNode)new ModuleNode());
            NavigationViewFactoryTest.assertNotNull((Object)moduleController);
            NavigationViewFactoryTest.assertTrue((moduleController.getClass() == TestModuleController.class ? 1 : 0) != 0);
            ModuleGroupView moduleGroupView = viewFactory.createModuleGroupView((Composite)new Shell());
            NavigationViewFactoryTest.assertNotNull((Object)moduleGroupView);
            NavigationViewFactoryTest.assertTrue((moduleGroupView.getClass() == TestModuleGroupView.class ? 1 : 0) != 0);
            ModuleGroupController moduleGroupController = viewFactory.createModuleGroupController((IModuleGroupNode)new ModuleGroupNode());
            NavigationViewFactoryTest.assertNotNull((Object)moduleGroupController);
            NavigationViewFactoryTest.assertTrue((moduleGroupController.getClass() == TestModuleGroupController.class ? 1 : 0) != 0);
        }
        finally {
            this.removeExtension("org.eclipse.riena.test.navigationModuleView");
            this.removeExtension("org.eclipse.riena.test.navigationModuleGroupView");
        }
    }

    public void testCreateModuleController() {
        NavigationViewFactory viewFactory = new NavigationViewFactory();
        ModuleNode moduleNode0 = new ModuleNode();
        ModuleController moduleController = viewFactory.createModuleController((IModuleNode)moduleNode0);
        NavigationViewFactoryTest.assertNotNull((Object)moduleController);
        NavigationViewFactoryTest.assertTrue((moduleController.getClass() == SWTModuleController.class ? 1 : 0) != 0);
        NavigationViewFactoryTest.assertSame((Object)moduleController.getNavigationNode(), (Object)moduleNode0);
        ModuleNode moduleNode1 = new ModuleNode();
        MyModuleController myController = new MyModuleController((IModuleNode)moduleNode1);
        moduleNode1.setNavigationNodeController((INavigationNodeController)myController);
        moduleController = viewFactory.createModuleController((IModuleNode)moduleNode1);
        NavigationViewFactoryTest.assertNotNull((Object)moduleController);
        NavigationViewFactoryTest.assertSame((Object)((Object)myController), (Object)moduleController);
        NavigationViewFactoryTest.assertSame((Object)moduleController.getNavigationNode(), (Object)moduleNode1);
        this.addPluginXml(((Object)((Object)this)).getClass(), "pluginXmlNavigationViewFactoryWithController.xml");
        try {
            Wire.instance((Object)viewFactory).andStart(this.getContext());
            ModuleNode moduleNode2 = new ModuleNode();
            moduleController = viewFactory.createModuleController((IModuleNode)moduleNode2);
            NavigationViewFactoryTest.assertNotNull((Object)moduleController);
            NavigationViewFactoryTest.assertTrue((moduleController.getClass() == TestModuleController.class ? 1 : 0) != 0);
            NavigationViewFactoryTest.assertSame((Object)moduleController.getNavigationNode(), (Object)moduleNode2);
        }
        finally {
            this.removeExtension("org.eclipse.riena.test.navigationModuleView");
            this.removeExtension("org.eclipse.riena.test.navigationModuleGroupView");
        }
    }

    public void testCreateModuleGroupController() {
        NavigationViewFactory viewFactory = new NavigationViewFactory();
        ModuleGroupNode moduleGroupNode0 = new ModuleGroupNode();
        ModuleGroupController moduleGroupController = viewFactory.createModuleGroupController((IModuleGroupNode)moduleGroupNode0);
        NavigationViewFactoryTest.assertNotNull((Object)moduleGroupController);
        NavigationViewFactoryTest.assertTrue((moduleGroupController.getClass() == ModuleGroupController.class ? 1 : 0) != 0);
        NavigationViewFactoryTest.assertSame((Object)moduleGroupController.getNavigationNode(), (Object)moduleGroupNode0);
        ModuleGroupNode moduleGroupNode1 = new ModuleGroupNode();
        MyModuleGroupController myController = new MyModuleGroupController((IModuleGroupNode)moduleGroupNode1);
        moduleGroupNode1.setNavigationNodeController((INavigationNodeController)myController);
        moduleGroupController = viewFactory.createModuleGroupController((IModuleGroupNode)moduleGroupNode1);
        NavigationViewFactoryTest.assertNotNull((Object)moduleGroupController);
        NavigationViewFactoryTest.assertSame((Object)((Object)myController), (Object)moduleGroupController);
        NavigationViewFactoryTest.assertSame((Object)moduleGroupController.getNavigationNode(), (Object)moduleGroupNode1);
        this.addPluginXml(((Object)((Object)this)).getClass(), "pluginXmlNavigationViewFactoryWithController.xml");
        try {
            Wire.instance((Object)viewFactory).andStart(this.getContext());
            ModuleGroupNode moduleGroupNode2 = new ModuleGroupNode();
            moduleGroupController = viewFactory.createModuleGroupController((IModuleGroupNode)moduleGroupNode2);
            NavigationViewFactoryTest.assertNotNull((Object)moduleGroupController);
            NavigationViewFactoryTest.assertTrue((moduleGroupController.getClass() == TestModuleGroupController.class ? 1 : 0) != 0);
            NavigationViewFactoryTest.assertSame((Object)moduleGroupController.getNavigationNode(), (Object)moduleGroupNode2);
        }
        finally {
            this.removeExtension("org.eclipse.riena.test.navigationModuleView");
            this.removeExtension("org.eclipse.riena.test.navigationModuleGroupView");
        }
    }

    private class MyModuleController
    extends ModuleController {
        public MyModuleController(IModuleNode navigationNode) {
            super(navigationNode);
        }
    }

    private class MyModuleGroupController
    extends ModuleGroupController {
        public MyModuleGroupController(IModuleGroupNode navigationNode) {
            super(navigationNode);
        }
    }
}

