/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.views;

import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import junit.framework.TestCase;
import org.eclipse.riena.core.test.collect.UITestCase;
import org.eclipse.riena.core.util.IConfigurationExtension;
import org.eclipse.riena.core.util.InvocationTargetFailure;
import org.eclipse.riena.core.util.Nop;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.core.util.RienaConfiguration;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.INavigationNodeController;
import org.eclipse.riena.navigation.INavigationProcessor;
import org.eclipse.riena.navigation.ISubApplicationNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.NavigationNodeId;
import org.eclipse.riena.navigation.model.ModuleGroupNode;
import org.eclipse.riena.navigation.model.ModuleNode;
import org.eclipse.riena.navigation.model.NavigationProcessor;
import org.eclipse.riena.navigation.model.SubApplicationNode;
import org.eclipse.riena.navigation.model.SubModuleNode;
import org.eclipse.riena.navigation.ui.controllers.SubApplicationController;
import org.eclipse.riena.navigation.ui.swt.presentation.SwtViewId;
import org.eclipse.riena.navigation.ui.swt.views.SubApplicationView;
import org.eclipse.riena.ui.swt.utils.SWTBindingPropertyLocator;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IPageLayout;

@UITestCase
public class SubApplicationViewTest
extends TestCase {
    private Shell shell;
    private TestSubApplicationView view;
    private SubApplicationNode node;

    protected void setUp() throws Exception {
        this.view = new TestSubApplicationView();
        this.shell = new Shell();
        SWTBindingPropertyLocator locator = SWTBindingPropertyLocator.getInstance();
        locator.setBindingProperty((Object)this.shell, "applicationWindow");
        this.node = new SubApplicationNode();
        this.node.setNavigationProcessor((INavigationProcessor)new NavigationProcessor());
        this.view.bind(this.node);
    }

    protected void tearDown() throws Exception {
        this.view = null;
        SwtUtilities.dispose((Widget)this.shell);
    }

    public void testUnbind() throws Exception {
        List listeners = (List)ReflectionUtils.getHidden((Object)this.node, (String)"listeners");
        SubApplicationViewTest.assertEquals((int)1, (int)listeners.size());
        this.node.dispose();
        SubApplicationViewTest.assertTrue((boolean)listeners.isEmpty());
    }

    public void testDisposeHandling() throws Exception {
        this.node.setNavigationNodeController((INavigationNodeController)new SubApplicationController((ISubApplicationNode)this.node));
        ModuleGroupNode mg = new ModuleGroupNode();
        this.node.addChild((INavigationNode)mg);
        ModuleNode m = new ModuleNode();
        mg.addChild((INavigationNode)m);
        this.view.createInitialLayout(null);
        SubModuleNode sm1 = new SubModuleNode(new NavigationNodeId("x"));
        m.addChild((INavigationNode)sm1);
        SubModuleNode sm2 = new SubModuleNode(new NavigationNodeId("y"));
        m.addChild((INavigationNode)sm2);
        SubModuleNode sm3 = new SubModuleNode(new NavigationNodeId("z"));
        m.addChild((INavigationNode)sm3);
        this.view.viewUserCount = 1;
        this.view.providedId = new SwtViewId("test:test");
        this.view.hiddenId = null;
        sm1.dispose();
        SubApplicationViewTest.assertSame((Object)this.view.providedId, (Object)this.view.hiddenId);
        this.view.viewUserCount = 0;
        this.view.providedId = new SwtViewId("test:SHARED");
        this.view.hiddenId = null;
        sm2.dispose();
        SubApplicationViewTest.assertSame((Object)this.view.providedId, (Object)this.view.hiddenId);
        this.view.viewUserCount = 1;
        this.view.providedId = new SwtViewId("test:SHARED");
        this.view.hiddenId = null;
        sm2.dispose();
        SubApplicationViewTest.assertSame(null, (Object)this.view.hiddenId);
    }

    public void testAddToStock() throws Exception {
        LinkedList stock = (LinkedList)ReflectionUtils.getHidden((Object)((Object)this.view), (String)"subModuleViewStock");
        SubApplicationViewTest.assertNotNull((Object)stock);
        SubApplicationViewTest.assertTrue((boolean)stock.isEmpty());
        SwtViewId id1 = new SwtViewId("sub1", "0001");
        ReflectionUtils.invokeHidden((Object)((Object)this.view), (String)"addToStock", (Object[])new Object[]{id1});
        SubApplicationViewTest.assertEquals((int)1, (int)stock.size());
        SwtViewId id2 = new SwtViewId("sub2", "0001");
        ReflectionUtils.invokeHidden((Object)((Object)this.view), (String)"addToStock", (Object[])new Object[]{id2});
        SubApplicationViewTest.assertEquals((int)2, (int)stock.size());
        SubApplicationViewTest.assertSame((Object)id1, stock.getLast());
        SubApplicationViewTest.assertSame((Object)id2, stock.getFirst());
        SwtViewId id12 = new SwtViewId("sub1", "0002");
        ReflectionUtils.invokeHidden((Object)((Object)this.view), (String)"addToStock", (Object[])new Object[]{id12});
        SubApplicationViewTest.assertEquals((int)3, (int)stock.size());
        SubApplicationViewTest.assertSame((Object)id1, stock.getLast());
        SubApplicationViewTest.assertSame((Object)id12, stock.getFirst());
        ReflectionUtils.invokeHidden((Object)((Object)this.view), (String)"addToStock", (Object[])new Object[]{id1});
        SubApplicationViewTest.assertEquals((int)3, (int)stock.size());
        SubApplicationViewTest.assertSame((Object)id2, stock.getLast());
        SubApplicationViewTest.assertSame((Object)id1, stock.getFirst());
        SwtViewId id21 = new SwtViewId("sub2", "0001");
        ReflectionUtils.invokeHidden((Object)((Object)this.view), (String)"addToStock", (Object[])new Object[]{id21});
        SubApplicationViewTest.assertEquals((int)3, (int)stock.size());
        SubApplicationViewTest.assertEquals((Object)id12, stock.getLast());
        SubApplicationViewTest.assertSame((Object)id21, stock.getFirst());
    }

    public void testGetFirstOfStock() throws Exception {
        SwtViewId retId;
        LinkedList stock = (LinkedList)ReflectionUtils.getHidden((Object)((Object)this.view), (String)"subModuleViewStock");
        SubApplicationViewTest.assertNotNull((Object)stock);
        SubApplicationViewTest.assertTrue((boolean)stock.isEmpty());
        try {
            retId = (SwtViewId)ReflectionUtils.invokeHidden((Object)((Object)this.view), (String)"getFirstOfStock", (Object[])new Object[0]);
            SubApplicationViewTest.fail((String)"Excpected exception wasn't thrown!");
        }
        catch (InvocationTargetFailure e) {
            if (e.getCause() instanceof NoSuchElementException) {
                Nop.reason((String)"Excpected exception");
            }
            throw e;
        }
        SwtViewId id1 = new SwtViewId("sub1", "0001");
        ReflectionUtils.invokeHidden((Object)((Object)this.view), (String)"addToStock", (Object[])new Object[]{id1});
        retId = (SwtViewId)ReflectionUtils.invokeHidden((Object)((Object)this.view), (String)"getFirstOfStock", (Object[])new Object[0]);
        SubApplicationViewTest.assertEquals((Object)id1, (Object)retId);
        SwtViewId id2 = new SwtViewId("sub2", "0002");
        ReflectionUtils.invokeHidden((Object)((Object)this.view), (String)"addToStock", (Object[])new Object[]{id2});
        retId = (SwtViewId)ReflectionUtils.invokeHidden((Object)((Object)this.view), (String)"getFirstOfStock", (Object[])new Object[0]);
        SubApplicationViewTest.assertEquals((Object)id2, (Object)retId);
    }

    public void testGetMaxStockedViews() throws Exception {
        int ret = (Integer)ReflectionUtils.invokeHidden((Object)((Object)this.view), (String)"getMaxStockedViews", (Object[])new Object[0]);
        SubApplicationViewTest.assertEquals((int)0, (int)ret);
        IConfigurationExtension extension = new IConfigurationExtension(){

            public String getKey() {
                return "riena.maxStockedViews";
            }

            public String getValue() {
                return "4711";
            }
        };
        IConfigurationExtension[] extensions = new IConfigurationExtension[]{extension};
        RienaConfiguration.getInstance().update(extensions);
        ret = (Integer)ReflectionUtils.invokeHidden((Object)((Object)this.view), (String)"getMaxStockedViews", (Object[])new Object[0]);
        SubApplicationViewTest.assertEquals((int)4711, (int)ret);
        RienaConfiguration.getInstance().update(null);
    }

    public void testRemoveFromStock() throws Exception {
        LinkedList stock = (LinkedList)ReflectionUtils.getHidden((Object)((Object)this.view), (String)"subModuleViewStock");
        SubApplicationViewTest.assertNotNull((Object)stock);
        SubApplicationViewTest.assertTrue((boolean)stock.isEmpty());
        SwtViewId id1 = new SwtViewId("sub1", "0001");
        ReflectionUtils.invokeHidden((Object)((Object)this.view), (String)"addToStock", (Object[])new Object[]{id1});
        SwtViewId id2 = new SwtViewId("sub2", "0002");
        ReflectionUtils.invokeHidden((Object)((Object)this.view), (String)"addToStock", (Object[])new Object[]{id2});
        SubApplicationViewTest.assertEquals((int)2, (int)stock.size());
        SubApplicationViewTest.assertSame((Object)id1, stock.getLast());
        SubApplicationViewTest.assertSame((Object)id2, stock.getFirst());
        boolean ret = (Boolean)ReflectionUtils.invokeHidden((Object)((Object)this.view), (String)"removeFromStock", (Object[])new Object[]{id2});
        SubApplicationViewTest.assertTrue((boolean)ret);
        SubApplicationViewTest.assertEquals((int)1, (int)stock.size());
        SubApplicationViewTest.assertSame((Object)id1, stock.getLast());
        SubApplicationViewTest.assertSame((Object)id1, stock.getFirst());
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)((Object)this.view), (String)"removeFromStock", (Object[])new Object[]{id2});
        SubApplicationViewTest.assertFalse((boolean)ret);
        SubApplicationViewTest.assertEquals((int)1, (int)stock.size());
        SubApplicationViewTest.assertSame((Object)id1, stock.getLast());
        SubApplicationViewTest.assertSame((Object)id1, stock.getFirst());
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)((Object)this.view), (String)"removeFromStock", (Object[])new Object[]{id1});
        SubApplicationViewTest.assertTrue((boolean)ret);
        SubApplicationViewTest.assertEquals((int)0, (int)stock.size());
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)((Object)this.view), (String)"removeFromStock", (Object[])new Object[]{id1});
        SubApplicationViewTest.assertFalse((boolean)ret);
    }

    public void testGetLastOfStock() throws Exception {
        SwtViewId retId = (SwtViewId)ReflectionUtils.invokeHidden((Object)((Object)this.view), (String)"getLastOfStock", (Object[])new Object[0]);
        SubApplicationViewTest.assertNull((Object)retId);
        IConfigurationExtension extension = new IConfigurationExtension(){

            public String getKey() {
                return "riena.maxStockedViews";
            }

            public String getValue() {
                return "3";
            }
        };
        IConfigurationExtension[] extensions = new IConfigurationExtension[]{extension};
        RienaConfiguration.getInstance().update(extensions);
        SwtViewId id1 = new SwtViewId("sub1", "0001");
        ReflectionUtils.invokeHidden((Object)((Object)this.view), (String)"addToStock", (Object[])new Object[]{id1});
        retId = (SwtViewId)ReflectionUtils.invokeHidden((Object)((Object)this.view), (String)"getLastOfStock", (Object[])new Object[0]);
        SubApplicationViewTest.assertNull((Object)retId);
        SwtViewId id2 = new SwtViewId("sub2", "0002");
        ReflectionUtils.invokeHidden((Object)((Object)this.view), (String)"addToStock", (Object[])new Object[]{id2});
        retId = (SwtViewId)ReflectionUtils.invokeHidden((Object)((Object)this.view), (String)"getLastOfStock", (Object[])new Object[0]);
        SubApplicationViewTest.assertNull((Object)retId);
        SwtViewId id3 = new SwtViewId("sub3", "0003");
        ReflectionUtils.invokeHidden((Object)((Object)this.view), (String)"addToStock", (Object[])new Object[]{id3});
        retId = (SwtViewId)ReflectionUtils.invokeHidden((Object)((Object)this.view), (String)"getLastOfStock", (Object[])new Object[0]);
        SubApplicationViewTest.assertNull((Object)retId);
        SwtViewId id4 = new SwtViewId("sub4", "0004");
        ReflectionUtils.invokeHidden((Object)((Object)this.view), (String)"addToStock", (Object[])new Object[]{id4});
        retId = (SwtViewId)ReflectionUtils.invokeHidden((Object)((Object)this.view), (String)"getLastOfStock", (Object[])new Object[0]);
        SubApplicationViewTest.assertEquals((Object)id1, (Object)retId);
        SwtViewId id5 = new SwtViewId("sub5", "0005");
        ReflectionUtils.invokeHidden((Object)((Object)this.view), (String)"addToStock", (Object[])new Object[]{id5});
        retId = (SwtViewId)ReflectionUtils.invokeHidden((Object)((Object)this.view), (String)"getLastOfStock", (Object[])new Object[0]);
        SubApplicationViewTest.assertEquals((Object)id1, (Object)retId);
        ReflectionUtils.invokeHidden((Object)((Object)this.view), (String)"addToStock", (Object[])new Object[]{id1});
        retId = (SwtViewId)ReflectionUtils.invokeHidden((Object)((Object)this.view), (String)"getLastOfStock", (Object[])new Object[0]);
        SubApplicationViewTest.assertEquals((Object)id2, (Object)retId);
        ReflectionUtils.invokeHidden((Object)((Object)this.view), (String)"removeFromStock", (Object[])new Object[]{id2});
        retId = (SwtViewId)ReflectionUtils.invokeHidden((Object)((Object)this.view), (String)"getLastOfStock", (Object[])new Object[0]);
        SubApplicationViewTest.assertEquals((Object)id3, (Object)retId);
        ReflectionUtils.invokeHidden((Object)((Object)this.view), (String)"removeFromStock", (Object[])new Object[]{id1});
        retId = (SwtViewId)ReflectionUtils.invokeHidden((Object)((Object)this.view), (String)"getLastOfStock", (Object[])new Object[0]);
        SubApplicationViewTest.assertNull((Object)retId);
        RienaConfiguration.getInstance().update(null);
    }

    private class TestSubApplicationView
    extends SubApplicationView {
        private int viewUserCount = 0;
        private SwtViewId hiddenId = null;
        private SwtViewId providedId = null;

        private TestSubApplicationView() {
        }

        public SubApplicationNode getNavigationNode() {
            return SubApplicationViewTest.this.node;
        }

        protected int getViewUserCount(SwtViewId id) {
            return this.viewUserCount;
        }

        protected boolean hideView(SwtViewId id) {
            this.hiddenId = id;
            return true;
        }

        protected void doBaseLayout(IPageLayout layout) {
        }

        protected ISubApplicationNode locateSubApplication(IPageLayout layout) {
            return SubApplicationViewTest.this.node;
        }

        protected SwtViewId getViewId(ISubModuleNode node) {
            return this.providedId;
        }
    }
}

