/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.objecttransaction.simple;

import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.riena.core.test.RienaTestCase;
import org.eclipse.riena.core.test.collect.NonUITestCase;
import org.eclipse.riena.objecttransaction.IObjectTransaction;
import org.eclipse.riena.objecttransaction.IObjectTransactionExtract;
import org.eclipse.riena.objecttransaction.ITransactedObject;
import org.eclipse.riena.objecttransaction.InvalidTransactionFailure;
import org.eclipse.riena.objecttransaction.ObjectTransactionFactory;
import org.eclipse.riena.objecttransaction.delta.TransactionDelta;
import org.eclipse.riena.objecttransaction.simple.value.Addresse;
import org.eclipse.riena.objecttransaction.simple.value.Kunde;
import org.eclipse.riena.objecttransaction.simple.value.Vertrag;
import org.eclipse.riena.objecttransaction.state.State;

@NonUITestCase
public class ObjectTransactionVariousSimpleTest
extends RienaTestCase {
    public void setUp() throws Exception {
        super.setUp();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        loader.setDefaultAssertionStatus(true);
    }

    public void testNullValueAndCommitToObjects() throws Exception {
        IObjectTransaction objectTransaction = ObjectTransactionFactory.getInstance().createObjectTransaction();
        objectTransaction.setCleanModus(true);
        Kunde kunde = new Kunde("4711");
        objectTransaction.setCleanModus(false);
        kunde.setVorname("john");
        kunde.setNachname("Miller");
        ObjectTransactionVariousSimpleTest.assertEquals((String)"john", (String)kunde.getVorname());
        ObjectTransactionVariousSimpleTest.assertEquals((String)"john", (String)kunde.getVorname());
        kunde.setVorname(null);
        ObjectTransactionVariousSimpleTest.assertNull((Object)kunde.getVorname());
        objectTransaction.commitToObjects();
        ObjectTransactionVariousSimpleTest.assertNull((Object)kunde.getVorname());
    }

    public void testRegisterAsDeletedWithCommitToObjects() throws Exception {
        IObjectTransaction objectTransaction = ObjectTransactionFactory.getInstance().createObjectTransaction();
        objectTransaction.setCleanModus(true);
        Kunde kunde = new Kunde("4711");
        kunde.setVorname("john");
        kunde.setNachname("Miller");
        objectTransaction.setCleanModus(false);
        objectTransaction.registerAsDeleted((ITransactedObject)kunde);
        objectTransaction.commitToObjects();
        ObjectTransactionVariousSimpleTest.assertFalse((String)"kunde must not be registered", (boolean)objectTransaction.isRegistered((ITransactedObject)kunde));
    }

    public void testExtractIsImmutable() throws Exception {
        IObjectTransaction objectTransaction = ObjectTransactionFactory.getInstance().createObjectTransaction();
        objectTransaction.setCleanModus(true);
        Kunde kunde = new Kunde("4711");
        objectTransaction.setCleanModus(false);
        kunde.setVorname("john");
        kunde.setNachname("Miller");
        IObjectTransactionExtract extract = objectTransaction.exportExtract();
        TransactionDelta[] deltas = extract.getDeltas();
        ObjectTransactionVariousSimpleTest.assertTrue((String)"must only be changes for one object ", (deltas.length == 1 ? 1 : 0) != 0);
        ObjectTransactionVariousSimpleTest.assertTrue((String)"must have only 2 changes ", (deltas[0].getChanges().size() == 2 ? 1 : 0) != 0);
        kunde.setAddresse(new Addresse(true));
        ObjectTransactionVariousSimpleTest.assertTrue((String)"extract changed:: must only be changes for one object ", (deltas.length == 1 ? 1 : 0) != 0);
        ObjectTransactionVariousSimpleTest.assertTrue((String)"extract changed:: must have only 2 changes ", (deltas[0].getChanges().size() == 2 ? 1 : 0) != 0);
    }

    public void testExportModified1() throws Exception {
        IObjectTransaction objectTransaction = ObjectTransactionFactory.getInstance().createObjectTransaction();
        objectTransaction.setCleanModus(true);
        Kunde kunde = new Kunde("4711");
        kunde.setVorname("john");
        kunde.setNachname("Miller");
        Addresse adresse = new Addresse(false);
        kunde.setAddresse(adresse);
        objectTransaction.setCleanModus(false);
        adresse.setOrt("frankfurt");
        adresse.setStrasse("gutleutstrasse");
        IObjectTransactionExtract extract = objectTransaction.exportOnlyModifedObjectsToExtract();
        TransactionDelta[] deltas = extract.getDeltas();
        ObjectTransactionVariousSimpleTest.assertTrue((String)"should be only one transaction delta", (deltas.length == 1 ? 1 : 0) != 0);
        ObjectTransactionVariousSimpleTest.assertTrue((String)"single delta should reference adresse", (deltas[0].getObjectId() == adresse.getObjectId() ? 1 : 0) != 0);
        ObjectTransactionVariousSimpleTest.assertTrue((String)"delta status must be modified", (deltas[0].getState() == State.MODIFIED ? 1 : 0) != 0);
    }

    public void testExportModified2() throws Exception {
        IObjectTransaction objectTransaction = ObjectTransactionFactory.getInstance().createObjectTransaction();
        objectTransaction.setCleanModus(true);
        Kunde kunde = new Kunde("4711");
        kunde.setVorname("john");
        kunde.setNachname("Miller");
        Addresse adresse = new Addresse(false);
        objectTransaction.setCleanModus(false);
        kunde.setAddresse(adresse);
        adresse.setOrt("frankfurt");
        adresse.setStrasse("gutleutstrasse");
        IObjectTransactionExtract extract = objectTransaction.exportOnlyModifedObjectsToExtract();
        TransactionDelta[] deltas = extract.getDeltas();
        ObjectTransactionVariousSimpleTest.assertTrue((String)"should be only two transaction delta", (deltas.length == 2 ? 1 : 0) != 0);
        ObjectTransactionVariousSimpleTest.assertTrue((String)"single delta should reference adresse", (deltas[0].getObjectId() == adresse.getObjectId() || deltas[1].getObjectId() == adresse.getObjectId() ? 1 : 0) != 0);
        ObjectTransactionVariousSimpleTest.assertTrue((String)"delta status must both be modified", (deltas[0].getState().equals((Object)State.MODIFIED) && deltas[1].getState().equals((Object)State.MODIFIED) ? 1 : 0) != 0);
        ObjectTransactionVariousSimpleTest.assertTrue((String)"single delta should reference kunde", (deltas[0].getObjectId() == kunde.getObjectId() || deltas[1].getObjectId() == kunde.getObjectId() ? 1 : 0) != 0);
        ObjectTransactionVariousSimpleTest.assertTrue((String)"deltas should reference different objects", (deltas[0].getObjectId() != deltas[1].getObjectId() ? 1 : 0) != 0);
    }

    public void testExportModified3() throws Exception {
        IObjectTransaction objectTransaction = ObjectTransactionFactory.getInstance().createObjectTransaction();
        objectTransaction.setCleanModus(true);
        Kunde kunde = new Kunde("4711");
        kunde.setVorname("john");
        kunde.setNachname("Miller");
        Addresse adresse = new Addresse(false);
        adresse.setOrt("frankfurt");
        adresse.setStrasse("gutleutstrasse");
        objectTransaction.setCleanModus(false);
        kunde.setAddresse(adresse);
        IObjectTransactionExtract extract = objectTransaction.exportOnlyModifedObjectsToExtract();
        TransactionDelta[] deltas = extract.getDeltas();
        ObjectTransactionVariousSimpleTest.assertTrue((String)"should be only two transaction delta", (deltas.length == 2 ? 1 : 0) != 0);
        ObjectTransactionVariousSimpleTest.assertTrue((String)"single delta should reference kunde", (deltas[0].getObjectId() == kunde.getObjectId() ? 1 : 0) != 0);
        ObjectTransactionVariousSimpleTest.assertTrue((String)"delta status of Kunde must be modified", (boolean)deltas[0].getState().equals((Object)State.MODIFIED));
        ObjectTransactionVariousSimpleTest.assertTrue((String)"single delta should reference adresse", (deltas[1].getObjectId() == adresse.getObjectId() ? 1 : 0) != 0);
        ObjectTransactionVariousSimpleTest.assertTrue((String)"delta status of Adresse must be clean", (boolean)deltas[1].getState().equals((Object)State.CLEAN));
    }

    public void testExportModified4() throws Exception {
        IObjectTransaction objectTransaction = ObjectTransactionFactory.getInstance().createObjectTransaction();
        objectTransaction.setCleanModus(true);
        Kunde kunde = new Kunde("4711");
        Addresse adresse = new Addresse(false);
        kunde.setAddresse(adresse);
        adresse.setOrt("frankfurt");
        adresse.setStrasse("gutleutstrasse");
        objectTransaction.setCleanModus(false);
        kunde.setVorname("john");
        kunde.setNachname("Miller");
        IObjectTransactionExtract extract = objectTransaction.exportOnlyModifedObjectsToExtract();
        TransactionDelta[] deltas = extract.getDeltas();
        ObjectTransactionVariousSimpleTest.assertTrue((String)"should be only one transaction delta", (deltas.length == 1 ? 1 : 0) != 0);
        ObjectTransactionVariousSimpleTest.assertTrue((String)"single delta should reference kunde", (deltas[0].getObjectId() == kunde.getObjectId() ? 1 : 0) != 0);
        ObjectTransactionVariousSimpleTest.assertTrue((String)"delta status must be modified", (boolean)deltas[0].getState().equals((Object)State.MODIFIED));
    }

    public void testExportModified5() throws Exception {
        IObjectTransaction objectTransaction = ObjectTransactionFactory.getInstance().createObjectTransaction();
        objectTransaction.setCleanModus(true);
        Kunde kunde = new Kunde("4711");
        kunde.setVorname("john");
        kunde.setNachname("Miller");
        Vertrag v1 = new Vertrag("123");
        v1.setVertragsBeschreibung("vertrag nummer 123");
        kunde.addVertrag(v1);
        objectTransaction.setCleanModus(false);
        Vertrag v2 = new Vertrag("456");
        v2.setVertragsBeschreibung("vertrag nummer 456");
        kunde.addVertrag(v2);
        IObjectTransactionExtract extract = objectTransaction.exportOnlyModifedObjectsToExtract();
        TransactionDelta[] deltas = extract.getDeltas();
        ObjectTransactionVariousSimpleTest.assertEquals((String)"should be only two transaction delta", (int)2, (int)deltas.length);
        if (deltas[0].getObjectId() == v2.getObjectId()) {
            ObjectTransactionVariousSimpleTest.assertSame((String)"single delta should reference v2", (Object)deltas[0].getObjectId(), (Object)v2.getObjectId());
            ObjectTransactionVariousSimpleTest.assertEquals((String)"delta status must be created", (Object)State.CREATED, (Object)deltas[0].getState());
            ObjectTransactionVariousSimpleTest.assertSame((String)"single delta should reference kunde", (Object)deltas[1].getObjectId(), (Object)kunde.getObjectId());
            ObjectTransactionVariousSimpleTest.assertEquals((String)"delta status must be modified", (Object)State.MODIFIED, (Object)deltas[1].getState());
        } else if (deltas[0].getObjectId() == kunde.getObjectId()) {
            ObjectTransactionVariousSimpleTest.assertSame((String)"single delta should reference v2", (Object)deltas[1].getObjectId(), (Object)v2.getObjectId());
            ObjectTransactionVariousSimpleTest.assertEquals((String)"delta status must be created", (Object)State.CREATED, (Object)deltas[1].getState());
            ObjectTransactionVariousSimpleTest.assertSame((String)"single delta should reference kunde", (Object)deltas[0].getObjectId(), (Object)kunde.getObjectId());
            ObjectTransactionVariousSimpleTest.assertEquals((String)"delta status must be modified", (Object)State.MODIFIED, (Object)deltas[0].getState());
        } else {
            ObjectTransactionVariousSimpleTest.fail((String)"delta must be v2 vertrag or kunde delta");
        }
    }

    public void testExportModified6() throws Exception {
        IObjectTransaction objectTransaction = ObjectTransactionFactory.getInstance().createObjectTransaction();
        objectTransaction.setCleanModus(true);
        Kunde kunde = new Kunde("4711");
        kunde.setVorname("john");
        kunde.setNachname("Miller");
        objectTransaction.setCleanModus(false);
        Vertrag v1 = new Vertrag("123");
        v1.setVertragsBeschreibung("vertrag nummer 123");
        kunde.addVertrag(v1);
        Vertrag v2 = new Vertrag("456");
        v2.setVertragsBeschreibung("vertrag nummer 456");
        kunde.addVertrag(v2);
        IObjectTransactionExtract extract = objectTransaction.exportOnlyModifedObjectsToExtract();
        TransactionDelta[] deltas = extract.getDeltas();
        ObjectTransactionVariousSimpleTest.assertEquals((String)"should be only three transaction delta", (int)3, (int)deltas.length);
        TransactionDelta[] transactionDeltaArray = deltas;
        int n = deltas.length;
        int n2 = 0;
        while (n2 < n) {
            TransactionDelta delta = transactionDeltaArray[n2];
            if (delta.getObjectId() == v2.getObjectId()) {
                ObjectTransactionVariousSimpleTest.assertEquals((String)"delta status must be created", (Object)State.CREATED, (Object)delta.getState());
            } else if (delta.getObjectId() == v1.getObjectId()) {
                ObjectTransactionVariousSimpleTest.assertEquals((String)"delta status must be created", (Object)State.CREATED, (Object)delta.getState());
            } else if (delta.getObjectId() == kunde.getObjectId()) {
                ObjectTransactionVariousSimpleTest.assertEquals((String)"delta status must be modified", (Object)State.MODIFIED, (Object)delta.getState());
            } else {
                ObjectTransactionVariousSimpleTest.fail((String)"object id in delta does not match any of the expected ones");
            }
            ++n2;
        }
    }

    public void testExportModified7() throws Exception {
        IObjectTransaction objectTransaction = ObjectTransactionFactory.getInstance().createObjectTransaction();
        objectTransaction.setCleanModus(true);
        Kunde kunde = new Kunde("4711");
        Vertrag v1 = new Vertrag("123");
        v1.setVertragsBeschreibung("vertrag nummer 123");
        kunde.addVertrag(v1);
        Vertrag v2 = new Vertrag("456");
        v2.setVertragsBeschreibung("vertrag nummer 456");
        kunde.addVertrag(v2);
        objectTransaction.setCleanModus(false);
        kunde.setVorname("john");
        kunde.setNachname("Miller");
        IObjectTransactionExtract extract = objectTransaction.exportOnlyModifedObjectsToExtract();
        TransactionDelta[] deltas = extract.getDeltas();
        ObjectTransactionVariousSimpleTest.assertTrue((String)"should be only one transaction delta", (deltas.length == 1 ? 1 : 0) != 0);
        ObjectTransactionVariousSimpleTest.assertTrue((String)"single delta should reference kunde", (deltas[0].getObjectId() == kunde.getObjectId() ? 1 : 0) != 0);
        ObjectTransactionVariousSimpleTest.assertTrue((String)"delta status must be modified", (boolean)deltas[0].getState().equals((Object)State.MODIFIED));
    }

    public void testExportModified8() throws Exception {
        IObjectTransaction objectTransaction = ObjectTransactionFactory.getInstance().createObjectTransaction();
        objectTransaction.setCleanModus(true);
        Kunde kunde = new Kunde("4711");
        kunde.setVorname("john");
        kunde.setNachname("Miller");
        Vertrag v1 = new Vertrag("123");
        v1.setVertragsBeschreibung("vertrag nummer 123");
        kunde.addVertrag(v1);
        Vertrag v2 = new Vertrag("456");
        v2.setVertragsBeschreibung("vertrag nummer 456");
        objectTransaction.setCleanModus(false);
        kunde.addVertrag(v2);
        IObjectTransactionExtract extract = objectTransaction.exportOnlyModifedObjectsToExtract();
        TransactionDelta[] deltas = extract.getDeltas();
        ObjectTransactionVariousSimpleTest.assertTrue((String)"should be only two transaction delta", (deltas.length == 2 ? 1 : 0) != 0);
        ObjectTransactionVariousSimpleTest.assertTrue((String)"single delta should reference kunde", (deltas[0].getObjectId() == kunde.getObjectId() ? 1 : 0) != 0);
        ObjectTransactionVariousSimpleTest.assertTrue((String)"delta status must be modified", (boolean)deltas[0].getState().equals((Object)State.MODIFIED));
        ObjectTransactionVariousSimpleTest.assertTrue((String)"single delta should reference v2", (deltas[1].getObjectId() == v2.getObjectId() ? 1 : 0) != 0);
        ObjectTransactionVariousSimpleTest.assertTrue((String)"delta status must be clean", (boolean)deltas[1].getState().equals((Object)State.CLEAN));
    }

    public void testExportModified9() throws Exception {
        IObjectTransaction objectTransaction = ObjectTransactionFactory.getInstance().createObjectTransaction();
        objectTransaction.setCleanModus(true);
        Kunde kunde = new Kunde("4711");
        kunde.setVorname("john");
        kunde.setNachname("Miller");
        Vertrag v1 = new Vertrag("123");
        v1.setVertragsBeschreibung("vertrag nummer 123");
        Vertrag v2 = new Vertrag("456");
        v2.setVertragsBeschreibung("vertrag nummer 456");
        objectTransaction.setCleanModus(false);
        kunde.addVertrag(v1);
        kunde.addVertrag(v2);
        IObjectTransactionExtract extract = objectTransaction.exportOnlyModifedObjectsToExtract();
        TransactionDelta[] deltas = extract.getDeltas();
        ObjectTransactionVariousSimpleTest.assertTrue((String)"should be only three transaction delta", (deltas.length == 3 ? 1 : 0) != 0);
        ObjectTransactionVariousSimpleTest.assertTrue((String)"single delta should reference kunde", (deltas[0].getObjectId() == kunde.getObjectId() ? 1 : 0) != 0);
        ObjectTransactionVariousSimpleTest.assertTrue((String)"delta status must be modified", (boolean)deltas[0].getState().equals((Object)State.MODIFIED));
        ObjectTransactionVariousSimpleTest.assertTrue((String)"single delta should reference v1", (deltas[1].getObjectId() == v1.getObjectId() ? 1 : 0) != 0);
        ObjectTransactionVariousSimpleTest.assertTrue((String)"delta status must be clean", (boolean)deltas[1].getState().equals((Object)State.CLEAN));
        ObjectTransactionVariousSimpleTest.assertTrue((String)"single delta should reference v2", (deltas[2].getObjectId() == v2.getObjectId() ? 1 : 0) != 0);
        ObjectTransactionVariousSimpleTest.assertTrue((String)"delta status must be clean", (boolean)deltas[2].getState().equals((Object)State.CLEAN));
    }

    public void testExportModified10() throws Exception {
        IObjectTransaction objectTransaction = ObjectTransactionFactory.getInstance().createObjectTransaction();
        objectTransaction.setCleanModus(true);
        Kunde kunde = new Kunde("4711");
        kunde.setVorname("john");
        kunde.setNachname("Miller");
        Vertrag v1 = new Vertrag("123");
        kunde.addVertrag(v1);
        Vertrag v2 = new Vertrag("456");
        kunde.addVertrag(v2);
        objectTransaction.setCleanModus(false);
        v1.setVertragsBeschreibung("vertrag nummer 123");
        v2.setVertragsBeschreibung("vertrag nummer 456");
        IObjectTransactionExtract extract = objectTransaction.exportOnlyModifedObjectsToExtract();
        TransactionDelta[] deltas = extract.getDeltas();
        ObjectTransactionVariousSimpleTest.assertTrue((String)"should be only two transaction delta", (deltas.length == 2 ? 1 : 0) != 0);
        ObjectTransactionVariousSimpleTest.assertTrue((String)"single delta should reference v1", (deltas[0].getObjectId() == v2.getObjectId() ? 1 : 0) != 0);
        ObjectTransactionVariousSimpleTest.assertTrue((String)"delta status must be modified", (boolean)deltas[0].getState().equals((Object)State.MODIFIED));
        ObjectTransactionVariousSimpleTest.assertTrue((String)"single delta should reference adresse", (deltas[1].getObjectId() == v1.getObjectId() ? 1 : 0) != 0);
        ObjectTransactionVariousSimpleTest.assertTrue((String)"delta status must be modified", (deltas[1].getState() == State.MODIFIED ? 1 : 0) != 0);
    }

    public void testExportModified11() throws Exception {
        IObjectTransaction objectTransaction = ObjectTransactionFactory.getInstance().createObjectTransaction();
        objectTransaction.setCleanModus(true);
        Kunde kunde = new Kunde("4711");
        Vertrag v1 = new Vertrag("123");
        v1.setVertragsBeschreibung("vertrag nummer 123");
        kunde.addVertrag(v1);
        Vertrag v2 = new Vertrag("456");
        v2.setVertragsBeschreibung("vertrag nummer 456");
        kunde.addVertrag(v2);
        objectTransaction.setCleanModus(false);
        kunde.setVorname("john");
        kunde.setNachname("Miller");
        IObjectTransactionExtract extract = objectTransaction.exportOnlyModifedObjectsToExtract();
        TransactionDelta[] deltas = extract.getDeltas();
        ObjectTransactionVariousSimpleTest.assertTrue((String)"should be only one transaction delta", (deltas.length == 1 ? 1 : 0) != 0);
        ObjectTransactionVariousSimpleTest.assertTrue((String)"single delta should reference kunde", (deltas[0].getObjectId() == kunde.getObjectId() ? 1 : 0) != 0);
        ObjectTransactionVariousSimpleTest.assertTrue((String)"delta status must be modified", (boolean)deltas[0].getState().equals((Object)State.MODIFIED));
    }

    public void testExportModified12() throws Exception {
        IObjectTransaction objectTransaction = ObjectTransactionFactory.getInstance().createObjectTransaction();
        objectTransaction.setCleanModus(true);
        Kunde kunde = new Kunde("4711");
        Vertrag v1 = new Vertrag("123");
        v1.setVertragsBeschreibung("vertrag nummer 123");
        kunde.addVertrag(v1);
        Vertrag v2 = new Vertrag("456");
        v2.setVertragsBeschreibung("vertrag nummer 456");
        kunde.addVertrag(v2);
        objectTransaction.setCleanModus(false);
        kunde.setVorname("john");
        kunde.setNachname("Miller");
        IObjectTransactionExtract extract = objectTransaction.exportOnlyModifedObjectsToExtract();
        extract.addCleanTransactedObject((ITransactedObject)v1);
        TransactionDelta[] deltas = extract.getDeltas();
        ObjectTransactionVariousSimpleTest.assertTrue((String)"should be two transaction deltas", (deltas.length == 2 ? 1 : 0) != 0);
        ObjectTransactionVariousSimpleTest.assertTrue((String)"single delta should reference kunde", (deltas[0].getObjectId() == kunde.getObjectId() ? 1 : 0) != 0);
        ObjectTransactionVariousSimpleTest.assertTrue((String)"delta status must be modified", (boolean)deltas[0].getState().equals((Object)State.MODIFIED));
        ObjectTransactionVariousSimpleTest.assertTrue((String)"single delta should reference kunde", (deltas[1].getObjectId() == v1.getObjectId() ? 1 : 0) != 0);
        ObjectTransactionVariousSimpleTest.assertTrue((String)"delta status must be clean", (boolean)deltas[1].getState().equals((Object)State.CLEAN));
    }

    public void testExportModified13() throws Exception {
        IObjectTransaction objectTransaction = ObjectTransactionFactory.getInstance().createObjectTransaction();
        objectTransaction.setCleanModus(true);
        Kunde kunde = new Kunde("4711");
        Vertrag v1 = new Vertrag("123");
        v1.setVertragsBeschreibung("vertrag nummer 123");
        kunde.addVertrag(v1);
        Vertrag v2 = new Vertrag("456");
        v2.setVertragsBeschreibung("vertrag nummer 456");
        kunde.addVertrag(v2);
        objectTransaction.setCleanModus(false);
        kunde.setVorname("john");
        kunde.setNachname("Miller");
        IObjectTransactionExtract extract = objectTransaction.exportOnlyModifedObjectsToExtract();
        try {
            extract.addCleanTransactedObject((ITransactedObject)kunde);
            ObjectTransactionVariousSimpleTest.fail((String)"non-clean transacted objects may not be added to an extract");
        }
        catch (AssertionFailedException assertionFailedException) {
            this.ok();
        }
    }

    public void testImportModified1() throws Exception {
        IObjectTransaction objectTransaction = ObjectTransactionFactory.getInstance().createObjectTransaction();
        objectTransaction.setCleanModus(true);
        Kunde kunde = new Kunde("4711");
        Vertrag v1 = new Vertrag("123");
        v1.setVertragsBeschreibung("vertrag nummer 123");
        kunde.addVertrag(v1);
        Vertrag v2 = new Vertrag("456");
        v2.setVertragsBeschreibung("vertrag nummer 456");
        kunde.addVertrag(v2);
        objectTransaction.setCleanModus(false);
        kunde.setVorname("john");
        kunde.setNachname("Miller");
        IObjectTransactionExtract extract = objectTransaction.exportExtract();
        IObjectTransaction objectTransaction2 = ObjectTransactionFactory.getInstance().createObjectTransaction();
        objectTransaction2.register((ITransactedObject)kunde);
        objectTransaction2.importOnlyModifedObjectsFromExtract(extract);
        ObjectTransactionVariousSimpleTest.assertTrue((String)"kunde must be registered", (boolean)objectTransaction2.isRegistered((ITransactedObject)kunde));
        ObjectTransactionVariousSimpleTest.assertTrue((String)"v1 must not be registered", (!objectTransaction2.isRegistered((ITransactedObject)v1) ? 1 : 0) != 0);
        ObjectTransactionVariousSimpleTest.assertTrue((String)"v2 must not be registered", (!objectTransaction2.isRegistered((ITransactedObject)v2) ? 1 : 0) != 0);
    }

    public void testImportModified2() throws Exception {
        IObjectTransaction objectTransaction = ObjectTransactionFactory.getInstance().createObjectTransaction();
        objectTransaction.setCleanModus(true);
        Kunde kunde = new Kunde("4711");
        Vertrag v1 = new Vertrag("123");
        v1.setVertragsBeschreibung("vertrag nummer 123");
        kunde.addVertrag(v1);
        Vertrag v2 = new Vertrag("456");
        kunde.addVertrag(v2);
        objectTransaction.setCleanModus(false);
        v2.setVertragsBeschreibung("vertrag nummer 456");
        kunde.setVorname("john");
        kunde.setNachname("Miller");
        IObjectTransactionExtract extract = objectTransaction.exportExtract();
        IObjectTransaction objectTransaction2 = ObjectTransactionFactory.getInstance().createObjectTransaction();
        objectTransaction2.register((ITransactedObject)kunde);
        objectTransaction2.register((ITransactedObject)v2);
        objectTransaction2.importOnlyModifedObjectsFromExtract(extract);
        ObjectTransactionVariousSimpleTest.assertTrue((String)"kunde must be registered", (boolean)objectTransaction2.isRegistered((ITransactedObject)kunde));
        ObjectTransactionVariousSimpleTest.assertTrue((String)"v1 must not be registered", (!objectTransaction2.isRegistered((ITransactedObject)v1) ? 1 : 0) != 0);
        ObjectTransactionVariousSimpleTest.assertTrue((String)"v2 must be registered", (boolean)objectTransaction2.isRegistered((ITransactedObject)v2));
    }

    public void testImportModified3() throws Exception {
        IObjectTransaction objectTransaction = ObjectTransactionFactory.getInstance().createObjectTransaction();
        objectTransaction.setCleanModus(true);
        Kunde kunde = new Kunde("4711");
        Vertrag v1 = new Vertrag("123");
        v1.setVertragsBeschreibung("vertrag nummer 123");
        kunde.addVertrag(v1);
        Vertrag v2 = new Vertrag("456");
        kunde.addVertrag(v2);
        objectTransaction.setCleanModus(false);
        v2.setVertragsBeschreibung("vertrag nummer 456");
        kunde.setVorname("john");
        kunde.setNachname("Miller");
        IObjectTransactionExtract extract = objectTransaction.exportExtract();
        IObjectTransaction objectTransaction2 = ObjectTransactionFactory.getInstance().createObjectTransaction();
        objectTransaction2.register((ITransactedObject)kunde);
        objectTransaction2.register((ITransactedObject)v2);
        objectTransaction2.register((ITransactedObject)v1);
        objectTransaction2.importOnlyModifedObjectsFromExtract(extract);
        ObjectTransactionVariousSimpleTest.assertTrue((String)"kunde must be registered", (boolean)objectTransaction2.isRegistered((ITransactedObject)kunde));
        ObjectTransactionVariousSimpleTest.assertTrue((String)"v1 must be registered", (boolean)objectTransaction2.isRegistered((ITransactedObject)v1));
        ObjectTransactionVariousSimpleTest.assertTrue((String)"v2 must be registered", (boolean)objectTransaction2.isRegistered((ITransactedObject)v2));
    }

    public void testImportModified4() throws Exception {
        IObjectTransaction objectTransaction = ObjectTransactionFactory.getInstance().createObjectTransaction();
        objectTransaction.setCleanModus(true);
        Kunde kunde = new Kunde("4711");
        Vertrag v1 = new Vertrag("123");
        v1.setVertragsBeschreibung("vertrag nummer 123");
        kunde.addVertrag(v1);
        Vertrag v2 = new Vertrag("456");
        v2.setVertragsBeschreibung("vertrag nummer 456");
        kunde.setVorname("john");
        kunde.setNachname("Miller");
        objectTransaction.setCleanModus(false);
        kunde.addVertrag(v2);
        IObjectTransactionExtract extract = objectTransaction.exportExtract();
        IObjectTransaction objectTransaction2 = ObjectTransactionFactory.getInstance().createObjectTransaction();
        objectTransaction2.register((ITransactedObject)kunde);
        try {
            objectTransaction2.importOnlyModifedObjectsFromExtract(extract);
            ObjectTransactionVariousSimpleTest.fail((String)"required transacted object v2 is not registered in target object transaction");
        }
        catch (InvalidTransactionFailure invalidTransactionFailure) {
            this.ok();
        }
    }

    public void testImportModified5() throws Exception {
        IObjectTransaction objectTransaction = ObjectTransactionFactory.getInstance().createObjectTransaction();
        objectTransaction.setCleanModus(true);
        Kunde kunde = new Kunde("4711");
        Vertrag v1 = new Vertrag("123");
        v1.setVertragsBeschreibung("vertrag nummer 123");
        kunde.addVertrag(v1);
        Vertrag v2 = new Vertrag("456");
        v2.setVertragsBeschreibung("vertrag nummer 456");
        kunde.setVorname("john");
        kunde.setNachname("Miller");
        kunde.addVertrag(v2);
        Addresse adresse = new Addresse(true);
        objectTransaction.setCleanModus(false);
        kunde.setAddresse(adresse);
        IObjectTransactionExtract extract = objectTransaction.exportExtract();
        IObjectTransaction objectTransaction2 = ObjectTransactionFactory.getInstance().createObjectTransaction();
        objectTransaction2.register((ITransactedObject)kunde);
        try {
            objectTransaction2.importOnlyModifedObjectsFromExtract(extract);
            ObjectTransactionVariousSimpleTest.fail((String)"required transacted object adresse is not registered in target object transaction");
        }
        catch (InvalidTransactionFailure invalidTransactionFailure) {
            this.ok();
        }
    }

    public void testCheckNullValue1() throws Exception {
        IObjectTransaction objectTransaction = ObjectTransactionFactory.getInstance().createObjectTransaction();
        objectTransaction.setCleanModus(true);
        Kunde kunde = new Kunde("4711");
        kunde.setVorname("john");
        kunde.setNachname("Miller");
        Addresse adresse = new Addresse(true);
        kunde.setAddresse(adresse);
        objectTransaction.setCleanModus(false);
        kunde.setAddresse(null);
        ObjectTransactionVariousSimpleTest.assertNull((String)"adresse must be null", (Object)((Object)kunde.getAddresse()));
        kunde.setVorname(null);
        ObjectTransactionVariousSimpleTest.assertNull((String)"vorname must be null", (Object)kunde.getVorname());
    }

    public void testAddDeleteImportExport() throws Exception {
        IObjectTransaction objectTransaction = ObjectTransactionFactory.getInstance().createObjectTransaction();
        Kunde kunde = new Kunde("4711");
        objectTransaction.registerAsDeleted((ITransactedObject)kunde);
        IObjectTransactionExtract extract = objectTransaction.exportExtract();
        IObjectTransaction ot2 = ObjectTransactionFactory.getInstance().createObjectTransaction();
        ot2.importExtract(extract);
    }

    public void testAddDeleteImportExport2() throws Exception {
        IObjectTransaction objectTransaction = ObjectTransactionFactory.getInstance().createObjectTransaction();
        Kunde kunde = new Kunde("4711");
        objectTransaction.registerAsDeleted((ITransactedObject)kunde);
        IObjectTransactionExtract extract = objectTransaction.exportOnlyModifedObjectsToExtract();
        IObjectTransaction ot2 = ObjectTransactionFactory.getInstance().createObjectTransaction();
        ot2.importExtract(extract);
    }

    public void testAddDeleteImportExport3() throws Exception {
        IObjectTransaction objectTransaction = ObjectTransactionFactory.getInstance().createObjectTransaction();
        Kunde kunde = new Kunde("4711");
        objectTransaction.registerAsDeleted((ITransactedObject)kunde);
        IObjectTransactionExtract extract = objectTransaction.exportExtract();
        IObjectTransaction ot2 = ObjectTransactionFactory.getInstance().createObjectTransaction();
        ot2.importOnlyModifedObjectsFromExtract(extract);
    }

    public void testAddDeleteImportExport4() throws Exception {
        IObjectTransaction objectTransaction = ObjectTransactionFactory.getInstance().createObjectTransaction();
        Kunde kunde = new Kunde("4711");
        Vertrag v1 = new Vertrag("11");
        Vertrag v2 = new Vertrag("12");
        kunde.addVertrag(v1);
        kunde.addVertrag(v2);
        objectTransaction.registerAsDeleted((ITransactedObject)kunde);
        objectTransaction.registerAsDeleted((ITransactedObject)v1);
        objectTransaction.registerAsDeleted((ITransactedObject)v2);
        IObjectTransactionExtract extract = objectTransaction.exportExtract();
        IObjectTransaction ot2 = ObjectTransactionFactory.getInstance().createObjectTransaction();
        ot2.importOnlyModifedObjectsFromExtract(extract);
    }

    public void testAddRemoveImportExportWithNewObjects() throws Exception {
        IObjectTransaction objectTransaction = ObjectTransactionFactory.getInstance().createObjectTransaction();
        Kunde kunde = new Kunde("4711");
        Addresse adresse = new Addresse(true);
        kunde.setAddresse(adresse);
        kunde.setAddresse(null);
        objectTransaction.registerAsDeleted((ITransactedObject)adresse);
        IObjectTransactionExtract extract = objectTransaction.exportExtract();
        IObjectTransaction ot2 = ObjectTransactionFactory.getInstance().createObjectTransaction();
        new Kunde("4711");
        ot2.importExtract(extract);
    }

    public void testAddRemoveImportExportWithExistingObjects() throws Exception {
        IObjectTransaction objectTransaction = ObjectTransactionFactory.getInstance().createObjectTransaction();
        objectTransaction.setCleanModus(true);
        Kunde kunde = new Kunde("4711");
        objectTransaction.setCleanModus(false);
        Addresse adresse = new Addresse(true);
        kunde.setAddresse(adresse);
        kunde.setAddresse(null);
        objectTransaction.registerAsDeleted((ITransactedObject)adresse);
        IObjectTransactionExtract extract = objectTransaction.exportExtract();
        IObjectTransaction ot2 = ObjectTransactionFactory.getInstance().createObjectTransaction();
        new Kunde("4711");
        ot2.importExtract(extract);
    }

    public void testAddRemoveImportExportWithExistingObjectsOneToNRelation() throws Exception {
        IObjectTransaction objectTransaction = ObjectTransactionFactory.getInstance().createObjectTransaction();
        objectTransaction.setCleanModus(true);
        Kunde kunde = new Kunde("4711");
        objectTransaction.setCleanModus(false);
        Vertrag v1 = new Vertrag("11");
        kunde.addVertrag(v1);
        kunde.removeVertrag(v1);
        objectTransaction.registerAsDeleted((ITransactedObject)v1);
        IObjectTransactionExtract extract = objectTransaction.exportExtract();
        IObjectTransaction ot2 = ObjectTransactionFactory.getInstance().createObjectTransaction();
        ot2.setCleanModus(true);
        new Kunde("4711");
        ot2.setCleanModus(false);
        ot2.importExtract(extract);
    }

    public void testAddRemoveImportExportWithNewObjectsOneToNRelation() throws Exception {
        IObjectTransaction objectTransaction = ObjectTransactionFactory.getInstance().createObjectTransaction();
        Kunde kunde = new Kunde("4711");
        Vertrag v1 = new Vertrag("11");
        kunde.addVertrag(v1);
        kunde.removeVertrag(v1);
        objectTransaction.registerAsDeleted((ITransactedObject)v1);
        objectTransaction.registerAsDeleted((ITransactedObject)kunde);
        IObjectTransactionExtract extract = objectTransaction.exportExtract();
        IObjectTransaction ot2 = ObjectTransactionFactory.getInstance().createObjectTransaction();
        ot2.importExtract(extract);
    }

    public void testTwoWayImportExport() throws Exception {
        IObjectTransaction objectTransaction = ObjectTransactionFactory.getInstance().createObjectTransaction();
        objectTransaction.setCleanModus(true);
        Kunde kunde = new Kunde("4711");
        kunde.setNachname("m\u00fcller");
        objectTransaction.setCleanModus(false);
        objectTransaction.registerAsDeleted((ITransactedObject)kunde);
        IObjectTransactionExtract extract = objectTransaction.exportOnlyModifedObjectsToExtract();
        IObjectTransaction ot2 = ObjectTransactionFactory.getInstance().createObjectTransaction();
        ot2.setCleanModus(true);
        new Kunde("4711");
        ot2.setCleanModus(false);
        ot2.importExtract(extract);
        ot2.commitToObjects();
        IObjectTransactionExtract extract2 = ot2.exportExtract();
        objectTransaction.commitToObjects();
        objectTransaction.importExtract(extract2);
    }

    public void testSubSubTransaction() throws Exception {
        IObjectTransaction objectTransaction = ObjectTransactionFactory.getInstance().createObjectTransaction();
        objectTransaction.setCleanModus(true);
        Kunde kunde = new Kunde("4711");
        kunde.setNachname("m\u00fcller");
        objectTransaction.setCleanModus(false);
        IObjectTransaction subOT = objectTransaction.createSubObjectTransaction();
        Vertrag v1 = new Vertrag("4711");
        kunde.addVertrag(v1);
        IObjectTransaction subSubOT = subOT.createSubObjectTransaction();
        Vertrag v2 = new Vertrag("1015");
        kunde.addVertrag(v2);
        Kunde kunde2 = new Kunde("4712");
        kunde2.setNachname("campo");
        subSubOT.commit();
        subOT.commit();
        objectTransaction.commitToObjects();
        kunde2.setNachname("Campo");
        kunde.setNachname("Schramm");
        v1.setVertragsBeschreibung("xxx");
        v2.setVertragsBeschreibung("yyyy");
    }
}

