/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.security.authentication.module;

import java.io.IOException;
import java.security.Principal;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.IRienaActivator;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.internal.tests.Activator;
import org.eclipse.riena.security.common.SecurityFailure;
import org.eclipse.riena.security.common.authentication.SimplePrincipal;

public class TestLocalLoginModule
implements LoginModule {
    private Subject subject;
    private CallbackHandler callbackHandler;
    private String username;
    private String password;
    private static String checkedUsername;
    private static String checkedPassword;
    private static final Logger LOGGER;

    static {
        LOGGER = Log4r.getLogger((IRienaActivator)Activator.getDefault(), TestLocalLoginModule.class);
    }

    public static void setCredentials(String usernameParm, String passwordParm) {
        checkedUsername = usernameParm;
        checkedPassword = passwordParm;
    }

    @Override
    public boolean abort() throws LoginException {
        LOGGER.log(4, "abort");
        return false;
    }

    @Override
    public boolean commit() throws LoginException {
        LOGGER.log(4, "commit");
        this.subject.getPrincipals().add((Principal)new SimplePrincipal(this.username));
        return true;
    }

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        if (callbackHandler == null) {
            LOGGER.log(1, "callbackhandler cant be null");
            throw new RuntimeException("callbackhandler cant be null");
        }
        LOGGER.log(4, "initialize");
        this.subject = subject;
        this.callbackHandler = callbackHandler;
    }

    @Override
    public boolean login() throws LoginException {
        LOGGER.log(4, "login");
        Callback[] callbacks = new Callback[]{new NameCallback("username: "), new PasswordCallback("password: ", false)};
        if (this.callbackHandler == null) {
            System.out.println("callbackhandler cant be null");
            return false;
        }
        try {
            this.callbackHandler.handle(callbacks);
            this.username = ((NameCallback)callbacks[0]).getName();
            this.password = new String(((PasswordCallback)callbacks[1]).getPassword());
            return this.username != null && this.password != null && this.username.equals(checkedUsername) && this.password.equals(checkedPassword);
        }
        catch (IOException e) {
            throw new SecurityFailure("Login failed", (Throwable)e);
        }
        catch (UnsupportedCallbackException e) {
            throw new SecurityFailure("Login failed", (Throwable)e);
        }
    }

    @Override
    public boolean logout() throws LoginException {
        LOGGER.log(4, "logout");
        return false;
    }
}

