/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.security.services.itest.session;

import java.security.Principal;
import org.eclipse.riena.communication.core.IRemoteServiceRegistration;
import org.eclipse.riena.communication.core.factory.Register;
import org.eclipse.riena.core.test.RienaTestCase;
import org.eclipse.riena.core.test.collect.IntegrationTestCase;
import org.eclipse.riena.internal.tests.Activator;
import org.eclipse.riena.security.common.authentication.SimplePrincipal;
import org.eclipse.riena.security.common.session.Session;
import org.eclipse.riena.security.server.session.ISessionService;
import org.osgi.framework.ServiceReference;

@IntegrationTestCase
public class SessionServiceITest
extends RienaTestCase {
    private static final int LOOP_5 = 5;
    private static final int LOOP_20 = 20;
    private static final int LOOP_100 = 100;
    private static final int LOOP_400 = 400;
    private static final int THREAD_5 = 5;
    private static final int THREAD_20 = 20;
    private static final int THREAD_100 = 100;
    private IRemoteServiceRegistration sessionService;

    protected void setUp() throws Exception {
        super.setUp();
        this.startBundles("org\\.eclipse\\.equinox\\.cm.*", null);
        this.startBundles("org\\.eclipse\\.equinox\\.log.*", null);
        this.startBundles("org\\.eclipse\\.riena.communication.core", null);
        this.startBundles("org\\.eclipse\\.riena.communication.factory.hessian", null);
        this.startBundles("org\\.eclipse\\.riena.communication.registry", null);
        this.sessionService = Register.remoteProxy(ISessionService.class).usingUrl("http://localhost:8080/hessian/SessionService").withProtocol("hessian").andStart(Activator.getDefault().getContext());
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.sessionService.unregister();
    }

    public void testController1() throws Exception {
        ServiceReference ref = this.getContext().getServiceReference(ISessionService.class.getName());
        ISessionService service = (ISessionService)this.getContext().getService(ref);
        SessionServiceITest.assertNotNull((String)"SessionControllerAccessor returns null", (Object)service);
        Session session = service.generateSession(new Principal[]{new SimplePrincipal("testuid")});
        SessionServiceITest.assertNotNull((String)"generateSession returns null", (Object)session);
        Principal[] principals = service.findPrincipals(session);
        SessionServiceITest.assertNotNull((String)"findUser returns null", (Object)principals);
        SessionServiceITest.assertTrue((String)"returned userid is not equal to the correct one", (boolean)principals[0].getName().equals("testuid"));
        service.invalidateSession(session);
        SessionServiceITest.assertFalse((String)"session should be invalid", (boolean)service.isValidSession(session));
        Principal[] temp = service.findPrincipals(session);
        SessionServiceITest.assertNull((String)"no user should be found for invalid session", (Object)temp);
    }

    public void texxstMultiuser() throws Exception {
        this.createNNNThreads(5, 5);
        this.createNNNThreads(5, 20);
        this.createNNNThreads(20, 20);
        this.createNNNThreads(100, 20);
        this.createNNNThreads(100, 100);
        this.createNNNThreads(100, 400);
    }

    private void createNNNThreads(int noOfThreads, int loopCounter) {
        Thread[] t = new Thread[noOfThreads];
        int i = 0;
        while (i < noOfThreads) {
            t[i] = new Threader(loopCounter);
            ++i;
        }
        i = 0;
        while (i < noOfThreads) {
            t[i].start();
            ++i;
        }
        int activeThreads = noOfThreads;
        while (activeThreads > 0) {
            int i2 = 0;
            while (i2 < noOfThreads && activeThreads > 0) {
                if (t[i2] != null && !t[i2].isAlive()) {
                    --activeThreads;
                }
                ++i2;
            }
        }
    }

    class Threader
    extends Thread {
        private final ISessionService sessionService;
        private final int loopCounter;

        Threader(int loopCounter) {
            ServiceReference ref = SessionServiceITest.this.getContext().getServiceReference(ISessionService.class.getName());
            this.sessionService = (ISessionService)SessionServiceITest.this.getContext().getService(ref);
            this.loopCounter = loopCounter;
            SessionServiceITest.assertNotNull((String)"SessionServiceAccessor returns null", (Object)this.sessionService);
        }

        @Override
        public void run() {
            int i = 0;
            while (i < this.loopCounter) {
                Session session = this.sessionService.generateSession(new Principal[]{new SimplePrincipal("testuid")});
                SessionServiceITest.assertNotNull((String)"generateSession returns null", (Object)session);
                Principal[] principals = this.sessionService.findPrincipals(session);
                SessionServiceITest.assertTrue((String)"returned userid is not equal to the correct one", (principals == null || principals[0].getName().equals("testuid") ? 1 : 0) != 0);
                this.sessionService.invalidateSession(session);
                Principal[] temp = this.sessionService.findPrincipals(session);
                SessionServiceITest.assertTrue((String)"no user should be found for invalid session", (temp == null || temp[0].getName().equals("testuid") ? 1 : 0) != 0);
                ++i;
            }
        }
    }
}

