/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.riena.beans.common.Address;
import org.eclipse.riena.beans.common.Person;
import org.eclipse.riena.beans.common.TestBean;
import org.eclipse.riena.core.marker.IMarkable;
import org.eclipse.riena.core.marker.Markable;
import org.eclipse.riena.core.test.RienaTestCase;
import org.eclipse.riena.core.test.collect.NonUITestCase;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.ui.core.marker.ErrorMarker;
import org.eclipse.riena.ui.core.marker.ErrorMessageMarker;
import org.eclipse.riena.ui.core.marker.IMessageMarker;
import org.eclipse.riena.ui.core.marker.MessageMarker;
import org.eclipse.riena.ui.core.marker.ValidationTime;
import org.eclipse.riena.ui.ridgets.ValueBindingSupport;
import org.eclipse.riena.ui.ridgets.marker.ValidationMessageMarker;
import org.eclipse.riena.ui.ridgets.swt.DefaultRealm;
import org.eclipse.riena.ui.ridgets.validation.MinLength;
import org.eclipse.riena.ui.ridgets.validation.ValidRange;
import org.eclipse.riena.ui.ridgets.validation.ValidationFailure;
import org.eclipse.riena.ui.ridgets.validation.ValidationRuleStatus;

@NonUITestCase
public class ValueBindingSupportTest
extends RienaTestCase {
    private DefaultRealm realm;
    private ValueBindingSupport valueBindingSupport;
    private TestBean bean;
    private IObservableValue model;
    private IObservableValue target;
    private IMarkable markable;

    protected void setUp() throws Exception {
        super.setUp();
        this.realm = new DefaultRealm();
        this.bean = new TestBean();
        this.model = PojoObservables.observeValue((Object)this.bean, (String)"property");
        this.target = new WritableValue();
        this.valueBindingSupport = new ValueBindingSupport(this.target, this.model);
        this.markable = new Markable();
        this.valueBindingSupport.setMarkable(this.markable);
    }

    protected void tearDown() throws Exception {
        this.realm.dispose();
        this.realm = null;
        super.tearDown();
    }

    public void testAddRemoveAfterGetValidator() throws Exception {
        ValueBindingSupportTest.assertTrue((boolean)this.valueBindingSupport.getAllValidators().getValidators().isEmpty());
        MinLength validator = new MinLength(5);
        ValueBindingSupportTest.assertFalse((boolean)this.valueBindingSupport.addValidationRule((IValidator)validator, ValidationTime.ON_UPDATE_TO_MODEL));
        ValueBindingSupportTest.assertEquals((int)1, (int)this.valueBindingSupport.getAllValidators().getValidators().size());
        ValueBindingSupportTest.assertFalse((boolean)this.valueBindingSupport.removeValidationRule((IValidator)validator));
        ValueBindingSupportTest.assertTrue((boolean)this.valueBindingSupport.getAllValidators().getValidators().isEmpty());
    }

    public void testAddRemoveAfterSetValidator() throws Exception {
        ValueBindingSupportTest.assertTrue((boolean)this.valueBindingSupport.getAllValidators().getValidators().isEmpty());
        MinLength validator = new MinLength(5);
        ValueBindingSupportTest.assertFalse((boolean)this.valueBindingSupport.addValidationRule((IValidator)validator, ValidationTime.AFTER_UPDATE_TO_MODEL));
        ValueBindingSupportTest.assertEquals((int)1, (int)this.valueBindingSupport.getAllValidators().getValidators().size());
        ValueBindingSupportTest.assertFalse((boolean)this.valueBindingSupport.removeValidationRule((IValidator)validator));
        ValueBindingSupportTest.assertTrue((boolean)this.valueBindingSupport.getAllValidators().getValidators().isEmpty());
    }

    public void testAddRemoveOnEditValidator() throws Exception {
        ValueBindingSupportTest.assertTrue((boolean)this.valueBindingSupport.getAllValidators().getValidators().isEmpty());
        MinLength validator = new MinLength(5);
        ValueBindingSupportTest.assertTrue((boolean)this.valueBindingSupport.addValidationRule((IValidator)validator, ValidationTime.ON_UI_CONTROL_EDIT));
        ValueBindingSupportTest.assertEquals((int)1, (int)this.valueBindingSupport.getAllValidators().getValidators().size());
        ValueBindingSupportTest.assertTrue((boolean)this.valueBindingSupport.removeValidationRule((IValidator)validator));
        ValueBindingSupportTest.assertTrue((boolean)this.valueBindingSupport.getAllValidators().getValidators().isEmpty());
    }

    public void testUpdateFromModelOnRequest() throws Exception {
        ValueBindingSupportTest.assertNull((Object)this.target.getValue());
        this.bean.setProperty((Object)"TestValue");
        ValueBindingSupportTest.assertNull((Object)this.target.getValue());
        this.valueBindingSupport.updateFromModel();
        ValueBindingSupportTest.assertEquals((Object)"TestValue", (Object)this.target.getValue());
    }

    public void testUpdateFromTargetImmediately() throws Exception {
        ValueBindingSupportTest.assertNull((Object)this.bean.getProperty());
        this.target.setValue((Object)"TestValue");
        ValueBindingSupportTest.assertEquals((Object)"TestValue", (Object)this.bean.getProperty());
    }

    public void testValidationMessagesAddAndRemove() throws Exception {
        this.valueBindingSupport.addValidationRule((IValidator)new EvenNumberOfCharacters(), ValidationTime.ON_UPDATE_TO_MODEL);
        this.valueBindingSupport.addValidationMessage("TestMessage1");
        this.valueBindingSupport.addValidationMessage("TestMessage2");
        ErrorMessageMarker messageMarker1 = new ErrorMessageMarker("TestMessage3");
        this.valueBindingSupport.addValidationMessage((IMessageMarker)messageMarker1);
        MessageMarker messageMarker2 = new MessageMarker("TestMessage4");
        this.valueBindingSupport.addValidationMessage((IMessageMarker)messageMarker2);
        ValueBindingSupportTest.assertEquals((int)0, (int)this.markable.getMarkers().size());
        this.target.setValue((Object)"odd");
        ValueBindingSupportTest.assertEquals((int)5, (int)this.markable.getMarkers().size());
        this.assertMessageMarkers("TestMessage1", "TestMessage2", "TestMessage3", "TestMessage4");
        this.target.setValue((Object)"even");
        ValueBindingSupportTest.assertEquals((int)0, (int)this.markable.getMarkers().size());
        this.valueBindingSupport.removeValidationMessage("TestMessage1");
        this.valueBindingSupport.removeValidationMessage((IMessageMarker)messageMarker1);
        this.target.setValue((Object)"odd");
        ValueBindingSupportTest.assertEquals((int)3, (int)this.markable.getMarkers().size());
        this.assertMessageMarkers("TestMessage2", "TestMessage4");
        this.target.setValue((Object)"even");
        ValueBindingSupportTest.assertEquals((int)0, (int)this.markable.getMarkers().size());
        this.valueBindingSupport.removeValidationMessage("TestMessage2");
        this.valueBindingSupport.removeValidationMessage((IMessageMarker)messageMarker2);
        this.target.setValue((Object)"odd");
        ValueBindingSupportTest.assertEquals((int)1, (int)this.markable.getMarkers().size());
        ValueBindingSupportTest.assertTrue((boolean)(this.markable.getMarkers().iterator().next() instanceof ErrorMarker));
        this.target.setValue((Object)"even");
        ValueBindingSupportTest.assertEquals((int)0, (int)this.markable.getMarkers().size());
    }

    public void testAddValidationMessageForUnknownRule() {
        AlwaysWrongValidator rule = new AlwaysWrongValidator();
        this.valueBindingSupport.addValidationMessage("foo", (IValidator)rule);
        ValueBindingSupportTest.assertEquals((int)0, (int)this.markable.getMarkers().size());
    }

    public void testRemoveValidationMessageWhenRemovingRule() {
        AlwaysWrongValidator rule = new AlwaysWrongValidator();
        this.valueBindingSupport.addValidationMessage("foo", (IValidator)rule);
        this.valueBindingSupport.addValidationRule((IValidator)rule, ValidationTime.ON_UPDATE_TO_MODEL);
        this.target.setValue((Object)"value");
        ValueBindingSupportTest.assertEquals((int)1, (int)this.markable.getMarkersOfType(ValidationMessageMarker.class).size());
        this.valueBindingSupport.removeValidationRule((IValidator)rule);
        ValueBindingSupportTest.assertEquals((int)0, (int)this.markable.getMarkersOfType(ValidationMessageMarker.class).size());
    }

    public void testAddSameValidationMessage() {
        EvenNumberOfCharacters rule = new EvenNumberOfCharacters();
        this.valueBindingSupport.addValidationRule((IValidator)rule, ValidationTime.ON_UPDATE_TO_MODEL);
        this.valueBindingSupport.addValidationMessage("TestMessage1");
        this.valueBindingSupport.addValidationMessage("TestMessage1");
        this.valueBindingSupport.addValidationMessage("TestMessage2", (IValidator)rule);
        this.valueBindingSupport.addValidationMessage("TestMessage2", (IValidator)rule);
        MessageMarker messageMarker = new MessageMarker("TestMessage3");
        this.valueBindingSupport.addValidationMessage((IMessageMarker)messageMarker);
        this.valueBindingSupport.addValidationMessage((IMessageMarker)messageMarker);
        MessageMarker messageMarker2 = new MessageMarker("TestMessage4");
        this.valueBindingSupport.addValidationMessage((IMessageMarker)messageMarker2, (IValidator)rule);
        this.valueBindingSupport.addValidationMessage((IMessageMarker)messageMarker2, (IValidator)rule);
        ValueBindingSupportTest.assertEquals((int)0, (int)this.markable.getMarkers().size());
        this.target.setValue((Object)"odd");
        ValueBindingSupportTest.assertEquals((int)4, (int)this.markable.getMarkersOfType(ValidationMessageMarker.class).size());
        this.target.setValue((Object)"even");
        ValueBindingSupportTest.assertEquals((int)0, (int)this.markable.getMarkers().size());
    }

    public void testValidationMessagesAddAndRemoveWhileActive() throws Exception {
        this.valueBindingSupport.addValidationRule((IValidator)new EvenNumberOfCharacters(), ValidationTime.ON_UPDATE_TO_MODEL);
        this.target.setValue((Object)"odd");
        ValueBindingSupportTest.assertEquals((int)1, (int)this.markable.getMarkers().size());
        ValueBindingSupportTest.assertTrue((boolean)(this.markable.getMarkers().iterator().next() instanceof ErrorMarker));
        this.valueBindingSupport.addValidationMessage("TestMessage1");
        ValueBindingSupportTest.assertEquals((int)2, (int)this.markable.getMarkers().size());
        this.assertMessageMarkers("TestMessage1");
        MessageMarker messageMarker = new MessageMarker("TestMessage2");
        this.valueBindingSupport.addValidationMessage((IMessageMarker)messageMarker);
        ValueBindingSupportTest.assertEquals((int)3, (int)this.markable.getMarkers().size());
        this.assertMessageMarkers("TestMessage1", "TestMessage2");
        this.valueBindingSupport.removeValidationMessage("TestMessage1");
        ValueBindingSupportTest.assertEquals((int)2, (int)this.markable.getMarkers().size());
        this.assertMessageMarkers("TestMessage2");
        this.valueBindingSupport.removeValidationMessage((IMessageMarker)messageMarker);
        ValueBindingSupportTest.assertEquals((int)1, (int)this.markable.getMarkers().size());
        ValueBindingSupportTest.assertTrue((boolean)(this.markable.getMarkers().iterator().next() instanceof ErrorMarker));
    }

    public void testSpecialValidationMessages() throws Exception {
        EvenNumberOfCharacters evenNumberOfCharacters = new EvenNumberOfCharacters();
        NotEndingWithDisaster notEndingWithDisaster = new NotEndingWithDisaster();
        this.valueBindingSupport.addValidationRule((IValidator)evenNumberOfCharacters, ValidationTime.ON_UPDATE_TO_MODEL);
        this.valueBindingSupport.addValidationRule((IValidator)notEndingWithDisaster, ValidationTime.ON_UPDATE_TO_MODEL);
        this.valueBindingSupport.addValidationMessage("TestNotEvenMessage1", (IValidator)evenNumberOfCharacters);
        this.valueBindingSupport.addValidationMessage((IMessageMarker)new MessageMarker("TestNotEvenMessage2"), (IValidator)evenNumberOfCharacters);
        this.valueBindingSupport.addValidationMessage("TestDisasterMessage", (IValidator)notEndingWithDisaster);
        ValueBindingSupportTest.assertEquals((int)0, (int)this.markable.getMarkers().size());
        this.target.setValue((Object)"Disaster");
        ValueBindingSupportTest.assertEquals((int)2, (int)this.markable.getMarkers().size());
        this.assertMessageMarkers("TestDisasterMessage");
        this.target.setValue((Object)"Disaster Area");
        ValueBindingSupportTest.assertEquals((int)3, (int)this.markable.getMarkers().size());
        this.assertMessageMarkers("TestNotEvenMessage1", "TestNotEvenMessage2");
        this.target.setValue((Object)"We are teetering on the brink of disaster");
        ValueBindingSupportTest.assertEquals((int)5, (int)this.markable.getMarkers().size());
        this.assertMessageMarkers("TestNotEvenMessage1", "TestNotEvenMessage2", "TestDisasterMessage");
        this.target.setValue((Object)"Save again");
        ValueBindingSupportTest.assertEquals((int)0, (int)this.markable.getMarkers().size());
    }

    public void testValidationRuleAddAndRemove() {
        EvenNumberOfCharacters rule = new EvenNumberOfCharacters();
        boolean isOnEdit1 = this.valueBindingSupport.addValidationRule((IValidator)rule, ValidationTime.ON_UI_CONTROL_EDIT);
        ValueBindingSupportTest.assertTrue((boolean)isOnEdit1);
        ValueBindingSupportTest.assertTrue((boolean)this.valueBindingSupport.getOnEditValidators().contains((IValidator)rule));
        ValueBindingSupportTest.assertFalse((boolean)this.valueBindingSupport.getAfterGetValidators().contains((IValidator)rule));
        boolean isOnEdit2 = this.valueBindingSupport.addValidationRule((IValidator)rule, ValidationTime.ON_UPDATE_TO_MODEL);
        ValueBindingSupportTest.assertFalse((boolean)isOnEdit2);
        ValueBindingSupportTest.assertTrue((boolean)this.valueBindingSupport.getOnEditValidators().contains((IValidator)rule));
        ValueBindingSupportTest.assertTrue((boolean)this.valueBindingSupport.getAfterGetValidators().contains((IValidator)rule));
        this.valueBindingSupport.removeValidationRule((IValidator)rule);
        ValueBindingSupportTest.assertFalse((boolean)this.valueBindingSupport.getOnEditValidators().contains((IValidator)rule));
        ValueBindingSupportTest.assertFalse((boolean)this.valueBindingSupport.getAfterGetValidators().contains((IValidator)rule));
    }

    public void testValidationRuleAddAndRemoveNull() {
        try {
            this.valueBindingSupport.addValidationRule(null, ValidationTime.ON_UPDATE_TO_MODEL);
            ValueBindingSupportTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        boolean result = this.valueBindingSupport.removeValidationRule(null);
        ValueBindingSupportTest.assertFalse((boolean)result);
    }

    public void testAddAndRemoveValidationMessageWithRule() {
        ValueBindingSupportTest.assertEquals((int)0, (int)this.markable.getMarkersOfType(ValidationMessageMarker.class).size());
        MinLength rule = new MinLength(3);
        this.valueBindingSupport.addValidationRule((IValidator)rule, ValidationTime.ON_UPDATE_TO_MODEL);
        this.valueBindingSupport.addValidationMessage("too short", (IValidator)rule);
        this.target.setValue((Object)"a");
        ValueBindingSupportTest.assertEquals((int)1, (int)this.markable.getMarkersOfType(ValidationMessageMarker.class).size());
        this.assertMessageMarkers("too short");
        this.valueBindingSupport.removeValidationMessage("too short", (IValidator)rule);
        ValueBindingSupportTest.assertEquals((int)0, (int)this.markable.getMarkersOfType(ValidationMessageMarker.class).size());
    }

    public void testAddAndRemoveValidationMessageWithoutRule() {
        ValueBindingSupportTest.assertEquals((int)0, (int)this.markable.getMarkersOfType(ValidationMessageMarker.class).size());
        MinLength rule = new MinLength(3);
        this.valueBindingSupport.addValidationRule((IValidator)rule, ValidationTime.ON_UPDATE_TO_MODEL);
        this.valueBindingSupport.addValidationMessage("too short");
        this.target.setValue((Object)"a");
        ValueBindingSupportTest.assertEquals((int)1, (int)this.markable.getMarkersOfType(ValidationMessageMarker.class).size());
        this.assertMessageMarkers("too short");
        this.valueBindingSupport.removeValidationMessage("too short");
        ValueBindingSupportTest.assertEquals((int)0, (int)this.markable.getMarkersOfType(ValidationMessageMarker.class).size());
    }

    public void testShowErrorAfterValidationOnUpdateWithBlock() {
        ValidRange rule = new ValidRange((Number)18, (Number)80);
        this.valueBindingSupport.addValidationRule((IValidator)rule, ValidationTime.ON_UPDATE_TO_MODEL);
        IStatus errorStatus = rule.validate((Object)"81");
        ValueBindingSupportTest.assertEquals((int)1024, (int)errorStatus.getCode());
        ValueBindingSupportTest.assertEquals((int)0, (int)this.markable.getMarkersOfType(ErrorMarker.class).size());
        this.valueBindingSupport.updateValidationStatus((IValidator)rule, errorStatus);
        ValueBindingSupportTest.assertEquals((int)1, (int)this.markable.getMarkersOfType(ErrorMarker.class).size());
        IStatus okStatus = rule.validate((Object)"80");
        this.valueBindingSupport.updateValidationStatus((IValidator)rule, okStatus);
        ValueBindingSupportTest.assertEquals((int)0, (int)this.markable.getMarkersOfType(ErrorMarker.class).size());
    }

    public void testUsesBeanObservablesWhenBindingABean() {
        Person person = new Person("Max", "Muster");
        Address pdx = ValueBindingSupportTest.createAddress("pdx", "Portland", "97209", "USA");
        Address fra = ValueBindingSupportTest.createAddress("fra", "Frankfurt", "60329", "DE");
        person.setAddress(pdx);
        this.valueBindingSupport.bindToModel((Object)person, "address.streetAndNumber");
        ValueBindingSupportTest.assertEquals((String)"pdx", (String)person.getAddress().getStreetAndNumber());
        ValueBindingSupportTest.assertEquals((String)"pdx", (String)pdx.getStreetAndNumber());
        this.target.setValue((Object)"new 1");
        ValueBindingSupportTest.assertEquals((String)"new 1", (String)person.getAddress().getStreetAndNumber());
        ValueBindingSupportTest.assertEquals((String)"new 1", (String)pdx.getStreetAndNumber());
        person.setAddress(fra);
        this.target.setValue((Object)"new 2");
        ValueBindingSupportTest.assertEquals((String)"new 2", (String)person.getAddress().getStreetAndNumber());
        ValueBindingSupportTest.assertEquals((String)"new 2", (String)fra.getStreetAndNumber());
        ValueBindingSupportTest.assertEquals((String)"new 1", (String)pdx.getStreetAndNumber());
    }

    public void testUpdateFromModelOnRequest2() {
        Person person = new Person("muster", "max");
        this.valueBindingSupport.bindToModel((Object)person, "firstname");
        this.valueBindingSupport.updateFromModel();
        ValueBindingSupportTest.assertEquals((String)"max", (String)person.getFirstname());
        ValueBindingSupportTest.assertEquals((Object)"max", (Object)this.target.getValue());
        this.target.setValue((Object)"moritz");
        ValueBindingSupportTest.assertEquals((String)"moritz", (String)person.getFirstname());
        ValueBindingSupportTest.assertEquals((Object)"moritz", (Object)this.target.getValue());
        person.setFirstname("michel");
        ValueBindingSupportTest.assertEquals((String)"michel", (String)person.getFirstname());
        ValueBindingSupportTest.assertEquals((Object)"moritz", (Object)this.target.getValue());
        this.valueBindingSupport.updateFromModel();
        ValueBindingSupportTest.assertEquals((String)"michel", (String)person.getFirstname());
        ValueBindingSupportTest.assertEquals((Object)"michel", (Object)this.target.getValue());
    }

    public void testRebindToModelNoPerfomanceDegratation() {
        ValueBindingSupportTest.assertNotNull((Object)this.target);
        ValueBindingSupportTest.assertNotNull((Object)this.model);
        ValueBindingSupport secondValueBindingSupport = new ValueBindingSupport(this.target, this.model);
        long start1 = System.currentTimeMillis();
        int i = 0;
        while (i < 100) {
            secondValueBindingSupport.rebindToModel();
            ++i;
        }
        long time1 = System.currentTimeMillis() - start1;
        long start2 = System.currentTimeMillis();
        int i2 = 0;
        while (i2 < 100) {
            secondValueBindingSupport.rebindToModel();
            ++i2;
        }
        long time2 = System.currentTimeMillis() - start2;
        String msg = String.format("1st iteration: %d, 2nd iteration: %d", time1, time2);
        ValueBindingSupportTest.assertTrue((String)msg, (time2 / 2L <= time1 ? 1 : 0) != 0);
    }

    public void testIsNestedProperty() {
        boolean ret = (Boolean)ReflectionUtils.invokeHidden((Object)this.valueBindingSupport, (String)"isNestedProperty", (Object[])new Object[]{""});
        ValueBindingSupportTest.assertFalse((boolean)ret);
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)this.valueBindingSupport, (String)"isNestedProperty", (Object[])new Object[]{"prop"});
        ValueBindingSupportTest.assertFalse((boolean)ret);
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)this.valueBindingSupport, (String)"isNestedProperty", (Object[])new Object[]{"prop1.prop2"});
        ValueBindingSupportTest.assertTrue((boolean)ret);
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)this.valueBindingSupport, (String)"isNestedProperty", (Object[])new Object[]{"."});
        ValueBindingSupportTest.assertTrue((boolean)ret);
    }

    private void assertMessageMarkers(String ... messages) {
        ArrayList<String> missingMessages = new ArrayList<String>(Arrays.asList(messages));
        for (IMessageMarker messageMarker : this.markable.getMarkersOfType(IMessageMarker.class)) {
            missingMessages.remove(messageMarker.getMessage());
        }
        ValueBindingSupportTest.assertTrue((String)("missing MessageMarker for " + missingMessages), (boolean)missingMessages.isEmpty());
    }

    public static Address createAddress(String str, String city, String zip, String cc) {
        Address result = new Address();
        result.setStreetAndNumber(str);
        result.setTown(city);
        result.setPostalCode(Integer.valueOf(zip).intValue());
        result.setCountry(cc);
        return result;
    }

    private static final class AlwaysWrongValidator
    implements IValidator {
        private AlwaysWrongValidator() {
        }

        public IStatus validate(Object value) {
            return ValidationRuleStatus.error((boolean)false, (String)"wrong");
        }
    }

    private static class EvenNumberOfCharacters
    implements IValidator {
        private EvenNumberOfCharacters() {
        }

        public IStatus validate(Object value) {
            if (value == null) {
                return ValidationRuleStatus.ok();
            }
            if (value instanceof String) {
                String string = (String)value;
                if (string.length() % 2 == 0) {
                    return ValidationRuleStatus.ok();
                }
                return ValidationRuleStatus.error((boolean)false, (String)"Odd number of characters.");
            }
            throw new ValidationFailure(String.valueOf(this.getClass().getName()) + " can only validate objects of type " + String.class.getName());
        }
    }

    private static class NotEndingWithDisaster
    implements IValidator {
        private NotEndingWithDisaster() {
        }

        public IStatus validate(Object value) {
            if (value == null) {
                return ValidationRuleStatus.ok();
            }
            if (value instanceof String) {
                String string = (String)value;
                if (!string.toLowerCase().endsWith("disaster")) {
                    return ValidationRuleStatus.ok();
                }
                return ValidationRuleStatus.error((boolean)false, (String)"It ends with disaster.");
            }
            throw new ValidationFailure(String.valueOf(this.getClass().getName()) + " can only validate objects of type " + String.class.getName());
        }
    }
}

