/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt;

import junit.framework.TestCase;
import org.eclipse.riena.core.test.collect.UITestCase;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.ui.swt.test.UITestHelper;
import org.eclipse.riena.ui.swt.DatePickerComposite;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

@UITestCase
public class DatePickerCompositeTest
extends TestCase {
    private Shell shell;
    private DatePickerComposite control;

    protected void setUp() throws Exception {
        super.setUp();
        this.shell = new Shell();
        this.control = new DatePickerComposite((Composite)this.shell, 0);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        SwtUtilities.dispose((Widget)this.shell);
    }

    public void testReopenAfterESC() {
        UITestHelper.fireSelectionEvent((Widget)this.getPickerButton());
        DatePickerCompositeTest.assertFalse((boolean)this.getPickerShell().isDisposed());
        DatePickerCompositeTest.assertTrue((boolean)this.getPicker().isVisible());
        this.getPickerShell().dispose();
        DatePickerCompositeTest.assertTrue((boolean)this.getPickerShell().isDisposed());
        UITestHelper.fireSelectionEvent((Widget)this.getPickerButton());
        DatePickerCompositeTest.assertFalse((boolean)this.getPickerShell().isDisposed());
        DatePickerCompositeTest.assertTrue((boolean)this.getPicker().isVisible());
    }

    public void testDisabledWidgetHasGrayBackground() {
        DatePickerCompositeTest.assertTrue((boolean)this.control.isEnabled());
        Color defaultBg = this.control.getBackground();
        Color disabledBg = this.control.getDisplay().getSystemColor(22);
        this.control.setEnabled(false);
        DatePickerCompositeTest.assertEquals((Object)disabledBg, (Object)this.control.getBackground());
        DatePickerCompositeTest.assertEquals((Object)disabledBg, (Object)this.control.getTextfield().getBackground());
        this.control.setEnabled(true);
        DatePickerCompositeTest.assertEquals((Object)defaultBg, (Object)this.control.getBackground());
        DatePickerCompositeTest.assertEquals((Object)defaultBg, (Object)this.control.getTextfield().getBackground());
    }

    public void testSetBackgroundColorWhileDisabled() {
        Display display = this.control.getDisplay();
        Color disabledBg = display.getSystemColor(22);
        Color red = display.getSystemColor(3);
        this.control.setEnabled(false);
        this.control.setBackground(red);
        DatePickerCompositeTest.assertEquals((Object)disabledBg, (Object)this.control.getBackground());
        DatePickerCompositeTest.assertEquals((Object)disabledBg, (Object)this.control.getTextfield().getBackground());
        this.control.setEnabled(true);
        DatePickerCompositeTest.assertEquals((Object)red, (Object)this.control.getBackground());
        DatePickerCompositeTest.assertEquals((Object)red, (Object)this.control.getTextfield().getBackground());
    }

    private DatePickerComposite.DatePicker getPicker() {
        return (DatePickerComposite.DatePicker)ReflectionUtils.getHidden((Object)this.control, (String)"datePicker");
    }

    private Shell getPickerShell() {
        return (Shell)ReflectionUtils.getHidden((Object)this.getPicker(), (String)"shell");
    }

    private Button getPickerButton() {
        return (Button)ReflectionUtils.getHidden((Object)this.control, (String)"pickerButton");
    }
}

