/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.swt.facades;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.internal.workbench.Activator;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.IWorkbench;
import org.eclipse.riena.core.wire.InjectExtension;
import org.eclipse.riena.core.wire.Wire;
import org.eclipse.riena.internal.ui.swt.facades.ISourceProviderExtension;
import org.eclipse.riena.internal.ui.swt.facades.WorkbenchFacade;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISourceProvider;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.osgi.framework.BundleContext;

public class WorkbenchFacadeImpl
extends WorkbenchFacade {
    private static final String EXT_ID_SERVICES = "org.eclipse.ui.services";
    private static List<ISourceProvider> providers;

    public WorkbenchFacadeImpl() {
        if (providers == null) {
            Wire.instance((Object)((Object)this)).andStart();
        }
    }

    @InjectExtension(id="org.eclipse.ui.services", onceOnly=true)
    public static void updateServiceProviders(ISourceProviderExtension[] extensions) {
        providers = new LinkedList<ISourceProvider>();
        ISourceProviderExtension[] iSourceProviderExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            ISourceProviderExtension extension = iSourceProviderExtensionArray[n2];
            ISourceProvider provider = extension.getSourceProvider();
            if (provider != null) {
                providers.add(provider);
            }
            ++n2;
        }
    }

    public void showView(IWorkbenchPage page, IViewReference viewRef) {
    }

    public Shell getActiveShell() {
        IEclipseContext root = this.getWorkbenchContext();
        return root == null ? null : (Shell)root.get("activeShell");
    }

    public boolean closeWorkbench() {
        IEclipseContext root = this.getWorkbenchContext();
        return root == null ? false : ((IWorkbench)root.get(IWorkbench.class)).close();
    }

    public Shell getActiveWindowShell() {
        IEclipseContext root = this.getWorkbenchContext();
        if (root == null) {
            return null;
        }
        MPart part = (MPart)root.get("e4ActivePart");
        return part == null ? null : ((Control)part.getWidget()).getShell();
    }

    private IEclipseContext getWorkbenchContext() {
        Activator plugin = Activator.getDefault();
        if (plugin == null) {
            return null;
        }
        IEclipseContext serviceContext = EclipseContextFactory.getServiceContext((BundleContext)plugin.getContext());
        return serviceContext.getActiveLeaf();
    }

    public Display getWorkbenchDisplay() {
        Shell activeWindowShell = this.getActiveWindowShell();
        return activeWindowShell == null ? null : activeWindowShell.getDisplay();
    }

    public ISourceProvider[] getSourceProviders() {
        if (providers == null) {
            return new ISourceProvider[0];
        }
        return providers.toArray(new ISourceProvider[providers.size()]);
    }
}

