/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.util.Util;
import org.eclipse.riena.ui.swt.EventForwarder;
import org.eclipse.riena.ui.swt.facades.SWTFacade;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class DatePickerComposite
extends Composite {
    private static final int BUTTON_WIDTH = 16;
    private static final int BUTTON_HEIGHT = 16;
    private final Text textfield;
    private final Button pickerButton;
    private Color bgColor;
    private DatePicker datePicker;
    private IDateConverterStrategy dateConverterStrategy;

    public DatePickerComposite(Composite parent, int textStyles) {
        super(parent, 2048);
        GridLayoutFactory.fillDefaults().numColumns(2).spacing(0, 0).applyTo((Composite)this);
        this.textfield = new Text((Composite)this, this.checkStyle(textStyles));
        this.setBackground(LnfManager.getLnf().getColor("SubModule.background"));
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)this.textfield);
        new EventForwarder((Control)this.textfield, (Control)this);
        this.pickerButton = new Button((Composite)this, 1028);
        GridDataFactory.fillDefaults().grab(false, false).align(131072, 4).hint(16, 16).applyTo((Control)this.pickerButton);
        this.pickerButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatePickerComposite.this.handleClick();
            }
        });
        this.dateConverterStrategy = new RegexDateConverterStrategy(this.textfield);
    }

    public void dispose() {
        if (this.datePicker != null) {
            this.datePicker.dispose();
        }
        super.dispose();
    }

    public IDateConverterStrategy getDateConverterStrategy() {
        return this.dateConverterStrategy;
    }

    public Text getTextfield() {
        return this.textfield;
    }

    public void setDateConverterStrategy(IDateConverterStrategy dateConverterStrategy) {
        this.dateConverterStrategy = dateConverterStrategy;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.updateButtonEnablement();
        this.updateBgColor(enabled);
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.textfield.setForeground(color);
    }

    public void setBackground(Color color) {
        this.bgColor = color;
        this.updateBgColor(this.isEnabled());
    }

    public void setToolTipText(String string) {
        super.setToolTipText(string);
        this.textfield.setToolTipText(string);
    }

    public void updateButtonEnablement() {
        if (!this.isDisposed()) {
            boolean enabledButton = this.getEnabled() && this.textfield.getEditable();
            this.pickerButton.setEnabled(enabledButton);
        }
    }

    private int checkStyle(int style) {
        if ((style & 0x800) != 0) {
            style &= 0xFFFFF7FF;
        }
        return style;
    }

    private void handleClick() {
        if (!this.textfield.isEnabled() || !this.textfield.getEditable()) {
            return;
        }
        if (this.datePicker == null || this.datePicker.isDisposed()) {
            this.datePicker = new DatePicker(this);
        }
        if (!this.datePicker.isVisible()) {
            Point p = this.textfield.toDisplay(this.textfield.getLocation().x, this.textfield.getLocation().y);
            this.datePicker.setLocation(p.x, p.y + this.textfield.getBounds().height);
            this.datePicker.open(this.parseDate(this.textfield.getText()));
        } else {
            this.datePicker.close();
        }
    }

    private Button getPickerButton() {
        return this.pickerButton;
    }

    private Calendar parseDate(String dateString) {
        Calendar result = null;
        Date date = this.getDateConverterStrategy().getDateFromTextField(dateString);
        if (date != null) {
            result = Calendar.getInstance();
            result.setTime(date);
        }
        return result;
    }

    private void updateBgColor(boolean isEnabled) {
        Color color = isEnabled ? this.bgColor : this.getDisplay().getSystemColor(22);
        super.setBackground(color);
        this.textfield.setBackground(color);
    }

    public static final class DatePicker {
        private Shell shell;
        private DateTime calendar;
        private DatePickerComposite datePicker;
        private int clicksToClose = 1;

        protected DatePicker(final DatePickerComposite datePicker) {
            this.datePicker = datePicker;
            this.shell = new Shell(datePicker.getShell(), 16392);
            this.shell.setBackground(this.shell.getDisplay().getSystemColor(2));
            GridLayoutFactory.fillDefaults().margins(1, 1).applyTo((Composite)this.shell);
            this.calendar = new DateTime((Composite)this.shell, 33792);
            this.calendar.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
            this.shell.pack();
            this.calendar.addMouseListener((MouseListener)new MouseAdapter(){
                private final IZoneFinder zoneFinder;
                {
                    this.zoneFinder = DatePicker.this.createZoneFinder(DatePicker.this.calendar);
                }

                public void mouseUp(MouseEvent e) {
                    if (e.button != 1) {
                        return;
                    }
                    if (this.zoneFinder.getZone() == 0) {
                        DatePicker.this.clicksToClose = Math.max(DatePicker.this.clicksToClose - 1, 0);
                    } else if (this.zoneFinder.getZone() == 2) {
                        DatePicker.this.clicksToClose = Math.min(4, DatePicker.this.clicksToClose + 1);
                    }
                    if (DatePicker.this.clicksToClose == 0) {
                        DatePicker.this.setDateToTextfield();
                        DatePicker.this.clicksToClose = 1;
                        DatePicker.this.close();
                    }
                }
            });
            this.calendar.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (e.character == '\r') {
                        DatePicker.this.clicksToClose = Math.max(DatePicker.this.clicksToClose - 1, 0);
                        if (DatePicker.this.clicksToClose == 0) {
                            DatePicker.this.setDateToTextfield();
                            DatePicker.this.clicksToClose = 1;
                            DatePicker.this.close();
                        }
                    }
                }
            });
            this.calendar.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    Display display = e.widget.getDisplay();
                    Control focusControl = display.getCursorControl();
                    if (focusControl != datePicker.getPickerButton()) {
                        DatePicker.this.close();
                    }
                }
            });
        }

        public void dispose() {
            if (!SwtUtilities.isDisposed((Widget)this.shell)) {
                this.shell.dispose();
            }
        }

        public void setLocation(int x, int y) {
            this.shell.setLocation(x, y);
        }

        public boolean isDisposed() {
            return this.shell == null || this.shell.isDisposed();
        }

        public boolean isVisible() {
            return this.shell.isVisible();
        }

        public void close() {
            this.shell.setVisible(false);
        }

        public void open(Calendar newDate) {
            if (this.isVisible()) {
                return;
            }
            this.shell.open();
            this.shell.setVisible(true);
            if (newDate == null) {
                newDate = Calendar.getInstance();
                newDate.setTime(new Date());
            }
            this.calendar.setYear(newDate.get(1));
            this.calendar.setMonth(newDate.get(2));
            this.calendar.setDay(newDate.get(5));
        }

        private IZoneFinder createZoneFinder(DateTime parent) {
            IZoneFinder result = this.isVistaOrLater() ? new VistaZoneFinder(parent) : (Util.isWin32() ? new XPZoneFinder(parent) : (Util.isMac() ? new MacZoneFinder(parent) : new DefaultZoneFinder()));
            return result;
        }

        private boolean isVistaOrLater() {
            boolean result = false;
            if (Util.isWin32()) {
                String osVer = System.getProperty("os.version");
                try {
                    double version = Double.valueOf(osVer);
                    result = version >= 6.0;
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (NullPointerException nullPointerException) {}
            }
            return result;
        }

        private void setDateToTextfield() {
            Calendar cal = Calendar.getInstance();
            cal.set(1, this.calendar.getYear());
            cal.set(2, this.calendar.getMonth());
            cal.set(5, this.calendar.getDay());
            this.datePicker.getDateConverterStrategy().setDateToTextField(cal.getTime());
        }
    }

    private static final class DefaultZoneFinder
    implements IZoneFinder {
        private DefaultZoneFinder() {
        }

        public void mouseMove(MouseEvent e) {
        }

        @Override
        public int getZone() {
            return 0;
        }
    }

    public static interface IDateConverterStrategy {
        public void setDateToTextField(Date var1);

        public Date getDateFromTextField(String var1);
    }

    private static interface IZoneFinder
    extends MouseMoveListener {
        public static final int BODY = 0;
        public static final int HEADER = 1;
        public static final int ZOOM_OUT = 2;

        public int getZone();
    }

    private static final class MacZoneFinder
    implements IZoneFinder {
        final int headerHeight = 40;
        private int zone = 0;

        public MacZoneFinder(DateTime parent) {
            SWTFacade.getDefault().addMouseMoveListener((Control)parent, this);
        }

        public void mouseMove(MouseEvent e) {
            this.zone = e.y < 40 ? 1 : 0;
        }

        @Override
        public int getZone() {
            return this.zone;
        }
    }

    private static class RegexDateConverterStrategy
    implements IDateConverterStrategy {
        private final Text textfield;

        public RegexDateConverterStrategy(Text textfield) {
            this.textfield = textfield;
        }

        @Override
        public void setDateToTextField(Date date) {
            String dateString = new SimpleDateFormat("dd.MM.yyyy").format(date);
            String oldText = this.textfield.getText();
            if (oldText.contains(":")) {
                Pattern pattern = Pattern.compile("([ \\d\\.]+)\\s+(.*?:.*?)");
                Matcher matcher = pattern.matcher(oldText);
                if (matcher.matches()) {
                    String oldTime = matcher.group(2);
                    this.textfield.setText(String.valueOf(dateString) + " " + oldTime);
                }
            } else {
                this.textfield.setText(dateString);
            }
            this.textfield.setFocus();
        }

        @Override
        public Date getDateFromTextField(String dateString) {
            Calendar result = null;
            Pattern pattern = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+).*?");
            Matcher matcher = pattern.matcher(dateString);
            if (matcher.matches() && matcher.groupCount() == 3) {
                int month = Integer.parseInt(matcher.group(2));
                --month;
                int year = Integer.parseInt(matcher.group(3));
                if (year < 100) {
                    year += 1900;
                }
                result = Calendar.getInstance();
                result.set(5, Integer.parseInt(matcher.group(1)));
                result.set(2, month);
                result.set(1, year);
                return result.getTime();
            }
            return null;
        }
    }

    private static final class VistaZoneFinder
    implements IZoneFinder {
        final int headerHeight = 48;
        final int topDeadZone = 4;
        final int bottomDeadZone = 16;
        final int buttonTop = 9;
        final int buttonBottom = 26;
        final int headerLeft = 20;
        final int headerRight = 204;
        private int zone = 0;

        public VistaZoneFinder(DateTime parent) {
            SWTFacade.getDefault().addMouseMoveListener((Control)parent, this);
        }

        public void mouseMove(MouseEvent e) {
            this.zone = e.y < 48 ? (e.y > 32 || e.y < 4 ? 1 : (e.x < 20 && e.y > 9 && e.y < 26 || e.x > 204 && e.y > 9 && e.y < 26 ? 1 : 2)) : 0;
        }

        @Override
        public int getZone() {
            return this.zone;
        }
    }

    private static final class XPZoneFinder
    implements IZoneFinder {
        final int headerHeight = 45;
        private int zone = 0;

        public XPZoneFinder(DateTime parent) {
            SWTFacade.getDefault().addMouseMoveListener((Control)parent, this);
        }

        public void mouseMove(MouseEvent e) {
            this.zone = e.y < 45 ? 1 : 0;
        }

        @Override
        public int getZone() {
            return this.zone;
        }
    }
}

