/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.internal;

import java.util.List;
import java.util.SortedSet;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ListProperty;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.services.PossibleValuesService;
import org.eclipse.sapphire.services.Service;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.services.ServiceFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ValueFromListPossibleValuesService
extends PossibleValuesService {
    private PossibleValuesService base;
    private Listener listener;
    private boolean broadcasting;

    @Override
    protected void init() {
        super.init();
        IModelElement element = this.context(IModelElement.class);
        ListProperty parentProperty = (ListProperty)element.getParentProperty();
        IModelElement parentElement = (IModelElement)element.parent().parent();
        this.base = parentElement.service(parentProperty, PossibleValuesService.class);
        this.listener = new Listener(){

            public void handle(Event event) {
                if (!ValueFromListPossibleValuesService.this.broadcasting) {
                    try {
                        ValueFromListPossibleValuesService.this.broadcasting = true;
                        ValueFromListPossibleValuesService.this.broadcast();
                    }
                    finally {
                        ValueFromListPossibleValuesService.this.broadcasting = false;
                    }
                }
            }
        };
        this.base.attach(this.listener);
    }

    @Override
    protected void fillPossibleValues(SortedSet<String> values) {
        values.addAll(this.base.values());
    }

    @Override
    public Status.Severity getInvalidValueSeverity(String invalidValue) {
        return this.base.getInvalidValueSeverity(invalidValue);
    }

    @Override
    public String getInvalidValueMessage(String invalidValue) {
        return this.base.getInvalidValueMessage(invalidValue);
    }

    @Override
    public boolean isCaseSensitive() {
        return this.base.isCaseSensitive();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.listener != null) {
            this.base.detach(this.listener);
            this.listener = null;
        }
        this.base = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Factory
    extends ServiceFactory {
        @Override
        public boolean applicable(ServiceContext context, Class<? extends Service> service) {
            IModelElement parentElement;
            IModelElement element;
            ModelProperty parentProperty;
            ModelElementType type;
            List<ModelProperty> properties;
            ValueProperty property = context.find(ValueProperty.class);
            return property != null && (properties = (type = property.getModelElementType()).properties()).size() == 1 && (parentProperty = (element = context.find(IModelElement.class)).getParentProperty()) instanceof ListProperty && (parentElement = (IModelElement)element.parent().parent()).service(parentProperty, PossibleValuesService.class) != null;
        }

        @Override
        public Service create(ServiceContext context, Class<? extends Service> service) {
            return new ValueFromListPossibleValuesService();
        }
    }
}

