/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.internal;

import java.util.SortedSet;
import org.eclipse.sapphire.Version;
import org.eclipse.sapphire.VersionConstraint;
import org.eclipse.sapphire.internal.DeclarativeVersionCompatibilityService;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.util.NLS;
import org.eclipse.sapphire.services.FactsService;
import org.eclipse.sapphire.services.Service;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.services.ServiceFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class VersionCompatibilityFactsService
extends FactsService {
    @Override
    protected void facts(SortedSet<String> facts) {
        ModelProperty property;
        IModelElement element = this.context(IModelElement.class);
        DeclarativeVersionCompatibilityService service = VersionCompatibilityFactsService.findDeclarativeVersionCompatibilityService(element, property = this.context(ModelProperty.class));
        if (service != null) {
            String versioned = service.versioned();
            VersionConstraint constraint = service.constraint();
            if (versioned != null && constraint != null) {
                Version since = null;
                if (constraint.ranges().size() == 1) {
                    VersionConstraint.Range range = constraint.ranges().get(0);
                    VersionConstraint.Range.Limit min = range.min();
                    VersionConstraint.Range.Limit max = range.max();
                    if (min != null && min.inclusive() && max == null) {
                        since = min.version();
                    }
                }
                if (since != null) {
                    facts.add(NLS.bind(Resources.sinceVersionFact, versioned, since));
                } else {
                    facts.add(NLS.bind(Resources.forVersionsFact, versioned, constraint));
                }
            }
        }
    }

    private static DeclarativeVersionCompatibilityService findDeclarativeVersionCompatibilityService(IModelElement element, ModelProperty property) {
        ModelProperty parentProperty;
        DeclarativeVersionCompatibilityService service = element.service(property, DeclarativeVersionCompatibilityService.class);
        if (service == null && (parentProperty = element.getParentProperty()) != null) {
            IModelParticle parent = element.parent();
            if (!(parent instanceof IModelElement)) {
                parent = parent.parent();
            }
            IModelElement parentElement = (IModelElement)parent;
            service = VersionCompatibilityFactsService.findDeclarativeVersionCompatibilityService(parentElement, parentProperty);
        }
        return service;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Factory
    extends ServiceFactory {
        @Override
        public boolean applicable(ServiceContext context, Class<? extends Service> service) {
            ModelProperty property;
            IModelElement element = context.find(IModelElement.class);
            return VersionCompatibilityFactsService.findDeclarativeVersionCompatibilityService(element, property = context.find(ModelProperty.class)) != null;
        }

        @Override
        public Service create(ServiceContext context, Class<? extends Service> service) {
            return new VersionCompatibilityFactsService();
        }
    }

    private static final class Resources
    extends NLS {
        public static String forVersionsFact;
        public static String sinceVersionFact;

        static {
            Resources.initializeMessages(VersionCompatibilityFactsService.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

