/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.el;

import java.util.List;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.el.Literal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InstanceOfFunction
extends Function {
    public static InstanceOfFunction create(List<Function> operands) {
        InstanceOfFunction function = new InstanceOfFunction();
        function.init(operands);
        return function;
    }

    public static InstanceOfFunction create(Function a, Function b) {
        InstanceOfFunction function = new InstanceOfFunction();
        function.init(a, b);
        return function;
    }

    public static InstanceOfFunction create(Function a, String b) {
        return InstanceOfFunction.create(a, Literal.create(b));
    }

    @Override
    public String name() {
        return "InstanceOf";
    }

    @Override
    public FunctionResult evaluate(FunctionContext context) {
        return new FunctionResult(this, context){

            @Override
            protected Object evaluate() {
                String type;
                Object obj = this.operand(0).value();
                if (obj == null) {
                    return Boolean.FALSE;
                }
                if (obj instanceof Value) {
                    obj = ((Value)obj).getContent();
                }
                if ((type = this.cast(this.operand(1).value(), String.class)) == null) {
                    return Boolean.FALSE;
                }
                return this.evaluate(obj.getClass(), type);
            }

            private boolean evaluate(Class<?> cl, String type) {
                if (cl.getName().equals(type)) {
                    return true;
                }
                Class<?> base = cl.getSuperclass();
                if (base != null && this.evaluate(base, type)) {
                    return true;
                }
                Class<?>[] classArray = cl.getInterfaces();
                int n = classArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?> ifc = classArray[n2];
                    if (this.evaluate(ifc, type)) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
        };
    }
}

