/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services.internal;

import java.util.List;
import java.util.SortedSet;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.DocumentationMergeStrategy;
import org.eclipse.sapphire.modeling.localization.LocalizationService;
import org.eclipse.sapphire.services.DocumentationService;
import org.eclipse.sapphire.services.FactsAggregationService;
import org.eclipse.sapphire.services.Service;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.services.ServiceFactory;
import org.eclipse.sapphire.services.internal.StandardDocumentationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StandardPropertyDocumentationService
extends StandardDocumentationService {
    @Override
    protected void initStandardDocumentationService(StringBuilder content, List<DocumentationService.Topic> topics) {
        IModelElement element = this.context(IModelElement.class);
        ModelProperty property = this.context(ModelProperty.class);
        StandardPropertyDocumentationService.init(property, content, topics);
        SortedSet<String> facts = element.service(property, FactsAggregationService.class).facts();
        if (!facts.isEmpty()) {
            if (content.length() > 0) {
                content.append("[pbr/]");
            }
            boolean first = true;
            for (String item : facts) {
                if (first) {
                    first = false;
                } else {
                    content.append("[br/]");
                }
                content.append(item);
            }
        }
    }

    private static void init(ModelProperty property, StringBuilder content, List<DocumentationService.Topic> topics) {
        if (property == null) {
            return;
        }
        Documentation docAnnotation = property.getAnnotation(Documentation.class);
        if (docAnnotation == null || docAnnotation.mergeStrategy() != DocumentationMergeStrategy.REPLACE) {
            StandardPropertyDocumentationService.init(property.getBase(), content, topics);
        }
        if (docAnnotation != null) {
            List<DocumentationService.Topic> docAnnotationTopics;
            LocalizationService localization = property.getLocalizationService();
            DocumentationMergeStrategy docMergeStrategy = docAnnotation.mergeStrategy();
            String docAnnotationContent = localization.text(docAnnotation.content().trim(), CapitalizationType.NO_CAPS, false);
            if (docAnnotationContent.length() > 0) {
                if (docMergeStrategy == DocumentationMergeStrategy.REPLACE || content.length() == 0) {
                    content.append(docAnnotationContent);
                } else if (docMergeStrategy == DocumentationMergeStrategy.APPEND) {
                    content.append("[pbr/]");
                    content.append(docAnnotationContent);
                } else {
                    content.insert(0, "[pbr/]");
                    content.insert(0, docAnnotationContent);
                }
            }
            if (!(docAnnotationTopics = StandardPropertyDocumentationService.convert(docAnnotation.topics(), localization)).isEmpty()) {
                if (docMergeStrategy != DocumentationMergeStrategy.PREPEND || topics.isEmpty()) {
                    topics.addAll(docAnnotationTopics);
                } else {
                    topics.addAll(0, docAnnotationTopics);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Factory
    extends ServiceFactory {
        @Override
        public boolean applicable(ServiceContext context, Class<? extends Service> service) {
            ModelProperty property;
            IModelElement element = context.find(IModelElement.class);
            ModelProperty p = property = context.find(ModelProperty.class);
            while (p != null) {
                if (p.hasAnnotation(Documentation.class)) {
                    return true;
                }
                p = p.getBase();
            }
            return !element.service(property, FactsAggregationService.class).facts().isEmpty();
        }

        @Override
        public Service create(ServiceContext context, Class<? extends Service> service) {
            return new StandardPropertyDocumentationService();
        }
    }
}

