/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons;

import java.lang.reflect.Array;
import java.sql.Timestamp;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;

public final class CompareUtility {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(CompareUtility.class);

    private CompareUtility() {
    }

    public static <T> boolean equals(T a, T b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null) {
            return false;
        }
        if (b == null) {
            return false;
        }
        if (a instanceof Timestamp && !(b instanceof Timestamp)) {
            return b.equals(a);
        }
        if (a.equals(b)) {
            return true;
        }
        if (a.getClass().isArray() && b.getClass().isArray()) {
            int nb;
            int na = Array.getLength(a);
            if (na != (nb = Array.getLength(b))) {
                return false;
            }
            int i = 0;
            while (i < na) {
                if (!CompareUtility.equals(Array.get(a, i), Array.get(b, i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static <T> boolean notEquals(T a, T b) {
        return !CompareUtility.equals(a, b);
    }

    public static <T extends Comparable<T>> int compareTo(T a, T b) {
        if (a == null && b == null) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        return a.compareTo(b);
    }

    public static boolean isOneOf(Object o, Object ... elements) {
        if (elements == null || elements.length == 0) {
            return false;
        }
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object e = objectArray[n2];
            if (CompareUtility.equals(o, e)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

