/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Platform;
import org.eclipse.scout.commons.BundleContextUtility;
import org.eclipse.scout.commons.ConfigIniProperty;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;

public final class ConfigIniUtility {
    private static final Pattern CONFIG_LINE_PATTERN = Pattern.compile("([^#/]+)(/[^#]+)?\\#([^=]+)=(.*)");
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(ConfigIniUtility.class);
    private static ConfigIniProperty[] configProperties;

    static {
        ArrayList<ConfigIniProperty> parsingList = new ArrayList<ConfigIniProperty>();
        ArrayList<String> externalConfigPaths = new ArrayList<String>();
        ConfigIniUtility.parseLocalConfigIniFile(parsingList, externalConfigPaths);
        ConfigIniUtility.parseExternalConfigIniFiles(parsingList, externalConfigPaths);
        configProperties = parsingList.toArray(new ConfigIniProperty[parsingList.size()]);
        if (LOG.isInfoEnabled()) {
            LOG.info("Config Bean Properties");
            ConfigIniProperty[] configIniPropertyArray = configProperties;
            int n = configProperties.length;
            int n2 = 0;
            while (n2 < n) {
                ConfigIniProperty p = configIniPropertyArray[n2];
                LOG.info(" " + p.getBeanName() + "#" + p.getPropertyName() + (p.getFilter() != null ? "/" + p.getFilter() : "") + "=" + p.getValue());
                ++n2;
            }
        }
    }

    private ConfigIniUtility() {
    }

    public static Map<String, String> getProperties(Class beanType) {
        return ConfigIniUtility.getProperties(beanType, null);
    }

    public static Map<String, String> getProperties(Class beanType, String filter) {
        HashMap<String, String> props = new HashMap<String, String>();
        ConfigIniProperty[] configIniPropertyArray = configProperties;
        int n = configProperties.length;
        int n2 = 0;
        while (n2 < n) {
            ConfigIniProperty p = configIniPropertyArray[n2];
            if (ConfigIniUtility.matchesBeanClass(p, beanType, filter)) {
                String v = p.getValue();
                if (v != null && v.length() == 0) {
                    v = null;
                }
                props.put(p.getPropertyName(), v);
            }
            ++n2;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("Properties for " + beanType.getName());
            for (Map.Entry e : props.entrySet()) {
                LOG.info(" " + (String)e.getKey() + "=" + (String)e.getValue());
            }
        }
        return props;
    }

    private static void parseLocalConfigIniFile(List<ConfigIniProperty> parsingList, List<String> externalConfigPaths) {
        block18: {
            String file = "config.ini";
            BufferedReader in = null;
            try {
                try {
                    String line;
                    URL url = null;
                    if (Platform.inDevelopmentMode()) {
                        url = new URL(Platform.getConfigurationLocation().getURL(), file);
                    } else {
                        URL installLocationUrl = Platform.getInstallLocation().getURL();
                        url = new URL(installLocationUrl, "configuration/" + file);
                    }
                    in = new BufferedReader(new InputStreamReader(url.openStream(), "UTF-8"));
                    while ((line = in.readLine()) != null) {
                        ConfigIniProperty p = ConfigIniUtility.parseConfigIniLine(line);
                        if (p != null) {
                            parsingList.add(p);
                        }
                        if (line.matches("external.configuration.area(\\.[0-9]+)?=.*")) {
                            externalConfigPaths.add(line.split("=", 2)[1]);
                        }
                        if (!line.matches("osgi.sharedConfiguration.area=.*")) continue;
                        externalConfigPaths.add(line.split("=", 2)[1]);
                    }
                }
                catch (Throwable t) {
                    if (in != null) {
                        LOG.error("parsing " + file, t);
                    }
                    if (in == null) break block18;
                    try {
                        in.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
    }

    private static void parseExternalConfigIniFiles(List<ConfigIniProperty> parsingList, List<String> externalConfigPaths) {
        for (String path : externalConfigPaths) {
            URL url;
            String resolvedPath;
            BufferedReader in;
            block19: {
                in = null;
                resolvedPath = null;
                url = null;
                resolvedPath = path.replaceAll("\\\\(.)", "$1");
                if (resolvedPath.matches("\\$\\{.*\\}.*")) {
                    String tail = resolvedPath.replaceAll("\\$\\{.*\\}", "");
                    String variable = resolvedPath.replaceAll(tail, "");
                    resolvedPath = System.getProperty(variable = variable.substring(2, variable.length() - 1), null);
                    if (resolvedPath == null) {
                        resolvedPath = System.getenv(variable);
                    }
                    resolvedPath = String.valueOf(resolvedPath) + tail;
                }
                if (resolvedPath != null) break block19;
                if (in == null) continue;
                try {
                    in.close();
                }
                catch (Throwable throwable) {}
                continue;
            }
            try {
                try {
                    String line;
                    resolvedPath = resolvedPath.replace("@user.home", System.getProperty("user.home"));
                    resolvedPath = resolvedPath.replace("@user.dir", System.getProperty("user.dir"));
                    File f1 = new File(resolvedPath);
                    url = f1.exists() ? (f1.isFile() ? f1.toURI().toURL() : new File(resolvedPath, "config.ini").toURI().toURL()) : (resolvedPath.toLowerCase().endsWith(".ini") || resolvedPath.toLowerCase().endsWith(".properties") ? new URL(resolvedPath) : new URL(new URL(resolvedPath), "config.ini"));
                    in = new BufferedReader(new InputStreamReader(url.openStream(), "UTF-8"));
                    while ((line = in.readLine()) != null) {
                        ConfigIniProperty p = ConfigIniUtility.parseConfigIniLine(line);
                        if (p == null) continue;
                        parsingList.add(p);
                    }
                }
                catch (Throwable t) {
                    if (in != null) {
                        LOG.error("parsing external file " + path + " (" + resolvedPath + ")", t);
                    }
                    if (in == null) continue;
                    try {
                        in.close();
                    }
                    catch (Throwable throwable) {}
                    continue;
                }
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable2) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            if (in == null) continue;
            try {
                in.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static ConfigIniProperty parseConfigIniLine(String configLine) {
        Matcher m;
        if (configLine != null && (m = CONFIG_LINE_PATTERN.matcher(configLine = configLine.replaceAll("\\\\(.)", "$1"))).matches()) {
            String filter = m.group(2);
            if (filter == null || !filter.startsWith("/")) {
                filter = null;
            }
            ConfigIniProperty p = new ConfigIniProperty(m.group(1), filter, m.group(3), BundleContextUtility.resolve(m.group(4)));
            return p;
        }
        return null;
    }

    private static boolean matchesBeanClass(ConfigIniProperty p, Class parameterType, String filter) {
        try {
            Class<?> myType = Class.forName(p.getBeanName(), false, parameterType.getClassLoader());
            if (myType.isAssignableFrom(parameterType) && (filter == null || p.getFilter() == null || filter.equals(p.getFilter()))) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }
}

