/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.scout.commons.CollectionUtility;

public final class ListUtility {
    private ListUtility() {
    }

    public static List<Object> toList(Object ... array) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (array != null) {
            Object[] objectArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                list.add(o);
                ++n2;
            }
        }
        return list;
    }

    public static Object[] toArray(Object ... array) {
        return array;
    }

    public static <T> T[] copyArray(T[] a) {
        Object[] copy = (Object[])Array.newInstance(a.getClass().getComponentType(), a.length);
        System.arraycopy(a, 0, copy, 0, a.length);
        return copy;
    }

    public static <T> boolean containsAny(Collection<T> list, Collection<T> values) {
        if (list != null) {
            for (T o : values) {
                if (!list.contains(o)) continue;
                return true;
            }
        }
        return false;
    }

    public static <T> boolean containsAny(Collection<T> list, T ... values) {
        if (list != null) {
            T[] TArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                T o = TArray[n2];
                if (list.contains(o)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static <T> String format(Collection<T> list, String delimiter) {
        if (list == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        int index = 0;
        for (T o : list) {
            if (index > 0) {
                buf.append(delimiter);
            }
            buf.append("" + o);
            ++index;
        }
        return buf.toString();
    }

    public static String format(Collection<?> list) {
        return ListUtility.format(list, false);
    }

    public static <T> String format(Collection<T> c, boolean quoteStrings) {
        StringBuffer buf = new StringBuffer();
        if (c != null) {
            int index = 0;
            for (T o : c) {
                if (index > 0) {
                    buf.append(", ");
                }
                String s = o instanceof Number ? o.toString() : (quoteStrings ? "'" + ("" + o).replaceAll(",", "%2C") + "'" : "" + o);
                buf.append(s);
                ++index;
            }
        }
        return buf.toString();
    }

    public static List<Object> parse(String text) {
        List list = null;
        if (text != null && text.trim().length() > 0) {
            String[] a;
            String[] stringArray = a = text.split(",");
            int n = a.length;
            int n2 = 0;
            while (n2 < n) {
                Object o;
                String s = stringArray[n2];
                if ((s = s.replaceAll("%2C", ",")).equalsIgnoreCase("null")) {
                    o = null;
                } else if (s.length() >= 2 && s.startsWith("'") && s.endsWith("'")) {
                    o = s.substring(1, s.length() - 2);
                } else if (s.length() >= 2 && s.startsWith("\"") && s.endsWith("\"")) {
                    o = s.substring(1, s.length() - 2);
                } else if (s.indexOf(".") >= 0) {
                    try {
                        o = new Double(Double.parseDouble(s));
                    }
                    catch (Exception e) {
                        o = s;
                    }
                } else {
                    try {
                        o = new Long(Long.parseLong(s));
                    }
                    catch (Exception e) {
                        o = s;
                    }
                }
                list = CollectionUtility.appendList(list, o);
                ++n2;
            }
        }
        return CollectionUtility.copyList(list);
    }

    public static <T> List<T> combine(Collection<T> ... collections) {
        List list = null;
        if (collections != null && collections.length > 0) {
            Collection<T>[] collectionArray = collections;
            int n = collections.length;
            int n2 = 0;
            while (n2 < n) {
                Collection<T> c = collectionArray[n2];
                for (T t : c) {
                    list = CollectionUtility.appendList(list, t);
                }
                ++n2;
            }
        }
        return CollectionUtility.copyList(list);
    }

    public static <T> boolean isAmbiguous(Collection<T> c) {
        return !ListUtility.isDistinct(c);
    }

    public static <T> boolean isDistinct(Collection<T> c) {
        HashSet<T> set = new HashSet<T>(c);
        return set.size() == c.size();
    }

    public static <T> T getUnique(T ... n) {
        if (n == null || n.length == 0) {
            return null;
        }
        Object retVal = null;
        int i = 0;
        while (i < n.length) {
            if (n[i] != null) {
                if (retVal == null) {
                    retVal = n[i];
                } else if (!retVal.equals(n[i])) {
                    return null;
                }
            }
            ++i;
        }
        return (T)retVal;
    }

    public static int length(Object array) {
        if (array == null) {
            return -1;
        }
        if (array.getClass().isArray()) {
            return Array.getLength(array);
        }
        if (array instanceof Collection) {
            return ((Collection)array).size();
        }
        if (array instanceof Map) {
            return ((Map)array).size();
        }
        throw new IllegalArgumentException("expected one of: null, array, collection, map");
    }
}

