/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;

public final class UriUtility {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(UriUtility.class);
    public static final String ISO_8859_1 = "ISO-8859-1";

    private UriUtility() {
    }

    public static Map<String, String> getQueryParameters(URL url) throws ProcessingException {
        return UriUtility.getQueryParameters(url, null);
    }

    public static Map<String, String> getQueryParameters(URL url, String encoding) throws ProcessingException {
        if (url == null) {
            return Collections.emptyMap();
        }
        return UriUtility.getQueryParameters(UriUtility.urlToUri(url), encoding);
    }

    public static Map<String, String> getQueryParameters(URI uri) throws ProcessingException {
        return UriUtility.getQueryParameters(uri, null);
    }

    public static Map<String, String> getQueryParameters(URI uri, String encoding) throws ProcessingException {
        if (uri == null || uri.getQuery() == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> result = new HashMap<String, String>();
        String[] stringArray = uri.getQuery().split("&");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String param = stringArray[n2];
            String[] parts = StringUtility.split(param, "=");
            if (parts.length != 2) {
                throw new ProcessingException("invalid query parameter: '" + param + "'");
            }
            try {
                String value;
                String key;
                String existingMapping;
                if (encoding == null) {
                    encoding = ISO_8859_1;
                }
                if ((existingMapping = result.put(key = URLDecoder.decode(parts[0], encoding), value = URLDecoder.decode(parts[1], encoding))) != null) {
                    LOG.warn("parameter key is used multiple times [key='" + key + "', oldValue='" + existingMapping + "', newValue='" + value + "'");
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new ProcessingException("unsupported encoding '" + encoding + "'", e);
            }
            ++n2;
        }
        return result;
    }

    public static String[] getPath(URI uri) {
        if (uri == null || uri.getPath() == null) {
            return new String[0];
        }
        String path = uri.getPath();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        return StringUtility.split(path, "/");
    }

    public static URI urlToUri(URL url) throws ProcessingException {
        if (url == null) {
            return null;
        }
        try {
            return url.toURI();
        }
        catch (URISyntaxException e) {
            throw new ProcessingException("Exception while converting URL to URI", e);
        }
    }

    public static URL uriToUrl(URI uri) throws ProcessingException {
        if (uri == null) {
            return null;
        }
        try {
            return uri.toURL();
        }
        catch (MalformedURLException e) {
            throw new ProcessingException("Exception while converting URI to URL", e);
        }
    }

    public static URI toUri(String uri) throws ProcessingException {
        if (!StringUtility.hasText(uri)) {
            return null;
        }
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new ProcessingException("Exception while parsing URI", e);
        }
    }

    public static URL toUrl(String url) throws ProcessingException {
        if (!StringUtility.hasText(url)) {
            return null;
        }
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new ProcessingException("Exception while parsing URL", e);
        }
    }
}

