/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons.beans;

import java.util.Collections;
import java.util.Map;
import org.eclipse.scout.commons.beans.FastBeanUtility;
import org.eclipse.scout.commons.beans.FastPropertyDescriptor;

public class FastBeanInfo {
    private final Class beanClass;
    private final Map<String, FastPropertyDescriptor> propertyMap;
    private final FastPropertyDescriptor[] propertyArray;

    public FastBeanInfo(Class<?> beanClass, Class<?> stopClass) {
        this.beanClass = beanClass;
        this.propertyMap = Collections.unmodifiableMap(FastBeanUtility.createPropertyDescriptorMap(beanClass, stopClass));
        this.propertyArray = this.propertyMap.values().toArray(new FastPropertyDescriptor[this.propertyMap.size()]);
    }

    public Class getBeanClass() {
        return this.beanClass;
    }

    public Map<String, FastPropertyDescriptor> getPropertyDescriptorMap() {
        return this.propertyMap;
    }

    public FastPropertyDescriptor getPropertyDescriptor(String name) {
        FastPropertyDescriptor p = this.propertyMap.get(name);
        if (p == null && name.length() > 0) {
            p = Character.isUpperCase(name.charAt(0)) ? this.propertyMap.get(String.valueOf(Character.toLowerCase(name.charAt(0))) + name.substring(1)) : this.propertyMap.get(String.valueOf(Character.toUpperCase(name.charAt(0))) + name.substring(1));
        }
        return p;
    }

    public FastPropertyDescriptor[] getPropertyDescriptors() {
        return this.propertyArray;
    }
}

