/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons.job;

import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.scout.commons.exception.ProcessingException;

public abstract class JobEx
extends Job {
    private IStatus m_statusOfRunNow;

    public JobEx(String name) {
        super(name);
    }

    public final boolean shouldRun() {
        this.m_statusOfRunNow = null;
        return super.shouldRun();
    }

    public IStatus runNow(IProgressMonitor monitor) {
        this.m_statusOfRunNow = null;
        this.m_statusOfRunNow = this.run(monitor);
        return this.m_statusOfRunNow;
    }

    public void throwOnError() throws ProcessingException {
        IStatus status = this.getResult();
        if (status == null) {
            status = this.m_statusOfRunNow;
        }
        if (status != null && status.getException() != null) {
            Throwable t = status.getException();
            if (t instanceof ProcessingException) {
                throw (ProcessingException)t;
            }
            throw new ProcessingException("Unexpected", t);
        }
    }

    public IProgressMonitor getMonitor() {
        IProgressMonitor monitor = null;
        if (this.getState() == 4) {
            try {
                Method m = Job.class.getSuperclass().getDeclaredMethod("getProgressMonitor", new Class[0]);
                m.setAccessible(true);
                Object result = m.invoke((Object)this, new Object[0]);
                if (result instanceof IProgressMonitor) {
                    monitor = (IProgressMonitor)result;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return monitor;
    }

    public static boolean isCurrentJobCanceled() {
        IProgressMonitor monitor;
        Job job = JobEx.getJobManager().currentJob();
        if (job instanceof JobEx && (monitor = ((JobEx)job).getMonitor()) != null) {
            return monitor.isCanceled();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void join(long millis) throws InterruptedException {
        if (millis <= 0L) {
            this.join();
            return;
        }
        int state = this.getState();
        if (state == 0) {
            return;
        }
        if (state == 4 && this.getThread() == Thread.currentThread()) {
            throw new IllegalStateException("Job attempted to join itself");
        }
        final AtomicBoolean jobDoneLock = new AtomicBoolean();
        JobChangeAdapter listener = new JobChangeAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void done(IJobChangeEvent event) {
                AtomicBoolean atomicBoolean = jobDoneLock;
                synchronized (atomicBoolean) {
                    jobDoneLock.set(true);
                    jobDoneLock.notifyAll();
                }
            }
        };
        try {
            this.addJobChangeListener((IJobChangeListener)listener);
            if (this.getState() == 0) {
                return;
            }
            long endTime = System.currentTimeMillis() + millis;
            AtomicBoolean atomicBoolean = jobDoneLock;
            synchronized (atomicBoolean) {
                while (!jobDoneLock.get()) {
                    long dt = endTime - System.currentTimeMillis();
                    if (dt <= 0L) {
                        return;
                    }
                    jobDoneLock.wait(dt);
                }
                return;
            }
        }
        finally {
            this.removeJobChangeListener((IJobChangeListener)listener);
        }
    }
}

