/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons.osgi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.scout.commons.internal.Activator;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public final class BundleInspector {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(BundleInspector.class);

    private BundleInspector() {
    }

    public static Bundle[] getBundleDependencyTree(Bundle rootBundle) {
        ArrayList<Bundle> list = new ArrayList<Bundle>();
        ArrayList<Bundle> parents = new ArrayList<Bundle>();
        if (rootBundle != null) {
            list.add(rootBundle);
            parents.add(rootBundle);
        }
        while (parents.size() > 0) {
            ArrayList<Bundle> nextParents = new ArrayList<Bundle>();
            for (Bundle bundle : parents) {
                try {
                    ManifestElement[] bundleNames = ManifestElement.parseHeader((String)"Require-Bundle", (String)((String)bundle.getHeaders().get("Require-Bundle")));
                    if (bundleNames == null) continue;
                    int i = 0;
                    while (i < bundleNames.length) {
                        Bundle child = Platform.getBundle((String)bundleNames[i].getValue());
                        if (child != null && !list.contains(child)) {
                            list.add(child);
                            nextParents.add(child);
                        }
                        ++i;
                    }
                }
                catch (BundleException e) {
                    LOG.warn(null, e);
                }
            }
            parents = nextParents;
        }
        return list.toArray(new Bundle[0]);
    }

    public static Bundle[] getOrderedBundleList(String ... prefixList) {
        Bundle bundle;
        Bundle[] allBundles = Activator.getDefault() != null ? Activator.getDefault().getBundle().getBundleContext().getBundles() : new Bundle[]{};
        if (allBundles == null || allBundles.length == 0) {
            return new Bundle[0];
        }
        HashSet<Bundle> leafBundles = new HashSet<Bundle>();
        HashMap<String, Bundle> allBundleMap = new HashMap<String, Bundle>();
        HashMap bundleDependencies = new HashMap();
        Object object = allBundles;
        int n = allBundles.length;
        int n2 = 0;
        while (n2 < n) {
            bundle = object[n2];
            allBundleMap.put(bundle.getSymbolicName(), bundle);
            leafBundles.add(bundle);
            ++n2;
        }
        object = allBundles;
        n = allBundles.length;
        n2 = 0;
        while (n2 < n) {
            bundle = object[n2];
            try {
                ArrayList<Bundle> bundleDependencyList = new ArrayList<Bundle>();
                bundleDependencies.put(bundle, bundleDependencyList);
                ManifestElement[] bundleNames = ManifestElement.parseHeader((String)"Require-Bundle", (String)((String)bundle.getHeaders().get("Require-Bundle")));
                if (bundleNames != null) {
                    ManifestElement[] manifestElementArray = bundleNames;
                    int n3 = bundleNames.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ManifestElement bundleName = manifestElementArray[n4];
                        Bundle dependingBundle = (Bundle)allBundleMap.get(bundleName.getValue());
                        leafBundles.remove(dependingBundle);
                        if (dependingBundle != null) {
                            bundleDependencyList.add(dependingBundle);
                        }
                        ++n4;
                    }
                }
            }
            catch (BundleException e) {
                LOG.warn(null, e);
            }
            ++n2;
        }
        ArrayList leafBundleList = new ArrayList(leafBundles);
        if (prefixList != null && prefixList.length > 0) {
            P_BundleNamePrefixComparator bundleComparator = new P_BundleNamePrefixComparator(prefixList);
            Collections.sort(leafBundleList, bundleComparator);
        }
        ArrayList orderedBundles = new ArrayList();
        for (Bundle leafBundle : leafBundleList) {
            ArrayList<Bundle> currentLeafBundleList = new ArrayList<Bundle>();
            ArrayList<Bundle> parents = new ArrayList<Bundle>();
            currentLeafBundleList.add(leafBundle);
            parents.add(leafBundle);
            while (parents.size() > 0) {
                ArrayList<Bundle> nextParents = new ArrayList<Bundle>();
                for (Bundle bundle2 : parents) {
                    for (Bundle bundleDep : (List)bundleDependencies.get(bundle2)) {
                        if (currentLeafBundleList.contains(bundleDep)) continue;
                        currentLeafBundleList.add(bundleDep);
                        if (orderedBundles.contains(bundleDep)) continue;
                        nextParents.add(bundleDep);
                    }
                }
                parents = nextParents;
            }
            if (orderedBundles.isEmpty()) {
                orderedBundles.addAll(currentLeafBundleList);
                continue;
            }
            int curStart = 0;
            int curEnd = 0;
            for (Bundle bundle3 : currentLeafBundleList) {
                if (orderedBundles.contains(bundle3)) {
                    if (curStart != curEnd) {
                        int insertIndex = orderedBundles.indexOf(bundle3);
                        orderedBundles.addAll(insertIndex, currentLeafBundleList.subList(curStart, curEnd));
                    }
                    curStart = ++curEnd;
                    continue;
                }
                ++curEnd;
            }
            if (curStart == curEnd) continue;
            orderedBundles.addAll(currentLeafBundleList.subList(curStart, curEnd));
        }
        return orderedBundles.toArray(new Bundle[orderedBundles.size()]);
    }

    public static Bundle getHostBundle(Bundle bundle) {
        if (bundle == null) {
            return null;
        }
        if (!Platform.isFragment((Bundle)bundle)) {
            return bundle;
        }
        try {
            ManifestElement[] hostBundles = ManifestElement.parseHeader((String)"Fragment-Host", (String)((String)bundle.getHeaders().get("Fragment-Host")));
            String hostBundleName = hostBundles[0].getValue();
            return Platform.getBundle((String)hostBundleName);
        }
        catch (Exception e) {
            LOG.warn("Could not resolve host of fragment bundle [" + bundle.getBundleId() + "]", e);
            return null;
        }
    }

    public static Bundle[] filterPluginBundles(Bundle ... bundles) {
        if (bundles == null) {
            return new Bundle[0];
        }
        ArrayList<Bundle> filteredBundles = new ArrayList<Bundle>();
        Bundle[] bundleArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle b = bundleArray[n2];
            if (!(b == null || Platform.isFragment((Bundle)b) && (b = BundleInspector.getHostBundle(b)) == null || filteredBundles.contains(b))) {
                filteredBundles.add(b);
            }
            ++n2;
        }
        return filteredBundles.toArray(new Bundle[filteredBundles.size()]);
    }

    public static abstract class BundleComparator
    implements Comparator<Bundle> {
        @Override
        public int compare(Bundle b1, Bundle b2) {
            int b2SortIndex;
            int b1SortIndex = this.getBundleSortIndex(b1, b1.getSymbolicName());
            if (b1SortIndex == (b2SortIndex = this.getBundleSortIndex(b2, b2.getSymbolicName()))) {
                return 0;
            }
            if (b1SortIndex < b2SortIndex) {
                return -1;
            }
            return 1;
        }

        protected abstract int getBundleSortIndex(Bundle var1, String var2);
    }

    private static final class P_BundleNamePrefixComparator
    implements Comparator<Bundle> {
        private final String[] prefixList;

        private P_BundleNamePrefixComparator(String ... prefixList) {
            if (prefixList == null) {
                throw new IllegalArgumentException("prefixList must not be null.");
            }
            this.prefixList = prefixList;
        }

        @Override
        public int compare(Bundle b1, Bundle b2) {
            int b2SortIndex;
            int b1SortIndex = this.getBundleSortIndex(b1);
            if (b1SortIndex == (b2SortIndex = this.getBundleSortIndex(b2))) {
                return 0;
            }
            if (b1SortIndex < b2SortIndex) {
                return -1;
            }
            return 1;
        }

        private int getBundleSortIndex(Bundle bundle) {
            int i = 0;
            while (i < this.prefixList.length) {
                String symbolicName = bundle.getSymbolicName();
                if (symbolicName.startsWith(this.prefixList[i])) {
                    return i;
                }
                ++i;
            }
            return Integer.MAX_VALUE;
        }
    }
}

