/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.http.servletfilter.security;

import java.security.Principal;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class SecureHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private static List<String> AUTH_TYPES = Arrays.asList("BASIC_AUTH", "FORM_AUTH", "CLIENT_CERT_AUTH", "DIGEST_AUTH", "NTLM");
    private final Principal m_principal;
    private final String m_authType;

    public SecureHttpServletRequestWrapper(HttpServletRequest req, Principal principal) {
        this(req, principal, null);
    }

    public SecureHttpServletRequestWrapper(HttpServletRequest req, Principal principal, String authType) {
        super(req);
        this.m_principal = principal;
        if (authType != null && !AUTH_TYPES.contains(authType)) {
            authType = null;
        }
        if (authType == null) {
            authType = req.getAuthType();
        }
        if (authType == null) {
            authType = AUTH_TYPES.get(0);
        }
        this.m_authType = authType;
    }

    public String getRemoteUser() {
        return this.m_principal.getName();
    }

    public Principal getUserPrincipal() {
        return this.m_principal;
    }

    public String getAuthType() {
        return this.m_authType;
    }
}

