/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.http.servletfilter.security;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class WrappedServletResponse
extends HttpServletResponseWrapper {
    private static final int TYPE_ADD = 1;
    private static final int TYPE_SET = 2;
    private List<P_HeaderAttribute> m_headerAttributes = new ArrayList<P_HeaderAttribute>();

    public WrappedServletResponse(HttpServletResponse response) {
        super(response);
    }

    public void setHeader(String name, String value) {
        this.m_headerAttributes.add(new P_HeaderAttribute(name, value, 2));
    }

    public void addHeader(String name, String value) {
        this.m_headerAttributes.add(new P_HeaderAttribute(name, value, 1));
    }

    public String getHeaderValue(String name) {
        for (P_HeaderAttribute att : this.m_headerAttributes) {
            if (!att.getName().equals(name)) continue;
            return att.getValue();
        }
        return null;
    }

    public void clearHeader() {
        this.m_headerAttributes.clear();
    }

    public void flushBuffer() throws IOException {
    }

    public void setStatus(int sc) {
    }

    public HttpServletResponse getResponse() {
        return (HttpServletResponse)super.getResponse();
    }

    public void applyHeader() {
        for (P_HeaderAttribute att : this.m_headerAttributes) {
            switch (att.getType()) {
                case 1: {
                    this.getResponse().addHeader(att.getName(), att.getValue());
                    break;
                }
                case 2: {
                    this.getResponse().setHeader(att.getName(), att.getValue());
                }
            }
        }
    }

    private class P_HeaderAttribute {
        private final String m_name;
        private final String m_value;
        private final int m_type;

        public P_HeaderAttribute(String name, String value, int type) {
            this.m_name = name;
            this.m_value = value;
            this.m_type = type;
        }

        public String getName() {
            return this.m_name;
        }

        public String getValue() {
            return this.m_value;
        }

        public int getType() {
            return this.m_type;
        }
    }
}

