/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.jaxws.security.provider;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.eclipse.scout.commons.Base64Utility;
import org.eclipse.scout.commons.BooleanUtility;
import org.eclipse.scout.commons.TypeCastUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.jaxws.annotation.ScoutTransaction;
import org.eclipse.scout.jaxws.internal.ContextHelper;
import org.eclipse.scout.jaxws.internal.SessionHelper;
import org.eclipse.scout.jaxws.security.Authenticator;
import org.eclipse.scout.jaxws.security.provider.IAuthenticationHandler;
import org.eclipse.scout.jaxws.security.provider.ICredentialValidationStrategy;
import org.eclipse.scout.jaxws.session.IServerSessionFactory;
import org.eclipse.scout.rt.server.IServerSession;
import org.eclipse.scout.service.ServiceUtility;

@ScoutTransaction
public class BasicAuthenticationHandler
implements IAuthenticationHandler {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(BasicAuthenticationHandler.class);
    private ICredentialValidationStrategy m_credentialValidationStrategy;

    public BasicAuthenticationHandler() {
        ServiceUtility.injectConfigProperties((Object)this);
    }

    public final boolean handleMessage(SOAPMessageContext context) {
        boolean outbound = (Boolean)TypeCastUtility.castValue((Object)context.get((Object)"javax.xml.ws.handler.message.outbound"), Boolean.TYPE);
        if (outbound) {
            return true;
        }
        if (Authenticator.isSubjectAuthenticated()) {
            return true;
        }
        String[] authorizationHeader = this.getAuthorizationHeader(context);
        if (authorizationHeader.length == 0) {
            this.installAuthHeader(context);
            return this.breakHandlerChain(context);
        }
        String[] stringArray = authorizationHeader;
        int n = authorizationHeader.length;
        int n2 = 0;
        while (n2 < n) {
            String headerValue = stringArray[n2];
            if (headerValue.startsWith("Basic ")) {
                block9: {
                    try {
                        if (!this.authenticateRequest(headerValue)) break block9;
                        IServerSessionFactory portTypeSessionFactory = ContextHelper.getPortTypeSessionFactory((MessageContext)context);
                        IServerSession serverSession = SessionHelper.createNewServerSession(portTypeSessionFactory);
                        if (serverSession != null) {
                            ContextHelper.setContextSession((MessageContext)context, portTypeSessionFactory, serverSession);
                        }
                        return true;
                    }
                    catch (Exception e) {
                        return this.breakHandlerChainWithException(context, e);
                    }
                }
                return this.breakHandlerChain(context);
            }
            ++n2;
        }
        return this.breakHandlerChain(context);
    }

    @Override
    public void injectCredentialValidationStrategy(ICredentialValidationStrategy strategy) {
        this.m_credentialValidationStrategy = strategy;
    }

    public final Set<QName> getHeaders() {
        return new HashSet<QName>();
    }

    public final void close(MessageContext context) {
    }

    public final boolean handleFault(SOAPMessageContext context) {
        return false;
    }

    protected boolean authenticateRequest(String authHeader) throws Exception {
        String[] credentials = new String(Base64Utility.decode((String)authHeader.substring("Basic ".length())), "ISO-8859-1").split(":", 2);
        String username = credentials[0];
        String passwordPlainText = credentials[1];
        return Authenticator.authenticateRequest(this.m_credentialValidationStrategy, username, passwordPlainText);
    }

    protected void installAuthHeader(SOAPMessageContext context) {
        Map<String, List<String>> httpResponseHeaders = this.getHttpResponseHeaders(context);
        if (httpResponseHeaders == null) {
            httpResponseHeaders = new HashMap<String, List<String>>();
        }
        LinkedList<String> basicAuthToken = new LinkedList<String>();
        basicAuthToken.add("Basic realm=\"" + this.getRealm() + "\"");
        httpResponseHeaders.put("WWW-Authenticate", basicAuthToken);
        context.put((Object)"javax.xml.ws.http.response.code", (Object)401);
        context.put((Object)"javax.xml.ws.http.response.headers", httpResponseHeaders);
    }

    protected Map<String, List<String>> getHttpRequestHeaders(SOAPMessageContext context) {
        return (Map)context.get((Object)"javax.xml.ws.http.request.headers");
    }

    protected Map<String, List<String>> getHttpResponseHeaders(SOAPMessageContext context) {
        return (Map)context.get((Object)"javax.xml.ws.http.response.headers");
    }

    protected boolean breakHandlerChain(SOAPMessageContext context) {
        context.put((Object)"javax.xml.ws.http.response.code", (Object)401);
        boolean oneway = BooleanUtility.nvl((Boolean)((Boolean)context.get((Object)"com.sun.xml.internal.ws.server.OneWayOperation")), (boolean)false);
        if (oneway) {
            throw new WebServiceException("Unauthorized");
        }
        return false;
    }

    protected boolean breakHandlerChainWithException(SOAPMessageContext context, Exception exception) {
        context.put((Object)"javax.xml.ws.http.response.code", (Object)500);
        LOG.error("Internal server error  (Basic Access Authentication)", (Throwable)exception);
        if (exception instanceof WebServiceException) {
            throw (WebServiceException)exception;
        }
        throw new WebServiceException("Internal server error");
    }

    protected String getRealm() {
        return "Secure Area";
    }

    protected String[] getAuthorizationHeader(SOAPMessageContext context) {
        Map<String, List<String>> httpRequestHeaderMap = this.getHttpRequestHeaders(context);
        if (httpRequestHeaderMap == null || httpRequestHeaderMap.size() == 0) {
            return new String[0];
        }
        for (String headerName : httpRequestHeaderMap.keySet()) {
            if (!"authorization".equalsIgnoreCase(headerName)) continue;
            List<String> headerValues = httpRequestHeaderMap.get(headerName);
            if (headerValues != null) {
                return headerValues.toArray(new String[headerValues.size()]);
            }
            return new String[0];
        }
        return new String[0];
    }

    @Override
    public String getName() {
        return "BASIC";
    }
}

