/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.internal.jdt;

import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.core.search.TypeDeclarationMatch;
import org.eclipse.scout.commons.CompositeLong;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.nls.sdk.internal.NlsCore;

public final class NlsTypeUtility {
    private NlsTypeUtility() {
    }

    public static IType getType(String fullyQualifiedName) {
        if (StringUtility.isNullOrEmpty((String)fullyQualifiedName)) {
            return null;
        }
        fullyQualifiedName = fullyQualifiedName.replaceAll("\\$", "\\.");
        IType type = null;
        try {
            type = NlsTypeUtility.resolveType(fullyQualifiedName);
        }
        catch (CoreException e) {
            NlsCore.logError("error during resolving type '" + fullyQualifiedName + "'.", e);
        }
        return type;
    }

    private static IType resolveType(final String fqn) throws CoreException {
        final TreeMap matchList = new TreeMap();
        String fastPat = fqn.replaceAll("\\$", "\\.");
        int i = fastPat.lastIndexOf(46);
        if (i >= 0) {
            fastPat = fastPat.substring(i + 1);
        }
        if (!StringUtility.hasText((String)fastPat)) {
            return null;
        }
        new SearchEngine().search(SearchPattern.createPattern((String)fastPat, (int)0, (int)0, (int)0), new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, SearchEngine.createWorkspaceScope(), new SearchRequestor(){

            public final void acceptSearchMatch(SearchMatch match) throws CoreException {
                TypeDeclarationMatch typeMatch;
                IType t;
                if (match instanceof TypeDeclarationMatch && (t = (IType)(typeMatch = (TypeDeclarationMatch)match).getElement()).getFullyQualifiedName('.').indexOf(fqn) >= 0) {
                    matchList.put(new CompositeLong((long)(t.isBinary() ? 1 : 0), (long)matchList.size()), t);
                }
            }
        }, null);
        if (matchList.size() > 1) {
            NlsCore.logWarning("found more than one type matches for '" + fqn + "' (matches: '" + matchList.size() + "').");
        } else if (matchList.size() < 1) {
            return null;
        }
        return (IType)matchList.firstEntry().getValue();
    }
}

