/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.internal.model;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeListenerProxy;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.eclipse.scout.nls.sdk.internal.NlsCore;

public class PropertySupport {
    public static final int DEFAULT_INT_VALUE = 0;
    public static final int DEFAULT_DOUBLE_VALUE = 0;
    public static final Integer DEFAULT_INT = new Integer(0);
    public static final Double DEFAULT_DOUBLE = new Double(0.0);
    public static final long DEFAULT_LONG_VALUE = 0L;
    public static final Long DEFAULT_LONG = new Long(0L);
    private static final Boolean DEFAULT_BOOL = new Boolean(false);
    private HashMap<String, Object> m_props = new HashMap();
    private Object m_source;
    private transient Vector<PropertyChangeListener> m_listeners;
    private Hashtable<String, Object> m_children;

    public PropertySupport(Object sourceBean) {
        this.m_source = sourceBean;
    }

    public void clearProperties() {
        this.m_props.clear();
    }

    public void clearPropertiesFire() {
        ArrayList<String> keys = new ArrayList<String>(this.m_props.keySet());
        for (String key : keys) {
            this.firePropertyChange(key, this.m_props.get(key), null);
            this.m_props.remove(key);
        }
    }

    public void removeProperty(String key) {
        this.m_props.remove(key);
        this.firePropertyChange(key, this.m_props.get(key), null);
    }

    public Map<String, Object> getPropertiesMap() {
        int i = 0;
        while (i < 10) {
            try {
                return new HashMap<String, Object>(this.m_props);
            }
            catch (ConcurrentModificationException cme) {
                NlsCore.logWarning(cme);
                ++i;
            }
        }
        return new HashMap<String, Object>(this.m_props);
    }

    public void putPropertiesMap(Map<String, Object> map) {
        this.m_props.putAll(map);
    }

    public boolean hasProperty(String name) {
        return this.m_props.containsKey(name);
    }

    public void setPropertyInt(String name, int i) {
        this.setProperty(name, new Integer(i), DEFAULT_INT);
    }

    public int getPropertyInt(String name) {
        Number n = (Number)this.getProperty(name);
        return n != null ? n.intValue() : 0;
    }

    public void setPropertyDouble(String name, double d) {
        this.setProperty(name, new Double(d), DEFAULT_DOUBLE);
    }

    public double getPropertyDouble(String name) {
        Number n = (Number)this.getProperty(name);
        return n != null ? n.doubleValue() : 0.0;
    }

    public void setPropertyFloat(String name, float d) {
        this.setProperty(name, new Float(d), DEFAULT_DOUBLE);
    }

    public float getPropertyFloat(String name) {
        Number n = (Number)this.getProperty(name);
        return n != null ? n.floatValue() : 0.0f;
    }

    public void setPropertyLong(String name, long i) {
        this.setProperty(name, new Long(i), DEFAULT_LONG);
    }

    public long getPropertyLong(String name) {
        Number n = (Number)this.getProperty(name);
        return n != null ? n.longValue() : DEFAULT_LONG.longValue();
    }

    public boolean setPropertyBool(String name, boolean b) {
        return this.setProperty(name, new Boolean(b), DEFAULT_BOOL);
    }

    public boolean getPropertyBool(String name) {
        Boolean b = (Boolean)this.getProperty(name);
        return b != null ? b.booleanValue() : DEFAULT_BOOL.booleanValue();
    }

    public void setPropertyString(String name, String s) {
        this.setProperty(name, s);
    }

    public void setPropertyStringAlwaysFire(String name, String s) {
        this.setPropertyAlwaysFire(name, s);
    }

    public String getPropertyString(String name) {
        String s = (String)this.getProperty(name);
        return s;
    }

    public Object getProperty(String name) {
        return this.m_props.get(name);
    }

    public boolean setProperty(String name, Object newValue) {
        return this.setProperty(name, newValue, null);
    }

    public boolean setPropertyNoFire(String name, Object newValue) {
        Object oldValue = this.m_props.get(name);
        this.m_props.put(name, newValue);
        return oldValue != newValue && (oldValue == null || !oldValue.equals(newValue));
    }

    public boolean setProperty(String name, Object newValue, Object defaultOldValueWhenNull) {
        Object oldValue = this.m_props.get(name);
        if (oldValue == null) {
            oldValue = defaultOldValueWhenNull;
        }
        this.m_props.put(name, newValue);
        if (oldValue == newValue || oldValue != null && oldValue.equals(newValue)) {
            return false;
        }
        this.firePropertyChangeImpl(name, oldValue, newValue);
        return true;
    }

    public void setPropertyAlwaysFire(String name, Object newValue) {
        Object oldValue = this.m_props.get(name);
        this.m_props.put(name, newValue);
        this.firePropertyChangeImpl(name, oldValue, newValue);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener instanceof PropertyChangeListenerProxy) {
            PropertyChangeListenerProxy proxy = (PropertyChangeListenerProxy)listener;
            this.addPropertyChangeListener(proxy.getPropertyName(), (PropertyChangeListener)proxy.getListener());
        } else {
            if (this.m_listeners == null) {
                this.m_listeners = new Vector();
            }
            this.m_listeners.addElement(listener);
        }
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener instanceof PropertyChangeListenerProxy) {
            PropertyChangeListenerProxy proxy = (PropertyChangeListenerProxy)listener;
            this.removePropertyChangeListener(proxy.getPropertyName(), (PropertyChangeListener)proxy.getListener());
        } else {
            if (this.m_listeners == null) {
                return;
            }
            this.m_listeners.removeElement(listener);
        }
    }

    public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        PropertySupport child;
        if (this.m_children == null) {
            this.m_children = new Hashtable();
        }
        if ((child = (PropertySupport)this.m_children.get(propertyName)) == null) {
            child = new PropertySupport(this.m_source);
            this.m_children.put(propertyName, child);
        }
        child.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (this.m_children == null) {
            return;
        }
        PropertySupport child = (PropertySupport)this.m_children.get(propertyName);
        if (child == null) {
            return;
        }
        child.removePropertyChangeListener(listener);
    }

    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
        if (oldValue == newValue) {
            return;
        }
        this.firePropertyChangeImpl(propertyName, new Integer(oldValue), new Integer(newValue));
    }

    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        if (oldValue == newValue) {
            return;
        }
        this.firePropertyChangeImpl(propertyName, oldValue, newValue);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (oldValue != null && newValue != null && oldValue.equals(newValue)) {
            return;
        }
        this.firePropertyChangeImpl(propertyName, oldValue, newValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePropertyChangeImpl(String propertyName, Object oldValue, Object newValue) {
        Vector targets = null;
        PropertySupport child = null;
        PropertySupport propertySupport = this;
        synchronized (propertySupport) {
            if (this.m_listeners != null) {
                targets = (Vector)this.m_listeners.clone();
            }
            if (this.m_children != null && propertyName != null) {
                child = (PropertySupport)this.m_children.get(propertyName);
            }
        }
        PropertyChangeEvent evt = null;
        if (targets != null) {
            if (evt == null) {
                evt = new PropertyChangeEvent(this.m_source, propertyName, oldValue, newValue);
            }
            int i = 0;
            while (i < targets.size()) {
                Object o = targets.elementAt(i);
                PropertyChangeListener target = null;
                target = o instanceof WeakReference ? (PropertyChangeListener)((WeakReference)o).get() : (PropertyChangeListener)o;
                if (target != null) {
                    target.propertyChange(evt);
                }
                ++i;
            }
        }
        if (child != null) {
            if (evt == null) {
                evt = new PropertyChangeEvent(this.m_source, propertyName, oldValue, newValue);
            }
            child.firePropertyChangeImpl(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePropertyChangeImpl(PropertyChangeEvent evt) {
        Object oldValue = evt.getOldValue();
        Object newValue = evt.getNewValue();
        String propertyName = evt.getPropertyName();
        if (oldValue != null && newValue != null && oldValue.equals(newValue)) {
            return;
        }
        Vector targets = null;
        PropertySupport child = null;
        PropertySupport propertySupport = this;
        synchronized (propertySupport) {
            if (this.m_listeners != null) {
                targets = (Vector)this.m_listeners.clone();
            }
            if (this.m_children != null && propertyName != null) {
                child = (PropertySupport)this.m_children.get(propertyName);
            }
        }
        if (targets != null) {
            int i = 0;
            while (i < targets.size()) {
                Object o = targets.elementAt(i);
                PropertyChangeListener target = null;
                target = o instanceof WeakReference ? (PropertyChangeListener)((WeakReference)o).get() : (PropertyChangeListener)o;
                if (target != null) {
                    target.propertyChange(evt);
                }
                ++i;
            }
        }
        if (child != null) {
            child.firePropertyChangeImpl(evt);
        }
    }

    public synchronized boolean hasListeners(String propertyName) {
        PropertySupport child;
        if (this.m_listeners != null && !this.m_listeners.isEmpty()) {
            return true;
        }
        if (this.m_children != null && (child = (PropertySupport)this.m_children.get(propertyName)) != null && child.m_listeners != null) {
            return !child.m_listeners.isEmpty();
        }
        return false;
    }
}

