/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.internal.ui.dialog;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.scout.nls.sdk.internal.NlsCore;
import org.eclipse.scout.nls.sdk.internal.ui.TextField;
import org.eclipse.scout.nls.sdk.internal.ui.dialog.AbstractNlsEntryDialog;
import org.eclipse.scout.nls.sdk.internal.ui.formatter.IValidationListener;
import org.eclipse.scout.nls.sdk.model.workspace.NlsEntry;
import org.eclipse.scout.nls.sdk.model.workspace.project.INlsProject;
import org.eclipse.scout.nls.sdk.ui.InputValidator;
import org.eclipse.swt.widgets.Shell;

public class NlsEntryModifyDialog
extends AbstractNlsEntryDialog {
    public NlsEntryModifyDialog(Shell parentShell, NlsEntry row, INlsProject project) {
        super(parentShell, "Modify Entry", row, project, false);
    }

    @Override
    protected void postCreate() {
        this.getKeyField().setInputValidator(InputValidator.getNlsKeyValidator(this.getNlsProject(), new String[]{this.getNlsEntry().getKey()}));
        this.getKeyField().setEnabled(false);
        TextField<String> defaultField = this.getDefaultTranslationField();
        defaultField.setInputValidator(InputValidator.getDefaultTranslationValidator());
        defaultField.addValidationListener(new IValidationListener(){

            @Override
            public void validationChanged(IStatus valid) {
                NlsEntryModifyDialog.this.revalidate();
            }
        });
        this.revalidate();
    }

    @Override
    protected void revalidate() {
        MultiStatus status = new MultiStatus("org.eclipse.scout.nls.sdk", -1, "multi status", null);
        status.add(this.getKeyField().getStatus());
        status.add(this.getDefaultTranslationField().getStatus());
        IStatus highestSeverity = NlsCore.getHighestSeverityStatus((IStatus)status);
        if (highestSeverity.isOK()) {
            this.setMessage("Modify this Translation entry.");
        } else {
            this.setMessage(highestSeverity);
        }
        this.getButton(0).setEnabled(highestSeverity.getSeverity() != 4);
    }
}

