/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.mobile.ui.action;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.scout.rt.client.mobile.ui.action.ButtonWrappingAction;
import org.eclipse.scout.rt.client.mobile.ui.form.IMobileAction;
import org.eclipse.scout.rt.client.mobile.ui.form.outline.AutoLeafPageWithNodes;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPage;
import org.eclipse.scout.rt.client.ui.form.fields.button.IButton;

public class ActionButtonBarUtility {
    public static List<IMobileAction> convertButtonsToActions(IButton[] buttons) {
        LinkedList<IMobileAction> menuList = new LinkedList<IMobileAction>();
        IButton[] iButtonArray = buttons;
        int n = buttons.length;
        int n2 = 0;
        while (n2 < n) {
            IButton button = iButtonArray[n2];
            IMobileAction action = ActionButtonBarUtility.convertButtonToAction(button);
            if (action != null) {
                menuList.add(action);
            }
            ++n2;
        }
        return menuList;
    }

    public static IMobileAction convertButtonToAction(IButton button) {
        if (button == null) {
            return null;
        }
        return new ButtonWrappingAction(button);
    }

    public static void distributeRowActions(List<IMenu> menuList, IMenu[] emptySpaceMenus, List<IMenu> rowMenuList) {
        if (emptySpaceMenus == null) {
            return;
        }
        IMenu[] iMenuArray = emptySpaceMenus;
        int n = emptySpaceMenus.length;
        int n2 = 0;
        while (n2 < n) {
            IMenu emptySpaceMenu = iMenuArray[n2];
            if (rowMenuList.size() == 0) break;
            int index = menuList.indexOf(emptySpaceMenu) + 1;
            IMenu rowMenu = rowMenuList.get(0);
            menuList.add(index, rowMenu);
            rowMenuList.remove(rowMenu);
            ++n2;
        }
    }

    public static List<IMenu> fetchPageActions(IPage page) {
        LinkedList<IMenu> pageActions = new LinkedList<IMenu>();
        if (page.getTree() != null) {
            pageActions.addAll(Arrays.asList(page.getTree().fetchMenusForNodesInternal(new ITreeNode[]{page})));
            if (page instanceof AutoLeafPageWithNodes) {
                pageActions.addAll(Arrays.asList(((AutoLeafPageWithNodes)page).getTableRow().getTable().getUIFacade().fireRowPopupFromUI()));
            }
        }
        return pageActions;
    }
}

