/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.mobile.ui.desktop;

import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.ClientJob;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.ui.action.tool.IToolButton;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.desktop.outline.AbstractFormToolButton;
import org.eclipse.scout.rt.client.ui.desktop.outline.IOutline;
import org.eclipse.scout.rt.client.ui.desktop.outline.IOutlineTableForm;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPage;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPageWithNodes;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPageWithTable;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.fields.GridData;

public class MobileDesktopUtility {
    public static void activateOutline(IOutline outline) {
        IDesktop desktop = ClientJob.getCurrentSession().getDesktop();
        desktop.setOutlineTableFormVisible(true);
        if (desktop.getOutline() != outline) {
            desktop.setOutline(outline);
        }
        if (!outline.isRootNodeVisible()) {
            throw new IllegalStateException("Root node must be visible for this drill down approach.");
        }
        if (outline.getSelectedNode() == null) {
            outline.selectNode((ITreeNode)outline.getRootPage());
        }
    }

    public static boolean isToolForm(IForm form) {
        return MobileDesktopUtility.getToolButtonFor(form) != null;
    }

    public static IToolButton getToolButtonFor(IForm form) {
        IToolButton[] iToolButtonArray = MobileDesktopUtility.getDesktop().getToolButtons();
        int n = iToolButtonArray.length;
        int n2 = 0;
        while (n2 < n) {
            IForm toolForm;
            IToolButton toolButton = iToolButtonArray[n2];
            if (toolButton instanceof AbstractFormToolButton && form == (toolForm = ((AbstractFormToolButton)toolButton).getForm())) {
                return toolButton;
            }
            ++n2;
        }
        return null;
    }

    public static void openToolForm(IForm form) {
        IToolButton toolButton = MobileDesktopUtility.getToolButtonFor(form);
        if (toolButton != null) {
            toolButton.setSelected(true);
        }
        if (!MobileDesktopUtility.getDesktop().isShowing(form)) {
            MobileDesktopUtility.getDesktop().addForm(form);
        }
    }

    public static void closeToolForm(IForm form) {
        IToolButton toolButton = MobileDesktopUtility.getToolButtonFor(form);
        if (toolButton != null) {
            toolButton.setSelected(false);
        }
        if (MobileDesktopUtility.getDesktop().isShowing(form)) {
            MobileDesktopUtility.getDesktop().removeForm(form);
        }
    }

    public static void closeAllToolForms() {
        IToolButton[] iToolButtonArray = MobileDesktopUtility.getDesktop().getToolButtons();
        int n = iToolButtonArray.length;
        int n2 = 0;
        while (n2 < n) {
            IToolButton toolButton = iToolButtonArray[n2];
            if (toolButton.isVisible()) {
                toolButton.setSelected(false);
            }
            ++n2;
        }
    }

    public static void closeOpenForms() throws ProcessingException {
        IForm[] viewStack;
        IForm[] iFormArray = viewStack = MobileDesktopUtility.getDesktop().getViewStack();
        int n = viewStack.length;
        int n2 = 0;
        while (n2 < n) {
            IForm form = iFormArray[n2];
            MobileDesktopUtility.closeForm(form);
            ++n2;
        }
    }

    public static void closeForm(IForm form) throws ProcessingException {
        if (form == null) {
            return;
        }
        if (MobileDesktopUtility.isToolForm(form)) {
            MobileDesktopUtility.closeToolForm(form);
        } else if (form.isAutoAddRemoveOnDesktop()) {
            form.doClose();
        } else {
            MobileDesktopUtility.removeFormFromDesktop(form);
        }
    }

    public static void removeFormFromDesktop(IForm form) {
        if (form instanceof IOutlineTableForm) {
            MobileDesktopUtility.getDesktop().setOutlineTableFormVisible(false);
        } else {
            MobileDesktopUtility.getDesktop().removeForm(form);
        }
    }

    public static void removeFormsFromDesktop(Class<? extends IForm> formClass, String displayViewId, IForm excludedForm) {
        IForm[] viewStack;
        if (displayViewId == null) {
            return;
        }
        IForm[] iFormArray = viewStack = MobileDesktopUtility.getDesktop().getViewStack();
        int n = viewStack.length;
        int n2 = 0;
        while (n2 < n) {
            IForm form = iFormArray[n2];
            if (form != excludedForm && formClass.isInstance(form) && displayViewId.equals(form.getDisplayViewId())) {
                MobileDesktopUtility.getDesktop().removeForm(form);
            }
            ++n2;
        }
    }

    public static void addFormToDesktop(IForm form) {
        if (form instanceof IOutlineTableForm) {
            MobileDesktopUtility.getDesktop().setOutlineTableForm((IOutlineTableForm)form);
            MobileDesktopUtility.getDesktop().setOutlineTableFormVisible(true);
        } else if (MobileDesktopUtility.isToolForm(form)) {
            MobileDesktopUtility.openToolForm(form);
        } else {
            MobileDesktopUtility.getDesktop().addForm(form);
        }
    }

    private static IDesktop getDesktop() {
        return ClientSyncJob.getCurrentSession().getDesktop();
    }

    public static boolean isAnyViewVisible(String displayViewId) {
        IForm[] viewStack;
        if (displayViewId == null) {
            return false;
        }
        IForm[] iFormArray = viewStack = MobileDesktopUtility.getDesktop().getViewStack();
        int n = viewStack.length;
        int n2 = 0;
        while (n2 < n) {
            IForm form = iFormArray[n2];
            if (displayViewId.equals(form.getDisplayViewId())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean setFormWidthHint(IForm form, int widthHint) {
        GridData gridDataHints = form.getRootGroupBox().getGridDataHints();
        if (gridDataHints.widthInPixel == widthHint) {
            return false;
        }
        gridDataHints.widthInPixel = widthHint;
        form.getRootGroupBox().setGridDataHints(gridDataHints);
        return true;
    }

    public static ITable getPageTable(IPage page) {
        if (page instanceof IPageWithTable) {
            IPageWithTable tablePage = (IPageWithTable)page;
            return tablePage.getTable();
        }
        if (page instanceof IPageWithNodes) {
            IPageWithNodes nodePage = (IPageWithNodes)page;
            return nodePage.getInternalTable();
        }
        return null;
    }

    public static IPage getPageFor(IPage parentPage, ITableRow tableRow) {
        ITreeNode node = null;
        if (parentPage instanceof IPageWithNodes) {
            node = ((IPageWithNodes)parentPage).getTreeNodeFor(tableRow);
        } else if (parentPage instanceof IPageWithTable) {
            node = ((IPageWithTable)parentPage).getTreeNodeFor(tableRow);
        }
        return (IPage)node;
    }

    public static ITableRow getTableRowFor(IPage parentPage, IPage page) {
        ITableRow row = null;
        if (parentPage instanceof IPageWithNodes) {
            row = ((IPageWithNodes)parentPage).getTableRowFor((ITreeNode)page);
        } else if (parentPage instanceof IPageWithTable) {
            row = ((IPageWithTable)parentPage).getTableRowFor((ITreeNode)page);
        }
        return row;
    }
}

