/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.mobile.ui.form.outline;

import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.mobile.ui.basic.table.form.TableRowForm;
import org.eclipse.scout.rt.client.ui.basic.cell.Cell;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.AbstractPageWithNodes;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPage;

public class AutoLeafPageWithNodes
extends AbstractPageWithNodes {
    private ITableRow m_tableRow;
    private IPage m_actualParentPage;

    public AutoLeafPageWithNodes(ITableRow row, IPage parentPage) {
        if (row == null) {
            throw new IllegalArgumentException("Row must not be null");
        }
        this.m_tableRow = row;
        this.m_actualParentPage = parentPage;
    }

    public ITableRow getTableRow() {
        return this.m_tableRow;
    }

    public IPage getActualParentPage() {
        return this.m_actualParentPage;
    }

    protected void execInitPage() throws ProcessingException {
        Cell cell = this.getCellForUpdate();
        if (cell.getText() == null) {
            cell.setText(this.findAppropriateTitle());
        }
        if (cell.getIconId() == null) {
            cell.setIconId(this.m_tableRow.getIconId());
        }
    }

    private String findAppropriateTitle() {
        IColumn[] iColumnArray = this.m_tableRow.getTable().getColumns();
        int n = iColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            IColumn column = iColumnArray[n2];
            if (column.isVisible()) {
                return this.m_tableRow.getTable().getCell(this.m_tableRow, column).getText();
            }
            ++n2;
        }
        return null;
    }

    protected boolean getConfiguredTableVisible() {
        return false;
    }

    protected boolean getConfiguredLeaf() {
        return true;
    }

    protected void execPageActivated() throws ProcessingException {
        if (this.getDetailForm() == null) {
            TableRowForm form = new TableRowForm(this.m_tableRow);
            this.setDetailForm(form);
            form.start();
        }
    }

    protected void execDisposePage() throws ProcessingException {
        super.execDisposePage();
        if (this.getDetailForm() != null) {
            this.getDetailForm().doClose();
            this.setDetailForm(null);
        }
    }
}

