/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.busy;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.busy.IBusyHandler;

public class BusyJob
extends Job {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(BusyJob.class);
    private final IBusyHandler m_handler;
    private boolean m_cancelApplied;

    public BusyJob(String name, IBusyHandler handler) {
        super(name);
        this.m_handler = handler;
    }

    protected IBusyHandler getBusyHandler() {
        return this.m_handler;
    }

    protected IStatus run(IProgressMonitor monitor) {
        if (!this.getBusyHandler().isBusy() || !this.getBusyHandler().isEnabled()) {
            return Status.OK_STATUS;
        }
        this.runBusy(monitor);
        if (!this.getBusyHandler().isBusy() || !this.getBusyHandler().isEnabled()) {
            return Status.OK_STATUS;
        }
        this.runBlocking(monitor);
        return Status.OK_STATUS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runBusy(IProgressMonitor monitor) {
        IBusyHandler h = this.getBusyHandler();
        Object lock = h.getStateLock();
        long longOpTimestamp = System.currentTimeMillis() + h.getLongOperationMillis() - h.getShortOperationMillis();
        while (true) {
            Object object = lock;
            synchronized (object) {
                if (!h.isBusy()) {
                    return;
                }
                if (!this.m_cancelApplied && monitor.isCanceled()) {
                    this.m_cancelApplied = true;
                    h.cancel();
                }
                if (System.currentTimeMillis() > longOpTimestamp) {
                    return;
                }
                try {
                    lock.wait(100L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void runBlocking(IProgressMonitor monitor) {
        IBusyHandler h = this.getBusyHandler();
        Object lock = h.getStateLock();
        try {
            monitor.beginTask(null, -1);
            while (true) {
                Object object = lock;
                // MONITORENTER : object
                if (h.isBusy()) break block12;
                // MONITOREXIT : object
                break;
            }
            {
                catch (Throwable throwable) {
                    // MONITOREXIT : object
                    throw throwable;
                }
            }
            {
                block12: {
                    monitor.done();
                    return;
                }
                if (!this.m_cancelApplied && monitor.isCanceled()) {
                    this.m_cancelApplied = true;
                    h.cancel();
                }
                try {
                    lock.wait(100L);
                }
                catch (InterruptedException e) {
                    // MONITOREXIT : object
                    monitor.done();
                    return;
                }
                // MONITOREXIT : object
                continue;
            }
        }
        catch (Throwable throwable) {
            monitor.done();
            throw throwable;
        }
    }
}

